/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.options;

import com.google.common.base.Preconditions;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class SearchOptions
extends BaseHttpRequestOptions {
    public SearchOptions query(String query) {
        this.queryParameters.put("q", Preconditions.checkNotNull(query, "query"));
        return this;
    }

    public SearchOptions sort(String sort) {
        this.queryParameters.put("sort", Preconditions.checkNotNull(sort, "sort"));
        return this;
    }

    public SearchOptions rows(int rows) {
        this.queryParameters.put("rows", String.valueOf(rows));
        return this;
    }

    public SearchOptions start(int start) {
        this.queryParameters.put("start", String.valueOf(start));
        return this;
    }

    public static class Builder {
        public static SearchOptions query(String query) {
            SearchOptions options = new SearchOptions();
            return options.query(query);
        }

        public static SearchOptions start(String start) {
            SearchOptions options = new SearchOptions();
            return options.sort(start);
        }

        public static SearchOptions rows(int rows) {
            SearchOptions options = new SearchOptions();
            return options.rows(rows);
        }

        public static SearchOptions start(int start) {
            SearchOptions options = new SearchOptions();
            return options.start(start);
        }
    }
}

