/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.chef.domain.CookbookDefinition;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;

@Singleton
public class ParseCookbookDefinitionListFromJson
implements Function<HttpResponse, Set<CookbookDefinition>> {
    private final ParseJson<Map<String, CookbookDefinition>> parser;

    @Inject
    ParseCookbookDefinitionListFromJson(ParseJson<Map<String, CookbookDefinition>> parser) {
        this.parser = parser;
    }

    @Override
    public Set<CookbookDefinition> apply(HttpResponse response) {
        Set<Map.Entry<String, CookbookDefinition>> result = this.parser.apply(response).entrySet();
        return Sets.newLinkedHashSet(Iterables.transform(result, new Function<Map.Entry<String, CookbookDefinition>, CookbookDefinition>(){

            @Override
            public CookbookDefinition apply(Map.Entry<String, CookbookDefinition> input) {
                String cookbookName = input.getKey();
                CookbookDefinition def = input.getValue();
                return CookbookDefinition.builder().from(def).name(cookbookName).build();
            }
        }));
    }
}

