/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.NoSuchElementException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.io.ByteStreams2;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.MultipartForm;
import org.jclouds.io.payloads.Part;
import org.jclouds.io.payloads.RSAEncryptingPayload;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.util.Strings2;

@Singleton
public class SignedHeaderAuth
implements HttpRequestFilter {
    public static final String SIGNING_DESCRIPTION = "version=1.0";
    private final SignatureWire signatureWire;
    private final Supplier<Credentials> creds;
    private final Supplier<PrivateKey> supplyKey;
    private final javax.inject.Provider<String> timeStampProvider;
    private final String emptyStringHash;
    private final HttpUtils utils;
    private final Crypto crypto;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;

    @Inject
    public SignedHeaderAuth(SignatureWire signatureWire, @Provider Supplier<Credentials> creds, Supplier<PrivateKey> supplyKey, @TimeStamp javax.inject.Provider<String> timeStampProvider, HttpUtils utils, Crypto crypto) {
        this.signatureWire = Preconditions.checkNotNull(signatureWire, "signatureWire");
        this.creds = Preconditions.checkNotNull(creds, "creds");
        this.supplyKey = Preconditions.checkNotNull(supplyKey, "supplyKey");
        this.timeStampProvider = Preconditions.checkNotNull(timeStampProvider, "timeStampProvider");
        this.emptyStringHash = this.hashBody(Payloads.newStringPayload(""));
        this.utils = Preconditions.checkNotNull(utils, "utils");
        this.crypto = Preconditions.checkNotNull(crypto, "crypto");
    }

    @Override
    public HttpRequest filter(HttpRequest input) throws HttpException {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)input.toBuilder()).endpoint(input.getEndpoint().toString().replace("%3F", "?"))).build();
        String contentHash = this.hashBody(request.getPayload());
        ArrayListMultimap<String, String> headers = ArrayListMultimap.create();
        headers.put("X-Ops-Content-Hash", contentHash);
        String timestamp = this.timeStampProvider.get();
        String toSign = this.createStringToSign(request.getMethod(), this.hashPath(request.getEndpoint().getPath()), contentHash, timestamp);
        headers.put("X-Ops-Userid", this.creds.get().identity);
        headers.put("X-Ops-Sign", SIGNING_DESCRIPTION);
        request = this.calculateAndReplaceAuthorizationHeaders(request, toSign);
        headers.put("X-Ops-Timestamp", timestamp);
        this.utils.logRequest(this.signatureLog, request, "<<");
        return ((HttpRequest.Builder)request.toBuilder().replaceHeaders(headers)).build();
    }

    @VisibleForTesting
    HttpRequest calculateAndReplaceAuthorizationHeaders(HttpRequest request, String toSign) throws HttpException {
        String signature = this.sign(toSign);
        if (this.signatureWire.enabled()) {
            this.signatureWire.input(Strings2.toInputStream(signature));
        }
        String[] signatureLines = Iterables.toArray(Splitter.fixedLength(60).split(signature), String.class);
        ArrayListMultimap<String, String> headers = ArrayListMultimap.create();
        for (int i = 0; i < signatureLines.length; ++i) {
            headers.put("X-Ops-Authorization-" + (i + 1), signatureLines[i]);
        }
        return ((HttpRequest.Builder)request.toBuilder().replaceHeaders(headers)).build();
    }

    public String createStringToSign(String request, String hashedPath, String contentHash, String timestamp) {
        return "Method:" + request + "\n" + "Hashed Path:" + hashedPath + "\n" + "X-Ops-Content-Hash:" + contentHash + "\n" + "X-Ops-Timestamp:" + timestamp + "\n" + "X-Ops-UserId:" + this.creds.get().identity;
    }

    @VisibleForTesting
    String hashPath(String path) {
        try {
            return BaseEncoding.base64().encode(ByteSource.wrap(this.canonicalPath(path).getBytes(Charsets.UTF_8)).hash(Hashing.sha1()).asBytes());
        }
        catch (Exception e) {
            Throwables.propagateIfPossible(e);
            throw new HttpException("error creating sigature for path: " + path, e);
        }
    }

    @VisibleForTesting
    String canonicalPath(String path) {
        return (path = path.replaceAll("\\/+", "/")).endsWith("/") && path.length() > 1 ? path.substring(0, path.length() - 1) : path;
    }

    @VisibleForTesting
    String hashBody(Payload payload) {
        if (payload == null) {
            return this.emptyStringHash;
        }
        Preconditions.checkArgument((payload = this.useTheFilePartIfForm(payload)) != null, "payload was null");
        Preconditions.checkArgument(payload.isRepeatable(), "payload must be repeatable: " + payload);
        try {
            return BaseEncoding.base64().encode(ByteStreams2.hashAndClose(payload.getInput(), Hashing.sha1()).asBytes());
        }
        catch (Exception e) {
            Throwables.propagateIfPossible(e);
            throw new HttpException("error creating sigature for payload: " + payload, e);
        }
    }

    private Payload useTheFilePartIfForm(Payload payload) {
        if (payload instanceof MultipartForm) {
            Iterable parts = (Iterable)((MultipartForm)MultipartForm.class.cast(payload)).getRawContent();
            try {
                payload = Iterables.find(parts, new Predicate<Part>(){

                    @Override
                    public boolean apply(Part input) {
                        return "file".equals(input.getName());
                    }
                });
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        return payload;
    }

    public String sign(String toSign) {
        try {
            byte[] encrypted = ByteStreams2.toByteArrayAndClose(new RSAEncryptingPayload(this.crypto, Payloads.newStringPayload(toSign), this.supplyKey.get()).openStream());
            return BaseEncoding.base64().encode(encrypted);
        }
        catch (IOException e) {
            throw new HttpException("error signing request", e);
        }
    }
}

