/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Set;
import org.jclouds.chef.util.CollectionUtils;
import org.jclouds.javax.annotation.Nullable;

public class Sandbox {
    @SerializedName(value="_rev")
    private final String rev;
    @SerializedName(value="is_completed")
    private final boolean isCompleted;
    @SerializedName(value="create_time")
    private final Date createTime;
    private final Set<String> checksums;
    private final String name;
    private final String guid;
    @SerializedName(value="json_class")
    private final String _jsonClass = "Chef::Sandbox";
    @SerializedName(value="chef_type")
    private final String _chefType = "sandbox";

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"_rev", "is_completed", "create_time", "checksums", "name", "guid"})
    protected Sandbox(String rev, boolean isCompleted, Date createTime, @Nullable Set<String> checksums, String name, String guid) {
        this.rev = rev;
        this.isCompleted = isCompleted;
        this.createTime = createTime;
        this.checksums = CollectionUtils.copyOfOrEmpty(checksums);
        this.name = name;
        this.guid = guid;
    }

    public String getRev() {
        return this.rev;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Set<String> getChecksums() {
        return this.checksums;
    }

    public String getName() {
        return this.name;
    }

    public String getGuid() {
        return this.guid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.checksums == null ? 0 : this.checksums.hashCode());
        result = 31 * result + (this.createTime == null ? 0 : this.createTime.hashCode());
        result = 31 * result + (this.guid == null ? 0 : this.guid.hashCode());
        result = 31 * result + (this.isCompleted ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.rev == null ? 0 : this.rev.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sandbox other = (Sandbox)obj;
        if (this.checksums == null ? other.checksums != null : !this.checksums.equals(other.checksums)) {
            return false;
        }
        if (this.createTime == null ? other.createTime != null : !this.createTime.equals(other.createTime)) {
            return false;
        }
        if (this.guid == null ? other.guid != null : !this.guid.equals(other.guid)) {
            return false;
        }
        if (this.isCompleted != other.isCompleted) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.rev == null ? other.rev != null : !this.rev.equals(other.rev));
    }

    public String toString() {
        return "Sandbox [checksums=" + this.checksums + ", createTime=" + this.createTime + ", guid=" + this.guid + ", isCompleted=" + this.isCompleted + ", name=" + this.name + ", rev=" + this.rev + "]";
    }

    public static class Builder {
        private String rev;
        private boolean isCompleted;
        private Date createTime;
        private ImmutableSet.Builder<String> checksums = ImmutableSet.builder();
        private String name;
        private String guid;

        public Builder rev(String rev) {
            this.rev = Preconditions.checkNotNull(rev, "rev");
            return this;
        }

        public Builder isCompleted(boolean isCompleted) {
            this.isCompleted = isCompleted;
            return this;
        }

        public Builder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder checksum(String checksum) {
            this.checksums.add((Object)Preconditions.checkNotNull(checksum, "checksum"));
            return this;
        }

        public Builder checksums(Iterable<String> checksums) {
            this.checksums.addAll((Iterable)Preconditions.checkNotNull(checksums, "checksums"));
            return this;
        }

        public Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            return this;
        }

        public Builder guid(String guid) {
            this.guid = Preconditions.checkNotNull(guid, "guid");
            return this;
        }

        public Sandbox build() {
            return new Sandbox(this.rev, this.isCompleted, this.createTime, (Set<String>)((Object)this.checksums.build()), this.name, this.guid);
        }
    }
}

