/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.jclouds.chef.domain.Attribute;
import org.jclouds.chef.domain.Grouping;
import org.jclouds.chef.util.CollectionUtils;
import org.jclouds.javax.annotation.Nullable;

public class Metadata {
    private final String license;
    private final String maintainer;
    private final Map<String, String> suggestions;
    private final Map<String, String> dependencies;
    @SerializedName(value="maintainer_email")
    private final String maintainerEmail;
    private final Map<String, String> conflicting;
    private final String description;
    private final Map<String, String> providing;
    private final Map<String, String> platforms;
    private final String version;
    private final Map<String, String> recipes;
    private final Map<String, String> replacing;
    private final String name;
    private final Map<String, Grouping> groupings;
    @SerializedName(value="long_description")
    private final String longDescription;
    private final Map<String, Attribute> attributes;
    private final Map<String, String> recommendations;

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"license", "maintainer", "suggestions", "dependencies", "maintainer_email", "conflicting", "description", "providing", "platforms", "version", "recipes", "replacing", "name", "groupings", "long_description", "attributes", "recommendations"})
    protected Metadata(String license, String maintainer, @Nullable Map<String, String> suggestions, @Nullable Map<String, String> dependencies, String maintainerEmail, @Nullable Map<String, String> conflicting, String description, @Nullable Map<String, String> providing, @Nullable Map<String, String> platforms, String version, @Nullable Map<String, String> recipes, @Nullable Map<String, String> replacing, String name, @Nullable Map<String, Grouping> groupings, String longDescription, @Nullable Map<String, Attribute> attributes, @Nullable Map<String, String> recommendations) {
        this.license = license;
        this.maintainer = maintainer;
        this.suggestions = CollectionUtils.copyOfOrEmpty(suggestions);
        this.dependencies = CollectionUtils.copyOfOrEmpty(dependencies);
        this.maintainerEmail = maintainerEmail;
        this.conflicting = CollectionUtils.copyOfOrEmpty(conflicting);
        this.description = description;
        this.providing = CollectionUtils.copyOfOrEmpty(providing);
        this.platforms = CollectionUtils.copyOfOrEmpty(platforms);
        this.version = version;
        this.recipes = CollectionUtils.copyOfOrEmpty(recipes);
        this.replacing = CollectionUtils.copyOfOrEmpty(replacing);
        this.name = name;
        this.groupings = CollectionUtils.copyOfOrEmpty(groupings);
        this.longDescription = longDescription;
        this.attributes = CollectionUtils.copyOfOrEmpty(attributes);
        this.recommendations = CollectionUtils.copyOfOrEmpty(recommendations);
    }

    public String getLicense() {
        return this.license;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public Map<String, String> getSuggestions() {
        return this.suggestions;
    }

    public Map<String, String> getDependencies() {
        return this.dependencies;
    }

    public String getMaintainerEmail() {
        return this.maintainerEmail;
    }

    public Map<String, String> getConflicting() {
        return this.conflicting;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getProviding() {
        return this.providing;
    }

    public Map<String, String> getPlatforms() {
        return this.platforms;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getRecipes() {
        return this.recipes;
    }

    public Map<String, String> getReplacing() {
        return this.replacing;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Grouping> getGroupings() {
        return this.groupings;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getRecommendations() {
        return this.recommendations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.conflicting == null ? 0 : this.conflicting.hashCode());
        result = 31 * result + (this.dependencies == null ? 0 : this.dependencies.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.groupings == null ? 0 : this.groupings.hashCode());
        result = 31 * result + (this.license == null ? 0 : this.license.hashCode());
        result = 31 * result + (this.longDescription == null ? 0 : this.longDescription.hashCode());
        result = 31 * result + (this.maintainer == null ? 0 : this.maintainer.hashCode());
        result = 31 * result + (this.maintainerEmail == null ? 0 : this.maintainerEmail.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.platforms == null ? 0 : this.platforms.hashCode());
        result = 31 * result + (this.providing == null ? 0 : this.providing.hashCode());
        result = 31 * result + (this.recipes == null ? 0 : this.recipes.hashCode());
        result = 31 * result + (this.recommendations == null ? 0 : this.recommendations.hashCode());
        result = 31 * result + (this.replacing == null ? 0 : this.replacing.hashCode());
        result = 31 * result + (this.suggestions == null ? 0 : this.suggestions.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Metadata other = (Metadata)obj;
        if (this.attributes == null ? other.attributes != null : !this.attributes.equals(other.attributes)) {
            return false;
        }
        if (this.conflicting == null ? other.conflicting != null : !this.conflicting.equals(other.conflicting)) {
            return false;
        }
        if (this.dependencies == null ? other.dependencies != null : !this.dependencies.equals(other.dependencies)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.groupings == null ? other.groupings != null : !this.groupings.equals(other.groupings)) {
            return false;
        }
        if (this.license == null ? other.license != null : !this.license.equals(other.license)) {
            return false;
        }
        if (this.longDescription == null ? other.longDescription != null : !this.longDescription.equals(other.longDescription)) {
            return false;
        }
        if (this.maintainer == null ? other.maintainer != null : !this.maintainer.equals(other.maintainer)) {
            return false;
        }
        if (this.maintainerEmail == null ? other.maintainerEmail != null : !this.maintainerEmail.equals(other.maintainerEmail)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.platforms == null ? other.platforms != null : !this.platforms.equals(other.platforms)) {
            return false;
        }
        if (this.providing == null ? other.providing != null : !this.providing.equals(other.providing)) {
            return false;
        }
        if (this.recipes == null ? other.recipes != null : !this.recipes.equals(other.recipes)) {
            return false;
        }
        if (this.recommendations == null ? other.recommendations != null : !this.recommendations.equals(other.recommendations)) {
            return false;
        }
        if (this.replacing == null ? other.replacing != null : !this.replacing.equals(other.replacing)) {
            return false;
        }
        if (this.suggestions == null ? other.suggestions != null : !this.suggestions.equals(other.suggestions)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "Metadata [attributes=" + this.attributes + ", conflicting=" + this.conflicting + ", dependencies=" + this.dependencies + ", description=" + this.description + ", groupings=" + this.groupings + ", license=" + this.license + ", longDescription=" + this.longDescription + ", maintainer=" + this.maintainer + ", maintainerEmail=" + this.maintainerEmail + ", name=" + this.name + ", platforms=" + this.platforms + ", providing=" + this.providing + ", recipes=" + this.recipes + ", recommendations=" + this.recommendations + ", replacing=" + this.replacing + ", suggestions=" + this.suggestions + ", version=" + this.version + "]";
    }

    public static class Builder {
        private String license;
        private String maintainer;
        private ImmutableMap.Builder<String, String> suggestions = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> dependencies = ImmutableMap.builder();
        private String maintainerEmail;
        private ImmutableMap.Builder<String, String> conflicting = ImmutableMap.builder();
        private String description;
        private ImmutableMap.Builder<String, String> providing = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> platforms = ImmutableMap.builder();
        private String version;
        private ImmutableMap.Builder<String, String> recipes = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> replacing = ImmutableMap.builder();
        private String name;
        private ImmutableMap.Builder<String, Grouping> groupings = ImmutableMap.builder();
        private String longDescription;
        private ImmutableMap.Builder<String, Attribute> attributes = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> recommendations = ImmutableMap.builder();

        public Builder license(String license) {
            this.license = Preconditions.checkNotNull(license, "license");
            return this;
        }

        public Builder maintainer(String maintainer) {
            this.maintainer = Preconditions.checkNotNull(maintainer, "maintainer");
            return this;
        }

        public Builder suggestion(String key, String value) {
            this.suggestions.put(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(value, "value"));
            return this;
        }

        public Builder suggestions(Map<String, String> suggestions) {
            this.suggestions.putAll(Preconditions.checkNotNull(suggestions, "suggestions"));
            return this;
        }

        public Builder dependency(String key, String value) {
            this.dependencies.put(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(value, "value"));
            return this;
        }

        public Builder dependencies(Map<String, String> dependencies) {
            this.dependencies.putAll(Preconditions.checkNotNull(dependencies, "dependencies"));
            return this;
        }

        public Builder maintainerEmail(String maintainerEmail) {
            this.maintainerEmail = Preconditions.checkNotNull(maintainerEmail, "maintainerEmail");
            return this;
        }

        public Builder conflicting(String key, String value) {
            this.conflicting.put(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(value, "value"));
            return this;
        }

        public Builder conflicting(Map<String, String> conflicting) {
            this.conflicting.putAll(Preconditions.checkNotNull(conflicting, "conflicting"));
            return this;
        }

        public Builder description(String description) {
            this.description = Preconditions.checkNotNull(description, "description");
            return this;
        }

        public Builder providing(String key, String value) {
            this.providing.put(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(value, "value"));
            return this;
        }

        public Builder providing(Map<String, String> providing) {
            this.providing.putAll(Preconditions.checkNotNull(providing, "providing"));
            return this;
        }

        public Builder platform(String key, String value) {
            this.platforms.put(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(value, "value"));
            return this;
        }

        public Builder platforms(Map<String, String> platforms) {
            this.platforms.putAll(Preconditions.checkNotNull(platforms, "platforms"));
            return this;
        }

        public Builder version(String version) {
            this.version = Preconditions.checkNotNull(version, "version");
            return this;
        }

        public Builder recipe(String key, String value) {
            this.recipes.put(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(value, "value"));
            return this;
        }

        public Builder recipes(Map<String, String> recipes) {
            this.recipes.putAll(Preconditions.checkNotNull(recipes, "recipes"));
            return this;
        }

        public Builder replacing(String key, String value) {
            this.replacing.put(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(value, "value"));
            return this;
        }

        public Builder replacing(Map<String, String> replacing) {
            this.replacing.putAll(Preconditions.checkNotNull(replacing, "replacing"));
            return this;
        }

        public Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            return this;
        }

        public Builder grouping(String key, Grouping value) {
            this.groupings.put(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(value, "value"));
            return this;
        }

        public Builder grouping(Map<String, Grouping> groupings) {
            this.groupings.putAll(Preconditions.checkNotNull(groupings, "groupings"));
            return this;
        }

        public Builder longDescription(String longDescription) {
            this.longDescription = Preconditions.checkNotNull(longDescription, "longDescription");
            return this;
        }

        public Builder attribute(String key, Attribute value) {
            this.attributes.put(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(value, "value"));
            return this;
        }

        public Builder attributes(Map<String, Attribute> attributes) {
            this.attributes.putAll(Preconditions.checkNotNull(attributes, "attributes"));
            return this;
        }

        public Builder recommendation(String key, String value) {
            this.recommendations.put(Preconditions.checkNotNull(key, "key"), Preconditions.checkNotNull(value, "value"));
            return this;
        }

        public Builder recommendations(Map<String, String> recommendations) {
            this.recommendations.putAll(Preconditions.checkNotNull(recommendations, "recommendations"));
            return this;
        }

        public Metadata build() {
            return new Metadata(this.license, this.maintainer, this.suggestions.build(), this.dependencies.build(), this.maintainerEmail, this.conflicting.build(), this.description, this.providing.build(), this.platforms.build(), this.version, this.recipes.build(), this.replacing.build(), this.name, this.groupings.build(), this.longDescription, this.attributes.build(), this.recommendations.build());
        }
    }
}

