/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public class Grouping {
    private final String title;
    private final String description;

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"title", "description"})
    protected Grouping(String title, String description) {
        this.title = title;
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Grouping other = (Grouping)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }

    public String toString() {
        return "Grouping [title=" + this.title + ", description=" + this.description + "]";
    }

    public static class Builder {
        private String title;
        private String description;

        public Builder title(String title) {
            this.title = Preconditions.checkNotNull(title, "title");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Grouping build() {
            return new Grouping(this.title, this.description);
        }
    }
}

