/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.domain;

import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.jclouds.javax.annotation.Nullable;

public class Client {
    private final X509Certificate certificate;
    @SerializedName(value="private_key")
    private final PrivateKey privateKey;
    @SerializedName(value="public_key")
    private final PublicKey publicKey;
    private final String orgname;
    private final String clientname;
    private final String name;
    private final boolean validator;

    public static Builder builder() {
        return new Builder();
    }

    @ConstructorProperties(value={"certificate", "orgname", "clientname", "name", "validator", "private_key", "public_key"})
    protected Client(X509Certificate certificate, String orgname, String clientname, String name, boolean validator, @Nullable PrivateKey privateKey, @Nullable PublicKey publicKey) {
        this.certificate = certificate;
        this.orgname = orgname;
        this.clientname = clientname;
        this.name = name;
        this.validator = validator;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public String getOrgname() {
        return this.orgname;
    }

    public String getClientname() {
        return this.clientname;
    }

    public String getName() {
        return this.name;
    }

    public boolean isValidator() {
        return this.validator;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.certificate == null ? 0 : this.certificate.hashCode());
        result = 31 * result + (this.clientname == null ? 0 : this.clientname.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.orgname == null ? 0 : this.orgname.hashCode());
        result = 31 * result + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        result = 31 * result + (this.publicKey == null ? 0 : this.publicKey.hashCode());
        result = 31 * result + (this.validator ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Client other = (Client)obj;
        if (this.certificate == null ? other.certificate != null : !this.certificate.equals(other.certificate)) {
            return false;
        }
        if (this.clientname == null ? other.clientname != null : !this.clientname.equals(other.clientname)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.orgname == null ? other.orgname != null : !this.orgname.equals(other.orgname)) {
            return false;
        }
        if (this.publicKey == null ? other.publicKey != null : !this.publicKey.equals(other.publicKey)) {
            return false;
        }
        if (this.privateKey == null ? other.privateKey != null : !this.privateKey.equals(other.privateKey)) {
            return false;
        }
        return this.validator == other.validator;
    }

    public String toString() {
        return "Client [name=" + this.name + ", clientname=" + this.clientname + ", orgname=" + this.orgname + ", isValidator=" + this.validator + ", certificate=" + this.certificate + ", publicKey=" + this.publicKey + ", privateKey=" + (this.privateKey == null ? "not " : "") + "present]";
    }

    public static class Builder {
        private X509Certificate certificate;
        private PrivateKey privateKey;
        private String orgname;
        private String clientname;
        private String name;
        private boolean validator;
        private PublicKey publicKey;

        public Builder certificate(X509Certificate certificate) {
            this.certificate = Preconditions.checkNotNull(certificate, "certificate");
            return this;
        }

        public Builder privateKey(PrivateKey privateKey) {
            this.privateKey = Preconditions.checkNotNull(privateKey, "privateKey");
            return this;
        }

        public Builder publicKey(PublicKey publicKey) {
            this.publicKey = Preconditions.checkNotNull(publicKey, "publicKey");
            return this;
        }

        public Builder orgname(String orgname) {
            this.orgname = Preconditions.checkNotNull(orgname, "orgname");
            return this;
        }

        public Builder clientname(String clientname) {
            this.clientname = Preconditions.checkNotNull(clientname, "clientname");
            return this;
        }

        public Builder name(String name) {
            this.name = Preconditions.checkNotNull(name, "name");
            return this;
        }

        public Builder isValidator(boolean validator) {
            this.validator = validator;
            return this;
        }

        public Client build() {
            return new Client(this.certificate, this.orgname, this.clientname, this.name, this.validator, this.privateKey, this.publicKey);
        }
    }
}

