/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.config;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.inject.AbstractModule;
import com.google.inject.ImplementedBy;
import com.google.inject.Provides;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Pems;
import org.jclouds.json.config.GsonModule;
import org.jclouds.json.gson.internal.JsonReaderInternalAccess;
import org.jclouds.json.internal.NullFilteringTypeAdapterFactories;
import org.jclouds.json.internal.NullHackJsonLiteralAdapter;

public class ChefParserModule
extends AbstractModule {
    @Provides
    @Singleton
    public final Map<Type, Object> provideCustomAdapterBindings(DataBagItemAdapter adapter, PrivateKeyAdapter privateAdapter, PublicKeyAdapter publicAdapter, X509CertificateAdapter certAdapter) {
        return ImmutableMap.of(DatabagItem.class, adapter, PrivateKey.class, privateAdapter, PublicKey.class, publicAdapter, X509Certificate.class, certAdapter);
    }

    @Override
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        this.bind(NullFilteringTypeAdapterFactories.MapTypeAdapterFactory.class).to(KeepLastRepeatedKeyMapTypeAdapterFactory.class);
    }

    public static class KeepLastRepeatedKeyMapTypeAdapterFactory
    extends NullFilteringTypeAdapterFactories.MapTypeAdapterFactory {
        public KeepLastRepeatedKeyMapTypeAdapterFactory() {
            super(Map.class);
        }

        @Override
        protected <K, V, T> TypeAdapter<T> newAdapter(TypeAdapter<K> keyAdapter, TypeAdapter<V> valueAdapter) {
            return new KeepLastRepeatedKeyMapTypeAdapter<K, V>(keyAdapter, valueAdapter);
        }
    }

    private static final class KeepLastRepeatedKeyMapTypeAdapter<K, V>
    extends NullFilteringTypeAdapterFactories.MapTypeAdapter<K, V> {
        protected KeepLastRepeatedKeyMapTypeAdapter(TypeAdapter<K> keyAdapter, TypeAdapter<V> valueAdapter) {
            super(keyAdapter, valueAdapter);
        }

        @Override
        public Map<K, V> read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            HashMap result = Maps.newHashMap();
            in.beginObject();
            while (in.hasNext()) {
                JsonReaderInternalAccess.INSTANCE.promoteNameToValue(in);
                Object name = this.keyAdapter.read(in);
                Object value = this.valueAdapter.read(in);
                if (value == null) continue;
                result.put(name, value);
            }
            in.endObject();
            return ImmutableMap.copyOf(result);
        }
    }

    private static class IdHolder {
        private String id;

        private IdHolder() {
        }
    }

    @Singleton
    public static class DataBagItemAdapter
    extends NullHackJsonLiteralAdapter<DatabagItem> {
        final Gson gson = new Gson();

        @Override
        protected DatabagItem createJsonLiteralFromRawJson(String text) {
            IdHolder idHolder = this.gson.fromJson(text, IdHolder.class);
            Preconditions.checkState(idHolder.id != null, "databag item must be a json hash ex. {\"id\":\"item1\",\"my_key\":\"my_data\"}; was %s", text);
            text = text.replaceFirst(String.format("\\{\"id\"[ ]?:\"%s\",", idHolder.id), "{");
            return new DatabagItem(idHolder.id, text);
        }

        @Override
        protected String toString(DatabagItem value) {
            String text = value.toString();
            try {
                IdHolder idHolder = this.gson.fromJson(text, IdHolder.class);
                if (idHolder.id == null) {
                    text = text.replaceFirst("\\{", String.format("{\"id\":\"%s\",", value.getId()));
                } else {
                    Preconditions.checkArgument(value.getId().equals(idHolder.id), "incorrect id in databagItem text, should be %s: was %s", value.getId(), idHolder.id);
                }
            }
            catch (JsonSyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            return text;
        }
    }

    @Singleton
    public static class X509CertificateAdapterImpl
    implements X509CertificateAdapter {
        private final Crypto crypto;

        @Inject
        X509CertificateAdapterImpl(Crypto crypto) {
            this.crypto = crypto;
        }

        @Override
        public X509Certificate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String keyText = json.getAsString().replaceAll("\\n", "\n");
            try {
                return Pems.x509Certificate(ByteSource.wrap(keyText.getBytes(Charsets.UTF_8)), this.crypto.certFactory());
            }
            catch (UnsupportedEncodingException e) {
                Throwables.propagate(e);
                return null;
            }
            catch (IOException e) {
                Throwables.propagate(e);
                return null;
            }
            catch (CertificateException e) {
                Throwables.propagate(e);
                return null;
            }
        }
    }

    @ImplementedBy(value=X509CertificateAdapterImpl.class)
    public static interface X509CertificateAdapter
    extends JsonDeserializer<X509Certificate> {
    }

    @Singleton
    public static class PublicKeyAdapterImpl
    implements PublicKeyAdapter {
        private final Crypto crypto;

        @Inject
        PublicKeyAdapterImpl(Crypto crypto) {
            this.crypto = crypto;
        }

        @Override
        public PublicKey deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String keyText = json.getAsString().replaceAll("\\n", "\n");
            try {
                return this.crypto.rsaKeyFactory().generatePublic(Pems.publicKeySpec(ByteSource.wrap(keyText.getBytes(Charsets.UTF_8))));
            }
            catch (UnsupportedEncodingException e) {
                Throwables.propagate(e);
                return null;
            }
            catch (InvalidKeySpecException e) {
                Throwables.propagate(e);
                return null;
            }
            catch (IOException e) {
                Throwables.propagate(e);
                return null;
            }
        }
    }

    @ImplementedBy(value=PublicKeyAdapterImpl.class)
    public static interface PublicKeyAdapter
    extends JsonDeserializer<PublicKey> {
    }

    @Singleton
    public static class PrivateKeyAdapterImpl
    implements PrivateKeyAdapter {
        private final Crypto crypto;

        @Inject
        PrivateKeyAdapterImpl(Crypto crypto) {
            this.crypto = crypto;
        }

        @Override
        public PrivateKey deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String keyText = json.getAsString().replaceAll("\\n", "\n");
            try {
                return this.crypto.rsaKeyFactory().generatePrivate(Pems.privateKeySpec(ByteSource.wrap(keyText.getBytes(Charsets.UTF_8))));
            }
            catch (UnsupportedEncodingException e) {
                Throwables.propagate(e);
                return null;
            }
            catch (InvalidKeySpecException e) {
                Throwables.propagate(e);
                return null;
            }
            catch (IOException e) {
                Throwables.propagate(e);
                return null;
            }
        }
    }

    @ImplementedBy(value=PrivateKeyAdapterImpl.class)
    public static interface PrivateKeyAdapter
    extends JsonDeserializer<PrivateKey> {
    }
}

