/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteSource;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.byon.Node;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;

@Singleton
public class NodesParsedFromSupplier
implements Supplier<LoadingCache<String, Node>> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final ByteSource supplier;
    private final Function<ByteSource, LoadingCache<String, Node>> parser;

    @Inject
    NodesParsedFromSupplier(@Provider ByteSource supplier, Function<ByteSource, LoadingCache<String, Node>> parser) {
        this.supplier = Preconditions.checkNotNull(supplier, "supplier");
        this.parser = Preconditions.checkNotNull(parser, "parser");
    }

    @Override
    public LoadingCache<String, Node> get() {
        LoadingCache<String, Node> nodes = this.parser.apply(this.supplier);
        Preconditions.checkState(nodes != null && nodes.size() > 0L, "no nodes parsed from supplier: %s", this.supplier);
        return nodes;
    }
}

