/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.functions;

import com.google.common.base.Function;
import java.net.URI;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;

@Singleton
public class URIParser
implements Function<HttpResponse, URI> {
    @Override
    public URI apply(HttpResponse from) {
        if (from.getStatusCode() == 202 && from.getHeaders().containsKey("Location")) {
            String uri = from.getFirstHeaderOrNull("Location");
            return URI.create(uri);
        }
        if (from.getStatusCode() == 200 || from.getStatusCode() == 204) {
            return null;
        }
        throw new IllegalStateException("did not receive expected response code and header in: " + from);
    }
}

