/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.functions;

import com.google.common.base.Function;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;

@Singleton
public class FalseOn204
implements Function<HttpResponse, Boolean> {
    @Override
    public Boolean apply(HttpResponse from) {
        HttpUtils.releasePayload(from);
        int statusCode = from.getStatusCode();
        if (statusCode == 200 || statusCode == 202) {
            return true;
        }
        if (statusCode == 204) {
            return false;
        }
        throw new IllegalStateException("not expected response from: " + from);
    }
}

