/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_StorageService;
import org.jclouds.azurecompute.arm.domain.AutoValue_StorageService_StorageServiceProperties;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class StorageService {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract String name();

    public abstract String location();

    @Nullable
    public abstract Map<String, String> tags();

    @Nullable
    public abstract String type();

    public abstract StorageServiceProperties storageServiceProperties();

    @SerializedNames(value={"id", "name", "location", "tags", "type", "properties"})
    public static StorageService create(String id, String name, String location, Map<String, String> tags, String type, StorageServiceProperties storageServiceProperties) {
        return new AutoValue_StorageService(id, name, location, tags == null ? null : ImmutableMap.copyOf(tags), type, storageServiceProperties);
    }

    public static abstract class StorageServiceProperties {
        public abstract AccountType accountType();

        @Nullable
        public abstract Date creationTime();

        @Nullable
        public abstract Map<String, String> primaryEndpoints();

        @Nullable
        public abstract String primaryLocation();

        @Nullable
        public abstract Status provisioningState();

        @Nullable
        public abstract Map<String, String> secondaryEndpoints();

        @Nullable
        public abstract String secondaryLocation();

        @Nullable
        public abstract RegionStatus statusOfPrimary();

        @Nullable
        public abstract RegionStatus statusOfSecondary();

        @SerializedNames(value={"accountType", "creationTime", "primaryEndpoints", "primaryLocation", "provisioningState", "secondaryEndpoints", "secondaryLocation", "statusOfPrimary", "statusOfSecondary"})
        public static StorageServiceProperties create(AccountType accountType, Date creationTime, Map<String, String> primaryEndpoints, String primaryLocation, Status provisioningState, Map<String, String> secondaryEndpoints, String secondaryLocation, RegionStatus statusOfPrimary, RegionStatus statusOfSecondary) {
            Builder builder = StorageServiceProperties.builder().accountType(accountType).creationTime(creationTime).primaryLocation(primaryLocation).provisioningState(provisioningState).secondaryLocation(secondaryLocation).statusOfPrimary(statusOfPrimary).statusOfSecondary(statusOfSecondary);
            builder.primaryEndpoints(primaryEndpoints != null ? ImmutableMap.copyOf(primaryEndpoints) : null);
            builder.secondaryEndpoints(secondaryEndpoints != null ? ImmutableMap.copyOf(secondaryEndpoints) : null);
            return builder.build();
        }

        public abstract Builder toBuilder();

        public static Builder builder() {
            return new AutoValue_StorageService_StorageServiceProperties.Builder();
        }

        public static abstract class Builder {
            public abstract Builder accountType(AccountType var1);

            public abstract Builder creationTime(Date var1);

            public abstract Builder primaryEndpoints(Map<String, String> var1);

            public abstract Builder primaryLocation(String var1);

            public abstract Builder provisioningState(Status var1);

            public abstract Builder secondaryEndpoints(Map<String, String> var1);

            public abstract Builder secondaryLocation(String var1);

            public abstract Builder statusOfPrimary(RegionStatus var1);

            public abstract Builder statusOfSecondary(RegionStatus var1);

            abstract Map<String, String> primaryEndpoints();

            abstract Map<String, String> secondaryEndpoints();

            abstract StorageServiceProperties autoBuild();

            public StorageServiceProperties build() {
                this.primaryEndpoints(this.primaryEndpoints() != null ? ImmutableMap.copyOf(this.primaryEndpoints()) : null);
                this.secondaryEndpoints(this.secondaryEndpoints() != null ? ImmutableMap.copyOf(this.secondaryEndpoints()) : null);
                return this.autoBuild();
            }
        }
    }

    public static enum Status {
        Creating,
        Created,
        Deleting,
        Deleted,
        Changing,
        ResolvingDns,
        Succeeded,
        UNRECOGNIZED;


        public static Status fromValue(String text) {
            return (Status)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }
    }

    public static enum RegionStatus {
        Available,
        Unavailable,
        UNRECOGNIZED;


        public static RegionStatus fromValue(String text) {
            return (RegionStatus)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }
    }

    public static enum AccountType {
        Standard_LRS,
        Standard_ZRS,
        Standard_GRS,
        Standard_RAGRS,
        Premium_LRS,
        UNRECOGNIZED;


        public static AccountType fromValue(String text) {
            return (AccountType)GetEnumValue.fromValueOrDefault(text, UNRECOGNIZED);
        }
    }
}

