/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.arm.domain.AutoValue_StorageProfile;
import org.jclouds.azurecompute.arm.domain.DataDisk;
import org.jclouds.azurecompute.arm.domain.ImageReference;
import org.jclouds.azurecompute.arm.domain.OSDisk;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class StorageProfile {
    @Nullable
    public abstract ImageReference imageReference();

    public abstract OSDisk osDisk();

    @Nullable
    public abstract List<DataDisk> dataDisks();

    @SerializedNames(value={"imageReference", "osDisk", "dataDisks"})
    public static StorageProfile create(ImageReference imageReference, OSDisk osDisk, List<DataDisk> dataDisks) {
        Builder builder = StorageProfile.builder().imageReference(imageReference).osDisk(osDisk).dataDisks(dataDisks != null ? ImmutableList.copyOf(dataDisks) : null);
        return builder.build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_StorageProfile.Builder();
    }

    public static abstract class Builder {
        public abstract Builder imageReference(ImageReference var1);

        public abstract Builder osDisk(OSDisk var1);

        public abstract Builder dataDisks(List<DataDisk> var1);

        abstract List<DataDisk> dataDisks();

        abstract StorageProfile autoBuild();

        public StorageProfile build() {
            this.dataDisks(this.dataDisks() != null ? ImmutableList.copyOf(this.dataDisks()) : null);
            return this.autoBuild();
        }
    }
}

