/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.arm.domain.AutoValue_ResourceProviderMetaData;
import org.jclouds.json.SerializedNames;

public abstract class ResourceProviderMetaData {
    public abstract String resourceType();

    public abstract List<String> locations();

    public abstract List<String> apiVersions();

    @SerializedNames(value={"resourceType", "locations", "apiVersions"})
    public static ResourceProviderMetaData create(String resourceType, List<String> locations, List<String> apiVersions) {
        Builder builder = ResourceProviderMetaData.builder().resourceType(resourceType).locations(locations == null ? ImmutableList.of() : ImmutableList.copyOf(locations)).apiVersions(apiVersions == null ? ImmutableList.of() : ImmutableList.copyOf(apiVersions));
        return builder.build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_ResourceProviderMetaData.Builder();
    }

    public static abstract class Builder {
        public abstract Builder resourceType(String var1);

        public abstract Builder locations(List<String> var1);

        public abstract Builder apiVersions(List<String> var1);

        abstract List<String> locations();

        abstract List<String> apiVersions();

        abstract ResourceProviderMetaData autoBuild();

        public ResourceProviderMetaData build() {
            this.locations(this.locations() != null ? ImmutableList.copyOf(this.locations()) : ImmutableList.of());
            this.apiVersions(this.apiVersions() != null ? ImmutableList.copyOf(this.apiVersions()) : ImmutableList.of());
            return this.autoBuild();
        }
    }
}

