/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.extensions;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.URI;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.compute.config.AzurePredicatesModule;
import org.jclouds.azurecompute.arm.compute.domain.ResourceGroupAndName;
import org.jclouds.azurecompute.arm.compute.functions.CustomImageToVMImage;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.Image;
import org.jclouds.azurecompute.arm.domain.ImageProperties;
import org.jclouds.azurecompute.arm.domain.VMImage;
import org.jclouds.azurecompute.arm.domain.VirtualMachine;
import org.jclouds.compute.domain.CloneImageTemplate;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.domain.ImageTemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.logging.Logger;

public class AzureComputeImageExtension
implements ImageExtension {
    public static final String CUSTOM_IMAGE_OFFER = "custom";
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final AzureComputeApi api;
    private final ListeningExecutorService userExecutor;
    private final AzurePredicatesModule.ImageAvailablePredicateFactory imageAvailablePredicate;
    private final AzurePredicatesModule.VirtualMachineInStatePredicateFactory nodeSuspendedPredicate;
    private final Function<VMImage, org.jclouds.compute.domain.Image> vmImageToImage;
    private final Predicate<URI> resourceDeleted;
    private final CustomImageToVMImage customImagetoVmImage;

    @Inject
    AzureComputeImageExtension(AzureComputeApi api, AzurePredicatesModule.ImageAvailablePredicateFactory imageAvailablePredicate, @Named(value="jclouds.compute.timeout.node-suspended") AzurePredicatesModule.VirtualMachineInStatePredicateFactory nodeSuspendedPredicate, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, Function<VMImage, org.jclouds.compute.domain.Image> vmImageToImage, @Named(value="jclouds.azurecompute.arm.timeout.resourcedeleted") Predicate<URI> resourceDeleted, CustomImageToVMImage customImagetoVmImage) {
        this.api = api;
        this.imageAvailablePredicate = imageAvailablePredicate;
        this.nodeSuspendedPredicate = nodeSuspendedPredicate;
        this.userExecutor = userExecutor;
        this.vmImageToImage = vmImageToImage;
        this.resourceDeleted = resourceDeleted;
        this.customImagetoVmImage = customImagetoVmImage;
    }

    @Override
    public ImageTemplate buildImageTemplateFromNode(String name, String id) {
        return new ImageTemplateBuilder.CloneImageTemplateBuilder().nodeId(id).name(name.toLowerCase()).build();
    }

    @Override
    public ListenableFuture<org.jclouds.compute.domain.Image> createImage(ImageTemplate template) {
        final CloneImageTemplate cloneTemplate = (CloneImageTemplate)template;
        ResourceGroupAndName resourceGroupAndName = ResourceGroupAndName.fromSlashEncoded(cloneTemplate.getSourceNodeId());
        final String resourceGroupName = resourceGroupAndName.resourceGroup();
        final String vmName = resourceGroupAndName.name();
        final VirtualMachine vm = this.api.getVirtualMachineApi(resourceGroupName).get(vmName);
        final IdReference vmIdRef = IdReference.create(vm.id());
        this.logger.debug(">> stopping node %s...", cloneTemplate.getSourceNodeId());
        this.api.getVirtualMachineApi(resourceGroupName).stop(vmName);
        Preconditions.checkState(this.nodeSuspendedPredicate.create(resourceGroupName).apply(vmName), "Node %s was not suspended within the configured time limit", cloneTemplate.getSourceNodeId());
        return this.userExecutor.submit(new Callable<org.jclouds.compute.domain.Image>(){

            @Override
            public org.jclouds.compute.domain.Image call() throws Exception {
                AzureComputeImageExtension.this.logger.debug(">> generalizing virtal machine %s...", vmName);
                AzureComputeImageExtension.this.api.getVirtualMachineApi(resourceGroupName).generalize(vmName);
                Image imageFromVM = AzureComputeImageExtension.this.api.getVirtualMachineImageApi(resourceGroupName).createOrUpdate(cloneTemplate.getName(), vm.location(), ImageProperties.builder().sourceVirtualMachine(vmIdRef).build());
                Preconditions.checkState(AzureComputeImageExtension.this.imageAvailablePredicate.create(resourceGroupName).apply(imageFromVM.name()), "Image for node %s was not created within the configured time limit", cloneTemplate.getName());
                return (org.jclouds.compute.domain.Image)Functions.compose(AzureComputeImageExtension.this.vmImageToImage, AzureComputeImageExtension.this.customImagetoVmImage).apply(imageFromVM);
            }
        });
    }

    @Override
    public boolean deleteImage(String id) {
        VMImage image = VMImage.decodeFieldsFromUniqueId(id);
        Preconditions.checkArgument(image.custom(), "Only custom images can be deleted");
        this.logger.debug(">> deleting image %s", id);
        URI uri = this.api.getVirtualMachineImageApi(image.resourceGroup()).delete(image.name());
        return this.resourceDeleted.apply(uri);
    }
}

