/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.domain.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.azureblob.domain.BlobBlockProperties;

public class BlobBlockPropertiesImpl
implements BlobBlockProperties {
    private final String blockName;
    private final long contentLength;
    private final boolean committed;

    public BlobBlockPropertiesImpl(String blockName, long contentLength, boolean committed) {
        this.blockName = Preconditions.checkNotNull(blockName);
        this.contentLength = contentLength;
        this.committed = committed;
    }

    @Override
    public String getBlockName() {
        return this.blockName;
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlobBlockPropertiesImpl that = (BlobBlockPropertiesImpl)o;
        return Objects.equal(this.blockName, that.blockName) && Objects.equal(this.committed, that.committed) && Objects.equal(this.contentLength, that.contentLength);
    }

    public int hashCode() {
        return Objects.hashCode(this.blockName, this.contentLength, this.committed);
    }
}

