/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import com.google.common.base.Function;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.azureblob.domain.MutableBlobProperties;
import org.jclouds.azureblob.domain.internal.MutableBlobPropertiesImpl;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.http.HttpUtils;

@Singleton
public class BlobMetadataToBlobProperties
implements Function<BlobMetadata, MutableBlobProperties> {
    @Override
    public MutableBlobProperties apply(BlobMetadata from) {
        if (from == null) {
            return null;
        }
        MutableBlobPropertiesImpl to = new MutableBlobPropertiesImpl();
        HttpUtils.copy(from.getContentMetadata(), to.getContentMetadata());
        to.setETag(from.getETag());
        to.setName(from.getName());
        to.setUrl(from.getUri());
        to.setLastModified(from.getLastModified());
        if (from.getUserMetadata() != null) {
            for (Map.Entry<String, String> entry : from.getUserMetadata().entrySet()) {
                to.getMetadata().put(entry.getKey().toLowerCase(), entry.getValue());
            }
        }
        return to;
    }
}

