/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.binders;

import com.google.common.base.Optional;
import java.util.Date;
import java.util.Map;
import org.jclouds.azureblob.options.CopyBlobOptions;
import org.jclouds.date.DateService;
import org.jclouds.date.internal.SimpleDateFormatDateService;
import org.jclouds.http.HttpMessage;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;

public class BindAzureCopyOptionsToRequest
implements Binder {
    private static final DateService dateService = new SimpleDateFormatDateService();

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Optional<String> ifNoneMatch;
        Optional<String> ifMatch;
        Optional<Date> ifUnmodifiedSince;
        Optional<Date> ifModifiedSince;
        HttpMessage.Builder builder = request.toBuilder();
        CopyBlobOptions options = (CopyBlobOptions)input;
        Optional<Map<String, String>> userMetadata = options.getUserMetadata();
        if (userMetadata.isPresent()) {
            for (Map.Entry<String, String> entry : userMetadata.get().entrySet()) {
                builder.addHeader("x-ms-meta-" + entry.getKey(), entry.getValue());
            }
        }
        if ((ifModifiedSince = options.getIfModifiedSince()).isPresent()) {
            builder.addHeader("x-ms-source-if-modified-since", dateService.rfc822DateFormat(ifModifiedSince.get()));
        }
        if ((ifUnmodifiedSince = options.getIfUnmodifiedSince()).isPresent()) {
            builder.addHeader("x-ms-source-if-unmodified-since", dateService.rfc822DateFormat(ifUnmodifiedSince.get()));
        }
        if ((ifMatch = options.getIfMatch()).isPresent()) {
            builder.addHeader("x-ms-source-if-match", ifMatch.get());
        }
        if ((ifNoneMatch = options.getIfNoneMatch()).isPresent()) {
            builder.addHeader("x-ms-source-if-none-match", ifNoneMatch.get());
        }
        return (R)((HttpRequest.Builder)builder).build();
    }
}

