/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimaps;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.ContentMetadata;
import org.jclouds.rest.Binder;

@Singleton
public class BindAzureContentMetadataToRequest
implements Binder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        String contentType;
        String contentLanguage;
        String contentEncoding;
        String contentDisposition;
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof ContentMetadata, "this binder is only valid for ContentMetadata");
        Preconditions.checkNotNull(request, "request");
        ContentMetadata contentMetadata = (ContentMetadata)input;
        ImmutableMap.Builder<String, String> headers = ImmutableMap.builder();
        String cacheControl = contentMetadata.getCacheControl();
        if (cacheControl != null) {
            headers.put("x-ms-blob-cache-control", cacheControl);
        }
        if ((contentDisposition = contentMetadata.getContentDisposition()) != null) {
            headers.put("x-ms-blob-content-disposition", contentDisposition);
        }
        if ((contentEncoding = contentMetadata.getContentEncoding()) != null) {
            headers.put("x-ms-blob-content-encoding", contentEncoding);
        }
        if ((contentLanguage = contentMetadata.getContentLanguage()) != null) {
            headers.put("x-ms-blob-content-language", contentLanguage);
        }
        if ((contentType = contentMetadata.getContentType()) != null) {
            headers.put("x-ms-blob-content-type", contentType);
        }
        return (R)((HttpRequest.Builder)request.toBuilder().replaceHeaders(Multimaps.forMap(headers.build()))).build();
    }
}

