/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import java.util.Map;
import javax.inject.Inject;
import org.jclouds.aws.ec2.domain.VPC;
import org.jclouds.ec2.xml.TagSetHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class VPCHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<VPC> {
    private StringBuilder currentText = new StringBuilder();
    private VPC.Builder builder = VPC.builder();
    private final TagSetHandler tagSetHandler;
    private boolean inTagSet;

    @Inject
    public VPCHandler(TagSetHandler tagSetHandler) {
        this.tagSetHandler = tagSetHandler;
    }

    @Override
    public VPC getResult() {
        try {
            VPC vPC = this.builder.build();
            return vPC;
        }
        finally {
            this.builder = VPC.builder();
        }
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = true;
        }
        if (this.inTagSet) {
            this.tagSetHandler.startElement(uri, name, qName, attrs);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = false;
            this.builder.tags((Map<String, String>)this.tagSetHandler.getResult());
        } else if (this.inTagSet) {
            this.tagSetHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix(qName, "dhcpOptionsId")) {
            this.builder.dhcpOptionsId(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "state")) {
            this.builder.state(VPC.State.fromValue(SaxUtils.currentOrNull(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "vpcId")) {
            this.builder.id(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "cidrBlock")) {
            this.builder.cidrBlock(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "instanceTenancy")) {
            this.builder.instanceTenancy(VPC.InstanceTenancy.fromValue(SaxUtils.currentOrNull(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "isDefault")) {
            this.builder.isDefault(Boolean.parseBoolean(this.currentText.toString().trim()));
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inTagSet) {
            this.tagSetHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

