/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.base.Supplier;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.xml.LaunchSpecificationHandler;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.date.DateService;
import org.jclouds.ec2.xml.TagSetHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SpotInstanceHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<SpotInstanceRequest> {
    private StringBuilder currentText = new StringBuilder();
    protected final DateService dateService;
    protected final Supplier<String> defaultRegion;
    protected final SpotInstanceRequest.Builder builder;
    protected boolean inFault;
    protected boolean inStatus;
    protected boolean inLaunchSpecification;
    protected final LaunchSpecificationHandler launchSpecificationHandler;
    protected boolean inTagSet;
    protected final TagSetHandler tagSetHandler;

    @Inject
    public SpotInstanceHandler(DateService dateService, @Region Supplier<String> defaultRegion, LaunchSpecificationHandler launchSpecificationHandler, TagSetHandler tagSetHandler, SpotInstanceRequest.Builder builder) {
        this.dateService = dateService;
        this.defaultRegion = defaultRegion;
        this.launchSpecificationHandler = launchSpecificationHandler;
        this.tagSetHandler = tagSetHandler;
        this.builder = builder;
    }

    @Override
    public SpotInstanceRequest getResult() {
        try {
            String region;
            String string = region = this.getRequest() != null ? AWSUtils.findRegionInArgsOrNull(this.getRequest()) : null;
            if (region == null) {
                region = this.defaultRegion.get();
            }
            SpotInstanceRequest spotInstanceRequest = this.builder.region(region).build();
            return spotInstanceRequest;
        }
        finally {
            this.builder.clear();
        }
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) throws SAXException {
        if (SaxUtils.equalsOrSuffix(qName, "launchSpecification")) {
            this.inLaunchSpecification = true;
        } else if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = true;
        } else if (SaxUtils.equalsOrSuffix(qName, "fault")) {
            this.inFault = true;
        } else if (SaxUtils.equalsOrSuffix(qName, "status")) {
            this.inStatus = true;
        }
        if (this.inLaunchSpecification) {
            this.launchSpecificationHandler.startElement(uri, name, qName, attrs);
        } else if (this.inTagSet) {
            this.tagSetHandler.startElement(uri, name, qName, attrs);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        String validUntil;
        if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = false;
            this.builder.tags((Map<String, String>)this.tagSetHandler.getResult());
        } else if (this.inTagSet) {
            this.tagSetHandler.endElement(uri, name, qName);
        }
        if (qName.equals("launchSpecification")) {
            this.inLaunchSpecification = false;
            this.builder.launchSpecification(this.launchSpecificationHandler.getResult());
        } else if (this.inLaunchSpecification) {
            this.launchSpecificationHandler.endElement(uri, name, qName);
        }
        if (qName.equals("fault")) {
            this.inFault = false;
        }
        if (qName.equals("status")) {
            this.inStatus = false;
        }
        if (qName.equals("spotInstanceRequestId")) {
            this.builder.id(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("instanceId")) {
            this.builder.instanceId(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("launchedAvailabilityZone")) {
            this.builder.launchedAvailabilityZone(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("availabilityZoneGroup")) {
            this.builder.availabilityZoneGroup(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("launchGroup")) {
            this.builder.launchGroup(SaxUtils.currentOrNull(this.currentText));
        } else if (qName.equals("spotPrice")) {
            String price = SaxUtils.currentOrNull(this.currentText);
            if (price != null) {
                this.builder.spotPrice(Float.parseFloat(price));
            }
        } else if (qName.equals("type")) {
            String type = SaxUtils.currentOrNull(this.currentText);
            if (type != null) {
                this.builder.type(SpotInstanceRequest.Type.fromValue(type));
            }
        } else if (qName.equals("state")) {
            String rawState = SaxUtils.currentOrNull(this.currentText);
            if (rawState != null) {
                this.builder.rawState(rawState);
                this.builder.state(SpotInstanceRequest.State.fromValue(rawState));
            }
        } else if (qName.equals("createTime")) {
            String createTime = SaxUtils.currentOrNull(this.currentText);
            if (createTime != null) {
                this.builder.createTime(this.dateService.iso8601DateOrSecondsDateParse(createTime));
            }
        } else if (qName.equals("productDescription")) {
            this.builder.productDescription(SaxUtils.currentOrNull(this.currentText));
        } else if (this.inFault) {
            if (qName.equals("code")) {
                this.builder.faultCode(SaxUtils.currentOrNull(this.currentText));
            } else if (qName.equals("message")) {
                this.builder.faultMessage(SaxUtils.currentOrNull(this.currentText));
            }
        } else if (this.inStatus) {
            String updateTime;
            if (qName.equals("code")) {
                this.builder.statusCode(SaxUtils.currentOrNull(this.currentText));
            } else if (qName.equals("message")) {
                this.builder.statusMessage(SaxUtils.currentOrNull(this.currentText));
            } else if (qName.equals("updateTime") && (updateTime = SaxUtils.currentOrNull(this.currentText)) != null) {
                this.builder.statusUpdateTime(this.dateService.iso8601DateOrSecondsDateParse(updateTime));
            }
        } else if (qName.equals("validFrom")) {
            String validFrom = SaxUtils.currentOrNull(this.currentText);
            if (validFrom != null) {
                this.builder.validFrom(this.dateService.iso8601DateOrSecondsDateParse(validFrom));
            }
        } else if (qName.equals("validUntil") && (validUntil = SaxUtils.currentOrNull(this.currentText)) != null) {
            this.builder.validUntil(this.dateService.iso8601DateOrSecondsDateParse(validUntil));
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inLaunchSpecification) {
            this.launchSpecificationHandler.characters(ch, start, length);
        } else if (this.inTagSet) {
            this.tagSetHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

