/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import org.jclouds.aws.ec2.domain.VPC;
import org.jclouds.aws.ec2.xml.VPCHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DescribeVPCsResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<FluentIterable<VPC>> {
    private final VPCHandler vpcHandler;
    private StringBuilder currentText = new StringBuilder();
    private boolean inVpcSet;
    private boolean inTagSet;
    private ImmutableSet.Builder<VPC> vpcs = ImmutableSet.builder();

    @Inject
    public DescribeVPCsResponseHandler(VPCHandler vpcHandler) {
        this.vpcHandler = vpcHandler;
    }

    @Override
    public FluentIterable<VPC> getResult() {
        return FluentIterable.from(this.vpcs.build());
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (SaxUtils.equalsOrSuffix(qName, "vpcSet")) {
            this.inVpcSet = true;
        } else if (this.inVpcSet) {
            if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
                this.inTagSet = true;
            }
            this.vpcHandler.startElement(url, name, qName, attributes);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "vpcSet")) {
            this.inVpcSet = false;
        } else if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = false;
            this.vpcHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix(qName, "item") && !this.inTagSet) {
            this.vpcs.add((Object)this.vpcHandler.getResult());
        } else if (this.inVpcSet) {
            this.vpcHandler.endElement(uri, name, qName);
        }
        this.currentText.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.inVpcSet) {
            this.vpcHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

