/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import org.jclouds.aws.ec2.domain.RouteTable;
import org.jclouds.aws.ec2.xml.RouteTableHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DescribeRouteTablesResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<FluentIterable<RouteTable>> {
    private RouteTableHandler routeTableHandler;
    private List<RouteTable> tables = Lists.newArrayList();
    private boolean inRouteSet;
    private boolean inAssociationSet;
    private boolean inPropagatingVgwSet;
    private boolean inTagSet;

    @Inject
    DescribeRouteTablesResponseHandler(RouteTableHandler routeTableHandler) {
        this.routeTableHandler = routeTableHandler;
    }

    @Override
    public FluentIterable<RouteTable> getResult() {
        try {
            FluentIterable<RouteTable> fluentIterable = FluentIterable.from(this.tables);
            return fluentIterable;
        }
        finally {
            this.tables = Lists.newArrayList();
        }
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (SaxUtils.equalsOrSuffix(qName, "routeSet")) {
            this.inRouteSet = true;
        } else if (SaxUtils.equalsOrSuffix(qName, "associationSet")) {
            this.inAssociationSet = true;
        } else if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = true;
        } else if (SaxUtils.equalsOrSuffix(qName, "propagatingVgwSet")) {
            this.inPropagatingVgwSet = true;
        }
        this.routeTableHandler.startElement(uri, name, qName, attrs);
    }

    private boolean inSubElement() {
        return this.inRouteSet || this.inTagSet || this.inAssociationSet || this.inPropagatingVgwSet;
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "routeSet")) {
            this.inRouteSet = false;
            this.routeTableHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix(qName, "associationSet")) {
            this.inAssociationSet = false;
            this.routeTableHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = false;
            this.routeTableHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix(qName, "item") && !this.inSubElement()) {
            RouteTable table = this.routeTableHandler.getResult();
            this.tables.add(table);
        } else {
            this.routeTableHandler.endElement(uri, name, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.routeTableHandler.characters(ch, start, length);
    }
}

