/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import org.jclouds.aws.ec2.domain.InternetGateway;
import org.jclouds.aws.ec2.xml.InternetGatewayHandler;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class DescribeInternetGatewaysResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<FluentIterable<InternetGateway>> {
    private final InternetGatewayHandler gatewayHandler;
    private boolean inAttachmentSet;
    private boolean inTagSet;
    private ImmutableSet.Builder<InternetGateway> gateways = ImmutableSet.builder();

    @Inject
    DescribeInternetGatewaysResponseHandler(InternetGatewayHandler gatewayHandler) {
        this.gatewayHandler = gatewayHandler;
    }

    @Override
    public FluentIterable<InternetGateway> getResult() {
        try {
            FluentIterable<InternetGateway> fluentIterable = FluentIterable.from(this.gateways.build());
            return fluentIterable;
        }
        finally {
            this.gateways = ImmutableSet.builder();
        }
    }

    @Override
    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (SaxUtils.equalsOrSuffix(qName, "attachmentSet")) {
            this.inAttachmentSet = true;
        } else if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = true;
        }
        this.gatewayHandler.startElement(url, name, qName, attributes);
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix(qName, "attachmentSet")) {
            this.inAttachmentSet = false;
            this.gatewayHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix(qName, "tagSet")) {
            this.inTagSet = false;
            this.gatewayHandler.endElement(uri, name, qName);
        } else if (SaxUtils.equalsOrSuffix(qName, "item") && !this.inTagSet && !this.inAttachmentSet) {
            this.gateways.add((Object)this.gatewayHandler.getResult());
        } else {
            this.gatewayHandler.endElement(uri, name, qName);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.gatewayHandler.characters(ch, start, length);
    }
}

