/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import org.jclouds.http.functions.ParseSax;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.util.SaxUtils;
import org.xml.sax.SAXException;

public class AWSEC2IpPermissionHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<IpPermission> {
    private StringBuilder currentText = new StringBuilder();
    private IpPermission.Builder builder = IpPermission.builder();
    private String userId;
    private String groupId;

    @Override
    public IpPermission getResult() {
        try {
            IpPermission ipPermission = this.builder.build();
            return ipPermission;
        }
        finally {
            this.builder = IpPermission.builder();
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        if (SaxUtils.equalsOrSuffix(qName, "ipProtocol")) {
            this.builder.ipProtocol(IpProtocol.fromValue(AWSEC2IpPermissionHandler.currentOrNegative(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "fromPort")) {
            this.builder.fromPort(Integer.parseInt(AWSEC2IpPermissionHandler.currentOrNegative(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "toPort")) {
            this.builder.toPort(Integer.parseInt(AWSEC2IpPermissionHandler.currentOrNegative(this.currentText)));
        } else if (SaxUtils.equalsOrSuffix(qName, "cidrIp")) {
            this.builder.cidrBlock(SaxUtils.currentOrNull(this.currentText));
        } else if (SaxUtils.equalsOrSuffix(qName, "userId")) {
            this.userId = SaxUtils.currentOrNull(this.currentText);
        } else if (SaxUtils.equalsOrSuffix(qName, "groupId")) {
            this.groupId = SaxUtils.currentOrNull(this.currentText);
        } else if (SaxUtils.equalsOrSuffix(qName, "item")) {
            if (this.userId != null && this.groupId != null) {
                this.builder.tenantIdGroupNamePair(this.userId, this.groupId);
            }
            this.groupId = null;
            this.userId = null;
        }
        this.currentText.setLength(0);
    }

    private static String currentOrNegative(StringBuilder currentText) {
        String returnVal = currentText.toString().trim();
        return returnVal.equals("") ? "-1" : returnVal;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

