/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.jclouds.atmos.domain.UserMetadata;
import org.jclouds.http.HttpResponse;

@Singleton
public class ParseUserMetadataFromHeaders
implements Function<HttpResponse, UserMetadata> {
    private static final Set<String> SYS_KEYS = ImmutableSet.of("atime", "ctime", "gid", "itime", "mtime", "nlink", new String[]{"parent", "policyname", "size", "uid", "content-md5", "objectid", "objname", "type"});

    @Override
    public UserMetadata apply(HttpResponse from) {
        Preconditions.checkNotNull(from, "http response");
        Map<String, String> meta = Maps.filterKeys(ParseUserMetadataFromHeaders.getMetaMap(Preconditions.checkNotNull(from.getFirstHeaderOrNull("x-emc-meta"), "x-emc-meta")), Predicates.not(Predicates.in(SYS_KEYS)));
        ImmutableMap<String, String> listableMeta = from.getFirstHeaderOrNull("x-emc-listable-meta") != null ? ParseUserMetadataFromHeaders.getMetaMap(from.getFirstHeaderOrNull("x-emc-listable-meta")) : ImmutableMap.of();
        ImmutableSet<String> tags = from.getFirstHeaderOrNull("x-emc-tags") != null ? Splitter.on(", ").split(from.getFirstHeaderOrNull("x-emc-tags")) : ImmutableSet.of();
        ImmutableSet<String> listableTags = from.getFirstHeaderOrNull("x-emc-listable-tags") != null ? Splitter.on(", ").split(from.getFirstHeaderOrNull("x-emc-listable-tags")) : ImmutableSet.of();
        return new UserMetadata(meta, listableMeta, tags, listableTags);
    }

    private static Map<String, String> getMetaMap(String meta) {
        return Splitter.on(", ").withKeyValueSeparator('=').split(meta);
    }
}

