/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.fallbacks;

import com.google.common.base.Throwables;
import org.jclouds.Fallback;
import org.jclouds.atmos.AtmosResponseException;
import org.jclouds.atmos.reference.AtmosErrorCode;
import org.jclouds.http.HttpUtils;
import org.jclouds.util.Throwables2;

public final class TrueOn404FalseOnPathNotEmpty
implements Fallback<Boolean> {
    @Override
    public Boolean createOrPropagate(Throwable t) throws Exception {
        if (HttpUtils.contains404(t)) {
            return true;
        }
        AtmosResponseException exception = Throwables2.getFirstThrowableOfType(t, AtmosResponseException.class);
        if (exception != null && exception.getError().getCode() == AtmosErrorCode.DIRECTORY_NOT_EMPTY.getCode()) {
            return false;
        }
        throw Throwables.propagate(t);
    }
}

