/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.atmos.domain;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;

public class UserMetadata {
    private final Map<String, String> metadata;
    private final Map<String, String> listableMetadata;
    private final Set<String> tags;
    private final Set<String> listableTags;

    public UserMetadata(Map<String, String> metadata, Map<String, String> listableMetadata, Iterable<String> tags, Iterable<String> listableTags) {
        this.metadata = Maps.newLinkedHashMap(Preconditions.checkNotNull(metadata, "metadata"));
        this.listableMetadata = Maps.newLinkedHashMap(Preconditions.checkNotNull(listableMetadata, "listableMetadata"));
        this.tags = Sets.newLinkedHashSet(Preconditions.checkNotNull(tags, "tags"));
        this.listableTags = Sets.newLinkedHashSet(Preconditions.checkNotNull(listableTags, "listableTags"));
    }

    public UserMetadata() {
        this.metadata = Maps.newLinkedHashMap();
        this.listableMetadata = Maps.newLinkedHashMap();
        this.tags = Sets.newLinkedHashSet();
        this.listableTags = Sets.newLinkedHashSet();
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Map<String, String> getListableMetadata() {
        return this.listableMetadata;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Set<String> getListableTags() {
        return this.listableTags;
    }

    public String toString() {
        return "[metadata=" + this.metadata + ", listableMetadata=" + this.listableMetadata + ", tags=" + this.tags + ", listableTags=" + this.listableTags + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.listableMetadata == null ? 0 : this.listableMetadata.hashCode());
        result = 31 * result + (this.listableTags == null ? 0 : this.listableTags.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserMetadata other = (UserMetadata)obj;
        if (this.listableMetadata == null ? other.listableMetadata != null : !this.listableMetadata.equals(other.listableMetadata)) {
            return false;
        }
        if (this.listableTags == null ? other.listableTags != null : !this.listableTags.equals(other.listableTags)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        return !(this.tags == null ? other.tags != null : !this.tags.equals(other.tags));
    }
}

