/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import com.backblaze.b2.util.B2Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class B2StringUtil {
    public static final String UTF8 = "UTF-8";
    static final char[] LOWER_HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return (str = str.trim()).length() == 0;
    }

    public static String percentEncode(String s) {
        try {
            return URLEncoder.encode(s, UTF8).replace("%2F", "/");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 isn't supported? " + e.getMessage(), e);
        }
    }

    public static String percentDecode(String s) {
        try {
            return URLDecoder.decode(s, UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 isn't supported? " + e.getMessage(), e);
        }
    }

    private static boolean isDecimalDigitChar(char c) {
        return '0' <= c && c <= '9';
    }

    static boolean allDecimal(String str, int startIndex, int endIndex) {
        B2Preconditions.checkArgument(startIndex <= endIndex);
        for (int i = startIndex; i < endIndex; ++i) {
            if (B2StringUtil.isDecimalDigitChar(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static int decimalCharToInt(char c) {
        if (c < '0' || '9' < c) {
            throw new IllegalArgumentException("Character " + c + " is not a digit");
        }
        return c - 48;
    }

    public static int decimalSubstringToInt(String s, int startIndex, int endIndex) {
        int result = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            result = result * 10 + B2StringUtil.decimalCharToInt(s.charAt(i));
        }
        return result;
    }

    public static boolean decimalNumberInRange(String str, int offset, int length, int minInclusive, int maxInclusive) {
        B2Preconditions.checkArgument(offset >= 0 && length >= 0);
        int value = 0;
        for (int i = offset; i < offset + length; ++i) {
            char c = str.charAt(i);
            if (c < '0' || '9' < c) {
                return false;
            }
            value = value * 10 + (c - 48);
        }
        return minInclusive <= value && value <= maxInclusive;
    }

    public static String join(String delimiter, Object[] objects) {
        StringBuilder builder = new StringBuilder();
        for (Object o : objects) {
            if (builder.length() > 0) {
                builder.append(delimiter);
            }
            String s = o == null ? null : o.toString();
            builder.append(s);
        }
        return builder.toString();
    }

    public static byte[] getUtf8Bytes(String str) {
        try {
            return str.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("No UTF-8 charset");
        }
    }

    public static String toHexString(byte[] b) {
        if (b == null || b.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            int unsignedByte = b[i] & 0xFF;
            sb.append(LOWER_HEX_DIGITS[unsignedByte >> 4]);
            sb.append(LOWER_HEX_DIGITS[unsignedByte & 0xF]);
        }
        return sb.toString();
    }

    public static String underscoresToCamelCase(String orig, boolean capitalizeFirstLetter) {
        int origLen = orig.length();
        StringBuilder builder = new StringBuilder(origLen);
        boolean capitalize = capitalizeFirstLetter;
        for (int i = 0; i < origLen; ++i) {
            char c = orig.charAt(i);
            if (c == '_') {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                c = Character.toTitleCase(c);
                capitalize = false;
            } else {
                c = Character.toLowerCase(c);
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static boolean startsWithIgnoreCase(String all, String possiblePrefix) {
        if (all == null || possiblePrefix == null) {
            return false;
        }
        if (all.length() < possiblePrefix.length()) {
            return false;
        }
        String prefix = all.substring(0, possiblePrefix.length());
        return prefix.equalsIgnoreCase(possiblePrefix);
    }

    B2StringUtil() {
    }
}

