/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.util;

import com.backblaze.b2.util.B2Clock;
import com.backblaze.b2.util.B2DateTimeUtil;
import com.backblaze.b2.util.B2Preconditions;
import java.time.Duration;
import java.time.LocalDateTime;

public class B2ClockSim
extends B2Clock {
    private long nowMillis;
    private long monotonicMillis;

    B2ClockSim(LocalDateTime startTime) {
        this.resetBoth(startTime);
    }

    @Override
    public long wallClockMillis() {
        return this.nowMillis;
    }

    @Override
    public long monotonicMillis() {
        return this.monotonicMillis;
    }

    public void advanceBoth(Duration delta) {
        B2Preconditions.checkArgument(delta.toNanos() >= 0L, "delta must be non-negative");
        this.nowMillis += delta.toMillis();
        this.monotonicMillis += delta.toMillis();
    }

    public void advanceNow(Duration delta) {
        this.nowMillis += delta.toMillis();
    }

    public void resetBoth(LocalDateTime desiredNow) {
        this.nowMillis = B2DateTimeUtil.getMillisecondsSinceEpoch(desiredNow);
        this.monotonicMillis = 0L;
    }
}

