/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

import com.backblaze.b2.util.B2Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class B2TypeResolver {
    private final Class<?> clazz;
    private final Type type;
    private final Map<String, Type> typeMap;

    public B2TypeResolver(Class<?> clazz) {
        this(clazz, null);
    }

    public B2TypeResolver(Class<?> clazz, Type[] actualTypeArgumentsOrNull) {
        B2Preconditions.checkArgumentIsNotNull(clazz, "Supplied class must not be null");
        TypeVariable<Class<?>>[] typeParameters = clazz.getTypeParameters();
        if (typeParameters.length == 0) {
            B2Preconditions.checkArgument(actualTypeArgumentsOrNull == null || actualTypeArgumentsOrNull.length == 0, "Cannot create B2TypeResolver with type arguments. Class " + clazz.getName() + " has no type parameters");
        } else {
            B2Preconditions.checkArgument(actualTypeArgumentsOrNull != null && typeParameters.length == actualTypeArgumentsOrNull.length, "actualTypeArguments must be same length as class' type parameters");
        }
        this.clazz = clazz;
        if (typeParameters.length == 0) {
            this.type = clazz;
            this.typeMap = null;
        } else {
            this.type = new ResolvedParameterizedType(clazz, actualTypeArgumentsOrNull);
            this.typeMap = new TreeMap<String, Type>();
            for (int i = 0; i < typeParameters.length; ++i) {
                this.typeMap.put(typeParameters[i].getName(), actualTypeArgumentsOrNull[i]);
            }
        }
    }

    public Type getType() {
        return this.type;
    }

    public Type resolveType(Field field) {
        B2Preconditions.checkArgument(field.getDeclaringClass().equals(this.clazz), "cannot resolve fields from other classes");
        return this.resolveType(field.getGenericType());
    }

    private Type resolveType(Type type) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof TypeVariable) {
            String typeName = type.getTypeName();
            B2Preconditions.checkState(this.typeMap.containsKey(typeName));
            return this.typeMap.get(typeName);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] resolvedActualTypeArguments = this.resolveTypes(parameterizedType.getActualTypeArguments());
            return new ResolvedParameterizedType(parameterizedType.getRawType(), resolvedActualTypeArguments);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type resolvedComponentType = this.resolveType(genericArrayType.getGenericComponentType());
            return new ResolvedGenericArrayType(resolvedComponentType);
        }
        if (type instanceof WildcardType) {
            throw new RuntimeException("Wildcard types are not supported");
        }
        throw new RuntimeException("Do not know how to resolve type " + type.getClass());
    }

    private Type[] resolveTypes(Type[] types) {
        Type[] resolvedTypes = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolvedTypes[i] = this.resolveType(types[i]);
        }
        return resolvedTypes;
    }

    static class ResolvedParameterizedType
    implements ParameterizedType {
        private final Type rawType;
        private final Type[] actualTypeArguments;

        public ResolvedParameterizedType(Type rawType, Type[] actualTypeArguments) {
            this.rawType = rawType;
            this.actualTypeArguments = actualTypeArguments;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            throw new RuntimeException("this shouldn't be called");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedParameterizedType that = (ResolvedParameterizedType)o;
            return Objects.equals(this.rawType, that.rawType) && Arrays.equals(this.actualTypeArguments, that.actualTypeArguments);
        }

        public int hashCode() {
            int result = Objects.hash(this.rawType);
            result = 31 * result + Arrays.hashCode(this.actualTypeArguments);
            return result;
        }
    }

    static class ResolvedGenericArrayType
    implements GenericArrayType {
        private Type genericComponentType;

        public ResolvedGenericArrayType(Type genericComponentType) {
            this.genericComponentType = genericComponentType;
        }

        @Override
        public Type getGenericComponentType() {
            return this.genericComponentType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResolvedGenericArrayType that = (ResolvedGenericArrayType)o;
            return Objects.equals(this.genericComponentType, that.genericComponentType);
        }

        public int hashCode() {
            return Objects.hash(this.genericComponentType);
        }
    }
}

