/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.json;

public class B2JsonOptions {
    public static final B2JsonOptions DEFAULT = B2JsonOptions.builder().build();
    public static final B2JsonOptions DEFAULT_AND_ALLOW_EXTRA_FIELDS = B2JsonOptions.builder().setExtraFieldOption(ExtraFieldOption.IGNORE).build();
    private final ExtraFieldOption extraFieldOption;
    private final int version;
    private final boolean redactSensitive;
    private final SerializationOption serializationOption;

    private B2JsonOptions(ExtraFieldOption extraFieldOption, int version, boolean redactSensitive, SerializationOption serializationOption) {
        this.extraFieldOption = extraFieldOption;
        this.version = version;
        this.redactSensitive = redactSensitive;
        this.serializationOption = serializationOption;
    }

    public ExtraFieldOption getExtraFieldOption() {
        return this.extraFieldOption;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean getRedactSensitive() {
        return this.redactSensitive;
    }

    public SerializationOption getSerializationOption() {
        return this.serializationOption;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ExtraFieldOption extraFieldOption = ExtraFieldOption.ERROR;
        private int version = 1;
        private boolean redactSensitive = false;
        private SerializationOption serializationOption = SerializationOption.PRETTY;

        public Builder setExtraFieldOption(ExtraFieldOption extraFieldOption) {
            this.extraFieldOption = extraFieldOption;
            return this;
        }

        public Builder setRedactSensitive(boolean redactSensitive) {
            this.redactSensitive = redactSensitive;
            return this;
        }

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public Builder setSerializationOption(SerializationOption serializationOption) {
            this.serializationOption = serializationOption;
            return this;
        }

        public B2JsonOptions build() {
            return new B2JsonOptions(this.extraFieldOption, this.version, this.redactSensitive, this.serializationOption);
        }
    }

    public static enum SerializationOption {
        PRETTY,
        COMPACT;

    }

    public static enum ExtraFieldOption {
        ERROR,
        IGNORE;

    }
}

