/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.json.B2Json;
import java.util.Objects;

public class B2Part {
    @B2Json.required
    private final String fileId;
    @B2Json.required
    private final int partNumber;
    @B2Json.required
    private final long contentLength;
    @B2Json.required
    private final String contentSha1;
    @B2Json.optional
    private final String contentMd5;
    @B2Json.optional
    private final long uploadTimestamp;

    @B2Json.constructor(params="fileId,partNumber,contentLength,contentSha1,contentMd5,uploadTimestamp")
    public B2Part(String fileId, int partNumber, long contentLength, String contentSha1, String contentMd5, long uploadTimestamp) {
        this.fileId = fileId;
        this.partNumber = partNumber;
        this.contentLength = contentLength;
        this.contentSha1 = contentSha1;
        this.contentMd5 = contentMd5;
        this.uploadTimestamp = uploadTimestamp;
    }

    public String getFileId() {
        return this.fileId;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getContentSha1() {
        return this.contentSha1;
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public long getUploadTimestamp() {
        return this.uploadTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2Part b2Part = (B2Part)o;
        return this.getPartNumber() == b2Part.getPartNumber() && this.getContentLength() == b2Part.getContentLength() && this.getUploadTimestamp() == b2Part.getUploadTimestamp() && Objects.equals(this.getFileId(), b2Part.getFileId()) && Objects.equals(this.getContentSha1(), b2Part.getContentSha1()) && Objects.equals(this.getContentMd5(), b2Part.getContentMd5());
    }

    public int hashCode() {
        return Objects.hash(this.getFileId(), this.getPartNumber(), this.getContentLength(), this.getContentSha1(), this.getContentMd5(), this.getUploadTimestamp());
    }

    public String toString() {
        return "B2Part{fileId='" + this.fileId + '\'' + ", partNumber='" + this.partNumber + '\'' + ", contentLength=" + this.contentLength + ", contentSha1='" + this.contentSha1 + '\'' + ", uploadTimestamp=" + this.uploadTimestamp + '}';
    }
}

