/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.json.B2Json;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class B2GetDownloadAuthorizationRequest {
    @B2Json.required
    private final String bucketId;
    @B2Json.optional
    private final String fileNamePrefix;
    @B2Json.optional
    private final int validDurationInSeconds;
    @B2Json.optional
    private final String b2ContentDisposition;
    @B2Json.optional
    private final String b2ContentLanguage;
    @B2Json.optional
    private final String b2Expires;
    @B2Json.optional
    private final String b2CacheControl;
    @B2Json.optional
    private final String b2ContentEncoding;
    @B2Json.optional
    private final String b2ContentType;

    @B2Json.constructor(params="bucketId,fileNamePrefix,validDurationInSeconds,b2ContentDisposition,b2ContentLanguage,b2Expires,b2CacheControl,b2ContentEncoding,b2ContentType")
    private B2GetDownloadAuthorizationRequest(String bucketId, String fileNamePrefix, int validDurationInSeconds, String b2ContentDisposition, String b2ContentLanguage, String b2Expires, String b2CacheControl, String b2ContentEncoding, String b2ContentType) {
        this.bucketId = bucketId;
        this.fileNamePrefix = fileNamePrefix;
        this.validDurationInSeconds = validDurationInSeconds;
        this.b2ContentDisposition = b2ContentDisposition;
        this.b2ContentLanguage = b2ContentLanguage;
        this.b2Expires = b2Expires;
        this.b2CacheControl = b2CacheControl;
        this.b2ContentEncoding = b2ContentEncoding;
        this.b2ContentType = b2ContentType;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getFileNamePrefix() {
        return this.fileNamePrefix;
    }

    public int getValidDurationInSeconds() {
        return this.validDurationInSeconds;
    }

    public String getB2ContentDisposition() {
        return this.b2ContentDisposition;
    }

    public String getB2ContentLanguage() {
        return this.b2ContentLanguage;
    }

    public String getB2Expires() {
        return this.b2Expires;
    }

    public String getB2CacheControl() {
        return this.b2CacheControl;
    }

    public String getB2ContentEncoding() {
        return this.b2ContentEncoding;
    }

    public String getB2ContentType() {
        return this.b2ContentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2GetDownloadAuthorizationRequest that = (B2GetDownloadAuthorizationRequest)o;
        return this.validDurationInSeconds == that.validDurationInSeconds && Objects.equals(this.bucketId, that.bucketId) && Objects.equals(this.fileNamePrefix, that.fileNamePrefix) && Objects.equals(this.b2ContentDisposition, that.b2ContentDisposition) && Objects.equals(this.b2ContentLanguage, that.b2ContentLanguage) && Objects.equals(this.b2Expires, that.b2Expires) && Objects.equals(this.b2CacheControl, that.b2CacheControl) && Objects.equals(this.b2ContentEncoding, that.b2ContentEncoding) && Objects.equals(this.b2ContentType, that.b2ContentType);
    }

    public int hashCode() {
        return Objects.hash(this.bucketId, this.fileNamePrefix, this.validDurationInSeconds, this.b2ContentDisposition, this.b2ContentLanguage, this.b2Expires, this.b2CacheControl, this.b2ContentEncoding, this.b2ContentType);
    }

    public static Builder builder(String bucketId, String fileNamePrefix, int validDurationInSeconds) {
        return new Builder(bucketId, fileNamePrefix, validDurationInSeconds);
    }

    public static class Builder {
        private final String bucketId;
        private final String fileNamePrefix;
        private final int validDurationInSeconds;
        private String b2ContentDisposition;
        private String b2ContentLanguage;
        private String b2Expires;
        private String b2CacheControl;
        private String b2ContentEncoding;
        private String b2ContentType;

        public Builder(String bucketId, String fileNamePrefix, int validDurationInSeconds) {
            this.bucketId = bucketId;
            this.fileNamePrefix = fileNamePrefix;
            this.validDurationInSeconds = validDurationInSeconds;
        }

        public B2GetDownloadAuthorizationRequest build() {
            return new B2GetDownloadAuthorizationRequest(this.bucketId, this.fileNamePrefix, this.validDurationInSeconds, this.b2ContentDisposition, this.b2ContentLanguage, this.b2Expires, this.b2CacheControl, this.b2ContentEncoding, this.b2ContentType);
        }

        public Builder setB2ContentDisposition(String b2ContentDisposition) {
            this.b2ContentDisposition = b2ContentDisposition;
            return this;
        }

        public Builder setB2ContentLanguage(String b2ContentLanguage) {
            this.b2ContentLanguage = b2ContentLanguage;
            return this;
        }

        public Builder setB2Expires(String b2Expires) {
            this.b2Expires = b2Expires;
            return this;
        }

        public Builder setB2Expires(LocalDateTime utcExpiration) {
            this.b2Expires = DateTimeFormatter.RFC_1123_DATE_TIME.format(utcExpiration.atOffset(ZoneOffset.UTC));
            return this;
        }

        public Builder setB2CacheControl(String b2CacheControl) {
            this.b2CacheControl = b2CacheControl;
            return this;
        }

        public Builder setB2ContentEncoding(String b2ContentEncoding) {
            this.b2ContentEncoding = b2ContentEncoding;
            return this;
        }

        public Builder setB2ContentType(String b2ContentType) {
            this.b2ContentType = b2ContentType;
            return this;
        }
    }
}

