/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client.structures;

import com.backblaze.b2.client.structures.B2OverrideableHeaders;
import com.backblaze.b2.util.B2ByteRange;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class B2DownloadByNameRequest
implements B2OverrideableHeaders {
    private final String bucketName;
    private final String fileName;
    private final B2ByteRange range;
    private final String b2ContentDisposition;
    private final String b2ContentLanguage;
    private final String b2Expires;
    private final String b2CacheControl;
    private final String b2ContentEncoding;
    private final String b2ContentType;

    private B2DownloadByNameRequest(String bucketName, String fileName, B2ByteRange range, String b2ContentDisposition, String b2ContentLanguage, String b2Expires, String b2CacheControl, String b2ContentEncoding, String b2ContentType) {
        this.bucketName = bucketName;
        this.fileName = fileName;
        this.range = range;
        this.b2ContentDisposition = b2ContentDisposition;
        this.b2ContentLanguage = b2ContentLanguage;
        this.b2Expires = b2Expires;
        this.b2CacheControl = b2CacheControl;
        this.b2ContentEncoding = b2ContentEncoding;
        this.b2ContentType = b2ContentType;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public B2ByteRange getRange() {
        return this.range;
    }

    @Override
    public String getB2ContentDisposition() {
        return this.b2ContentDisposition;
    }

    @Override
    public String getB2ContentLanguage() {
        return this.b2ContentLanguage;
    }

    @Override
    public String getB2Expires() {
        return this.b2Expires;
    }

    @Override
    public String getB2CacheControl() {
        return this.b2CacheControl;
    }

    @Override
    public String getB2ContentEncoding() {
        return this.b2ContentEncoding;
    }

    @Override
    public String getB2ContentType() {
        return this.b2ContentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        B2DownloadByNameRequest that = (B2DownloadByNameRequest)o;
        return Objects.equals(this.bucketName, that.bucketName) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.range, that.range) && Objects.equals(this.b2ContentDisposition, that.b2ContentDisposition) && Objects.equals(this.b2ContentLanguage, that.b2ContentLanguage) && Objects.equals(this.b2Expires, that.b2Expires) && Objects.equals(this.b2CacheControl, that.b2CacheControl) && Objects.equals(this.b2ContentEncoding, that.b2ContentEncoding) && Objects.equals(this.b2ContentType, that.b2ContentType);
    }

    public int hashCode() {
        return Objects.hash(this.bucketName, this.fileName, this.range, this.b2ContentDisposition, this.b2ContentLanguage, this.b2Expires, this.b2CacheControl, this.b2ContentEncoding, this.b2ContentType);
    }

    public static Builder builder(String bucketName, String fileName) {
        return new Builder(bucketName, fileName);
    }

    public static class Builder {
        private final String bucketName;
        private final String fileName;
        private B2ByteRange range;
        private String b2ContentDisposition;
        private String b2ContentLanguage;
        private String b2Expires;
        private String b2CacheControl;
        private String b2ContentEncoding;
        private String b2ContentType;

        private Builder(String bucketName, String fileName) {
            this.bucketName = bucketName;
            this.fileName = fileName;
        }

        public Builder setRange(B2ByteRange range) {
            this.range = range;
            return this;
        }

        public Builder setB2ContentDisposition(String b2ContentDisposition) {
            this.b2ContentDisposition = b2ContentDisposition;
            return this;
        }

        public Builder setB2ContentLanguage(String b2ContentLanguage) {
            this.b2ContentLanguage = b2ContentLanguage;
            return this;
        }

        public Builder setB2Expires(String b2Expires) {
            this.b2Expires = b2Expires;
            return this;
        }

        public Builder setB2Expires(LocalDateTime utcExpiration) {
            this.b2Expires = DateTimeFormatter.RFC_1123_DATE_TIME.format(utcExpiration.atOffset(ZoneOffset.UTC));
            return this;
        }

        public Builder setB2CacheControl(String b2CacheControl) {
            this.b2CacheControl = b2CacheControl;
            return this;
        }

        public Builder setB2ContentEncoding(String b2ContentEncoding) {
            this.b2ContentEncoding = b2ContentEncoding;
            return this;
        }

        public Builder setB2ContentType(String b2ContentType) {
            this.b2ContentType = b2ContentType;
            return this;
        }

        public B2DownloadByNameRequest build() {
            return new B2DownloadByNameRequest(this.bucketName, this.fileName, this.range, this.b2ContentDisposition, this.b2ContentLanguage, this.b2Expires, this.b2CacheControl, this.b2ContentEncoding, this.b2ContentType);
        }
    }
}

