/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.client.B2RetryPolicy;
import com.backblaze.b2.client.exceptions.B2Exception;
import java.util.function.Supplier;

public class B2DefaultRetryPolicy
implements B2RetryPolicy {
    private static final int MAX_ATTEMPTS = 8;
    private int waitBetweenRetrySecs = 1;

    public static Supplier<B2RetryPolicy> supplier() {
        return B2DefaultRetryPolicy::new;
    }

    @Override
    public Integer gotRetryableAfterDelay(String operation, int attemptsSoFar, long tookMillis, B2Exception e) {
        if (attemptsSoFar < 8) {
            Integer secsFromServer = e.getRetryAfterSecondsOrNull();
            if (secsFromServer != null) {
                this.waitBetweenRetrySecs = 1;
                return secsFromServer;
            }
            int secsToSleep = this.waitBetweenRetrySecs;
            this.waitBetweenRetrySecs *= 2;
            return secsToSleep;
        }
        return null;
    }

    @Override
    public boolean gotRetryableImmediately(String operation, int attemptsSoFar, long tookMillis, B2Exception e) {
        return attemptsSoFar < 8;
    }
}

