<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Naveen Verma - naveenverma@parablu.com
* @version 2.0
* @date 26/03/2019
* @time 5:26 PM
*
*/
?>
<span ng-controller="ShareController" xmlns="http://www.w3.org/1999/html">
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main">
    <span class="hide shareType"><?php if(SHARE_WITHIN_ORG == true){echo 'shareWith';}else{echo 'share';}?></span>
    <span class="hide currentPage"><?='trash'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 status" style="display: none">
            <div class="statusMessage text-center"></div>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 filePanel" block-ui="myBlockUI">
            <div class="panel panel-default no-box-shadow panel-actions">
                <div class="panel-body" style="height: 40px;">
                    <ul class="nav navbar-nav pull-right nav-actions">
                        <?php if(SHARE_WITHIN_ORG == false){ ?>
                            <li><a class="getLink toolTip" ng-click="getLink()" data-toggle="tooltip" data-placement="top" title="Get Link" style="display: none;color:black;" href="javascript:;"><i class="fa fa-link"></i></a></li>
                        <?php } ?>
                        <li><a class="unShare toolTip" ng-click="unShareFile()" data-toggle="tooltip" data-placement="bottom" title="Un-share" style="display: none;color:black;" href="javascript:;"><i class="fa fa-share-square"></i></a></li>
                        <li><a class="openFile toolTip" ng-click="openFile()" data-toggle="tooltip" data-placement="bottom" title="Open File Location" style="display: none;color:black;" href="javascript:;"><i class="fa fa-folder-open"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="panel panel-default files-panel no-box-shadow" ng-if="items.length > 0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover files-table">
                        <colgroup>
                            <col class="col-xs-5">
                            <col class="col-xs-2">
                            <col class="col-xs-3">
                        </colgroup>
                        <thead>
                        <tr>
                            <th class="clickAble" ng-click="sortType = 'fileName'; sortReverse = !sortReverse">
                                Name
                                <span ng-show="sortType == 'fileName' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'fileName' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'sharedTime'; sortReverse = !sortReverse">
                                Last modified
                                <span ng-show="sortType == 'sharedTime' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'sharedTime' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'devicePath'; sortReverse = !sortReverse">
                                Path
                                <span ng-show="sortType == 'devicePath' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'devicePath' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                        </tr>
                        </thead>
                        <tbody id="selectable"
                               selectable="tr"
                               selectable-list="items"
                               selectable-out="selected"
                               selectable-options="{filter:'tr'}"
                               selectable-events="{start:'selectionStart($selected)', stop:'selectionStop($selected)'}"
                               block-ui="myBlockUI"
                               context-menu="menuOptions">
                        <tr ng-repeat="value in items | orderBy:sortType:sortReverse">
                            <td data-name="{{value.$$hashKey}}" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <a style="cursor: pointer; color: black;"><span ng-bind-html="value.fileName | charLimit"></span></a></td>
                            <td ng-cloak> {{ value.sharedTime }} </td>
                            <td ng-cloak>{{ value.devicePath }}</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="text-center status" style="display: none;">
                <h3>There are no files or folders</h3>
            </div>
            <div class="modal fade" id="share" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" id="myModalLabel">Share Details</h4>
                        </div>
                        <div class="modal-body shareLoading">
                            <span>Loading ...</span>
                        </div>
                        <div class="modal-body shareBody" style="display: none;">
                            <div class="mt-md mb-md">
                                <div class="shareLinkBlock" style="display: none;">
                                    <h4>
                                        Share the below link to share the file:
                                       <a ng-click="sendEmailShareLink()" class="clickAble pull-right sendEmailShareLink"><i class="fa fa-envelope"></i></a>
                                    </h4>
                                    
                                    <textarea class="js-copytextarea shareLink" style="width:100%;word-wrap: break-word;" readonly></textarea>
                                    <h5><a class="js-textareacopybtn clickAble pull-right" title="Copy Share Link" style="margin-left: 5px;" ng-click="copyToClipboard()"><i class="fa fa-clipboard" aria-hidden="true"></i></a></h5>
                                    
                                    <br>
                                </div>
                                <div class="form-group sendEmailShareForm hide">
                                    <label for="emails">Emails</label>
                                    <textarea name="emails" ng-model="emails" class="form-control" id="emails"> </textarea>
                                    <br/>
                                    <a ng-click="sendShareEmail(emails)" class="btn btn-small btn-default shareEmailLinkSendBtn"> Send</a>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                            <a ng-click="unShareFile()" style="display: none;" class="unShareBtn btn btn-danger">Un-Share</a>
                        </div>
                    </div>
                </div>
            </div>
                        
                      
        </div>
    </div>


<?php View::renderTemplate('partials/search', $data); ?>

</div><!-- /.container -->
</span>
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/ShareController.js?<?php echo microtime();?>" type="text/javascript"></script>
<script>
    var copyTextareaBtn = document.querySelector('.js-textareacopybtn');

copyTextareaBtn.addEventListener('click', function(event) {
  var copyTextarea = document.querySelector('.js-copytextarea');
  copyTextarea.select();

  try {
    var successful = document.execCommand('copy');
    var msg = successful ? 'successful' : 'unsuccessful';
    //console.log('Copying text command was ' + msg);
  } catch (err) {
    //console.log('Oops, unable to copy');
  }
});
</script>
