<?php use \Core\View;
use Helpers\Auth;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="PmsController">
    <span class="hide currentPage"><?=''?></span>
    <span class="hide csrf_token"><?=$data['csrf_token'];?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php View::renderTemplate('partials/sideBar', $data); ?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            
            <ul class="nav nav-tabs" role="tablist" style="font-weight: 600;<?php if(!isMobile()){ ?>font-size: medium;<?php }else { ?> font-size: small;<?php } ?>">
                <?php if(DISABLE_BLUVAULT == false){ ?>
                    <?php if(Auth::checkCloudPermission('backup')){ ?>
                        <li role="presentation" class="<?php echo $data['activeTabB'];?>"><a data-target="#backup" aria-controls="general" role="tab" data-toggle="tab">Backup Policies</a></li>
                <?php } } ?>
                <?php if(DISABLE_BLUSYNC == false){ ?>
                    <?php if(Auth::checkCloudPermission('sync')){ ?>
                        <li role="presentation" class="<?php echo $data['activeTabS'];?>"><a data-target="#sync" aria-controls="sync" role="tab" data-toggle="tab"><?php if(BLUDRIVE_MODE == true){ ?>BluDrive Policies <?php } else { ?>Sync Policies <?php } ?></a></li>
                <?php } } ?>
                <?php if(Auth::checkCloudPermission('office365') ){ ?>
                    <li role="presentation" class="<?php echo $data['activeTabO'];?>"><a data-target="#office365" aria-controls="office365" role="tab" data-toggle="tab">Office 365 Policies</a></li>
                <?php } ?>
            </ul>
            
            <div class="tab-content">
                <div role="tabpanel" class="tab-pane <?php echo $data['activeTabB'];?>" id="backup">
                    <?php if(DISABLE_BLUVAULT == false){ ?>
                    <?php if(Auth::checkCloudPermission('backup')){ ?>
                        <div class="row">
                            <div class="panel">
                                <div class="panel-heading">
                                    <h4 style="padding: 0px 0px 0px 15px;">Backup Policy Settings</h4>
                                </div>
                                <div class="panel-body">
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click">
                                            <div class="panel-header pull-right" style="margin-right: 10px; margin-top: -11px;">
                                                <a class="btn btn-success btn-small" ng-click="sendMeTo('/pms/filters')"><i class="fa fa-filter" style="color: white"></i> Filters</a>
                                                <a class="btn btn-success btn-small" ng-click="sendMeTo('/pms/schedules')"><i class="fa fa-clock-o" style="color: white"></i> Schedules</a>
                                                <a class="btn btn-success btn-small hide" ng-click="sendMeTo('/pms/cloudCredentials')"><i class="fa fa-cloud" style="color: white"></i> Cloud Credentials</a>
                                            </div>
                                            <hr/>
                                            <div class="background">
                                                <i class="fa fa-file-powerpoint-o"></i>
                                            </div>
                                            <div class="panel-body widget widget-body clickAble" ng-click="sendMeTo('/pms/policies')">
                                                <i class="fa fa-file-powerpoint-o"> Backup Policies</i><br/>
                                                <a>Create, View, Edit, Clone  Policies</a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click">
                                            <div class="panel-header pull-right" style="margin-right: 10px; margin-top: -11px;">
                                                <a class="btn btn-small btn-success pull-right" ng-click="sendMeTo('/pms/policyMapping/multiple')">Map policies in bulk</a>
                                            </div>
                                            <hr/>
                                            <div class="background">
                                                <i class="fa fa-user"></i>
                                            </div>
                                            <div class="panel-body widget widget-body clickAble" ng-click="sendMeTo('/pms/policyMapping/single')">
                                                <i class="fa fa-user"> Policy Mapping</i><br/>
                                                <a>Map users to backup policies</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                    <?php }elseif(Auth::checkCloudPermission('serverBackup')){ ?>
                        <div class="row">
                            <div class="panel">
                                <div class="panel-heading">
                                    <h4 style="padding: 0px 0px 0px 15px;">Server Backup Policy Settings</h4>
                                </div>
                                <div class="panel-body">
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click">
                                            <div class="panel-header pull-right" style="margin-right: 10px; margin-top: -11px;">
                                                <a class="btn btn-success btn-small" ng-click="sendMeTo('/pms/filters')"><i class="fa fa-filter" style="color: white"></i> Filters</a>
                                                <a class="btn btn-success btn-small" ng-click="sendMeTo('/pms/schedules')"><i class="fa fa-clock-o" style="color: white"></i> Schedules</a>
                                            </div>
                                            <hr/>
                                            <div class="background">
                                                <i class="fa fa-file-powerpoint-o"></i>
                                            </div>
                                            <div class="panel-body widget widget-body clickAble" ng-click="sendMeTo('/pms/policies')">
                                                <i class="fa fa-file-powerpoint-o"> Server Backup Policies</i><br/>
                                                <a>Create, Edit, View Policies</a>
                                            </div>
                                        </div>
                                    </div>
        <!--                            <div class="col-lg-4">-->
        <!--                                <div class="panel panel-default no-box-shadow widget-default widget-click">-->
        <!--                                    <div class="panel-header pull-right" style="margin-right: 10px; margin-top: -11px;">-->
        <!--                                        <a class="btn btn-small btn-success pull-right" ng-click="sendMeTo('/pms/policyMapping/multiple')">Map policies in bulk</a>-->
        <!--                                    </div>-->
        <!--                                    <hr/>-->
        <!--                                    <div class="background">-->
        <!--                                        <i class="fa fa-user"></i>-->
        <!--                                    </div>-->
        <!--                                    <div class="panel-body widget widget-body clickAble" ng-click="sendMeTo('/pms/policyMapping/single')">-->
        <!--                                        <i class="fa fa-user"> Policy Mapping</i><br/>-->
        <!--                                        <a>Map users to backup policies</a>-->
        <!--                                    </div>-->
        <!--                                </div>-->
        <!--                            </div>-->
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <div role="tabpanel" class="tab-pane <?php echo $data['activeTabS'];?>" id="sync">
                    <?php if(DISABLE_BLUSYNC == false){ ?>
                        <?php if(Auth::checkCloudPermission('sync')){ ?>
                            <div class="row">
                                <div class="panel">
                                    <div class="panel-heading">
                                        <?php if(BLUDRIVE_MODE == true){?>
                                        <h4 style="padding: 0px 0px 0px 15px;">BluDrive Policy Settings</h4>
                                    <?php } else {?>
                                        <h4 style="padding: 0px 0px 0px 15px;">File Sync and Share Policy Settings</h4>
                                    <?php } ?>
                                    </div>
                                    <div class="panel-body">
                                        <div class="col-lg-4">
                                            <div class="panel panel-default no-box-shadow widget-default widget-click">
                                                <div class="panel-header pull-right" style="margin-right: 10px; margin-top: -11px;">
                                                    <a class="btn btn-success btn-small" ng-click="sendMeTo('/pms/filters')"><i class="fa fa-filter" style="color: white"></i> Filters</a>
                                                    <a class="btn btn-success btn-small hide" ng-click="sendMeTo('/pms/cloudCredentials')"><i class="fa fa-cloud" style="color: white"></i> Cloud Credentials</a>
                                                </div>
                                                <hr/>
                                                <div class="background">
                                                    <i class="fa fa-file-powerpoint-o"></i>
                                                </div>
                                                <div class="panel-body widget widget-body clickAble" ng-click="sendMeTo('/pms/sync/policies')">
                                                    <?php if(BLUDRIVE_MODE == true){?>
                                                        <i class="fa fa-file-powerpoint-o"> BluDrive Policies</i><br/>
                                                    <a>Create, View, Edit, Clone Policies</a>
                                                    <?php } else {?>
                                                        <i class="fa fa-file-powerpoint-o"> File Sync and Share Policies</i><br/>
                                                                    <a>Create, View, Edit, Clone Policies</a>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="panel panel-default no-box-shadow widget-default widget-click">
                                                <div class="panel-header pull-right" style="margin-right: 10px; margin-top: -11px;">
                                                    <a class="btn btn-small btn-success pull-right" ng-click="sendMeTo('/pms/sync/policyMapping/multiple')">Map policies in bulk</a>
                                                </div>
                                                <hr/>
                                                <div class="background">
                                                    <i class="fa fa-user"></i>
                                                </div>
                                                <div class="panel-body widget widget-body clickAble" ng-click="sendMeTo('/pms/sync/policyMapping/single')">
                                                    <i class="fa fa-user"> Policy Mapping</i><br/>
                                                    <?php if(BLUDRIVE_MODE == true){?>
                                                    <a>Map users to BluDrive policies</a>
                                                    <?php } else {?>
                                                    <a>Map users to Sync policies</a>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    <?php } ?>
                </div>
                <div role="tabpanel" class="tab-pane <?php echo $data['activeTabO'];?>" id="office365">
                    <?php if(Auth::checkCloudPermission('office365')){ ?>
                        <div class="row">
                            <div class="panel">
                                <div class="panel-heading">
                                    <h4 style="padding: 0px 0px 0px 15px;">Office 365 Policy Settings</h4>
                                </div>
                                <div class="panel-body">
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click">
                                            <div class="panel-header pull-right" style="margin-right: 10px; margin-top: -11px;">
             									<a class="btn btn-success btn-small" ng-click="sendMeTo('/pms/filters')"><i class="fa fa-filter" style="color: white"></i> Filters</a>
                                                <a class="btn btn-success btn-small" ng-click="sendMeTo('/pms/schedules')"><i class="fa fa-clock-o" style="color: white"></i> Schedules</a>
                                                <a class="btn btn-success btn-small hide" ng-click="sendMeTo('/pms/cloudCredentials')"><i class="fa fa-cloud" style="color: white"></i> Cloud Credentials</a>
                                            </div>
                                            <hr/>
                                            <div class="background">
                                                <i class="fa fa-hdd-o"></i>
                                            </div>
                                            <div class="panel-body widget widget-body clickAble" ng-click="sendMeTo('/pms/oneDrivePolicies')">
                                                <i class="fa fa-hdd-o"> Office 365 Policies</i><br/>
                                                <a>Create, View, Edit, Clone  Policies</a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4">
                                        <div class="panel panel-default no-box-shadow widget-default widget-click">
                                            <div class="panel-header pull-right" style="margin-right: 10px; margin-top: -11px;">
                 								<a class="btn btn-small btn-success pull-right" ng-click="sendMeTo('/pms/oneDrivePolicyMapping/multiple')">Map policies in bulk</a>
                                            </div>
                                            <hr/>
                                            <div class="background">
                                                <i class="fa fa-user"></i>
                                                </div>
                                				<div class="panel-body widget widget-body clickAble" ng-click="sendMeTo('/pms/oneDrivePolicyMapping/single')">
                                                <i class="fa fa-user"> Policy Mapping</i><br/>
                                                <a>Map users to Office 365 policies</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
<!--            <div class="row">-->
<!--                <div class="panel">-->
<!--                    <div class="panel-heading">-->
<!--                        <h4 style="padding: 0px 0px 0px 15px;"></h4>-->
<!--                    </div>-->
<!--                    <div class="panel-body">-->
<!--                        <div class="col-lg-4">-->
<!--                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('/pms/bluvault')">-->
<!--                                <div class="background">-->
<!--                                    <i class="fa fa-cubes"></i>-->
<!--                                </div>-->
<!--                                <div class="panel-body widget widget-body">-->
<!--                                    <i class="fa fa-cubes"> Paraclouds</i><br/>-->
<!--                                    <a>Paracloud Settings</a>-->
<!--                                </div>-->
<!--                            </div>-->
<!--                        </div>-->
<!--                        --><?php //if(BLUKRYPT_PAGE == true){ ?>
<!--                            <div class="col-lg-4">-->
<!--                                <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('/pms/blukrypt')">-->
<!--                                    <div class="background">-->
<!--                                        <i class="fa fa-key"></i>-->
<!--                                    </div>-->
<!--                                    <div class="panel-body widget widget-body">-->
<!--                                        <i class="fa fa-key"> Blukrypt</i><br/>-->
<!--                                        <a>Blukrypt Settings</a>-->
<!--                                    </div>-->
<!--                                </div>-->
<!--                            </div>-->
<!--                        --><?php //} ?>
<!--                        <div class="col-lg-4 hide">-->
<!--                            <div class="panel panel-default no-box-shadow widget-default widget-click clickAble" ng-click="sendMeTo('/pms/networkThrottling')">-->
<!--                                <div class="background">-->
<!--                                    <i class="fa fa-crop"></i>-->
<!--                                </div>-->
<!--                                <div class="panel-body widget widget-body">-->
<!--                                    <i class="fa fa-crop"> Network Throttling</i><br/>-->
<!--                                    <a>Network Throttling Settings</a>-->
<!--                                </div>-->
<!--                            </div>-->
<!--                        </div>-->
<!--                    </div>-->
<!--                </div>-->
<!--            </div>-->
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.timePicker').timepicker({
        showMeridian: false,
        defaultTime: '9:45'
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/PmsController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<style>
.panel-default{
border-color:#f27331 !important;
border-radius: 10px !important;
}
hr{
    border-top: 1px solid #f27331;
}
</style>
