<?php

namespace Controllers;

use Core\View;
use Core\Controller;
use Helpers\Url;
use Models\Migration;
use Helpers\Auth;
/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * Login controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com
 * @version 2.0
 * @date June 10, 2015
 *
 */

class MigrationController extends Controller{

    /**
     * Below variable contains the object reference of a model
     */

    protected $_model;

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        $this->auth->loginCheck();
        $this->auth->tokenCheck();
        $this->language->load('migration');
        $this->_model = new Migration();
        $this->verifyAndCleanItUp();
        Auth::allowOnly('readOnlyAdmin');
    }

    /**
     * Define Index page title and load template files
     */
    public function migration()
    {
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('dashboard'),
            'active' => 'migration',
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'isLdapEnabled' => $this->session->get('isLdapEnabled'),
            'isAADEnabled' => $this->session->get('isAADEnabled')
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('migration/migration', $data);
        View::renderTemplate('footer', $data);
    }

    public function getMigrationDetails(){

        if(!empty($_POST)){

            $headers = array(
                'Content-Type' => 'application/json'
            );

            $result = $this->_model->getMigrationDetails($headers);

            switch ($result['status']) {
                case (200):
                    $response = array(
                        'result' => 'success',
                        'details' => $result
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }

    /**
     * Define Index page title and load template files
     */
    public function importUsers(){
        $result = $this->_model->getAllPolicies(array('token'=>$this->session->get('token')));
        $policies = [];
        if(!empty((array)$result['body']->{'backupPolicyElementList'})){
            foreach((array)$result['body']->{'backupPolicyElementList'} as $value){
                $policy = array('name' => $value->{'policygroupName'});
                $policies = array_merge(array($policy), $policies);
            }
        }

        $syncResult = $this->_model->getAllSyncPolicies(array('token'=>$this->session->get('token')));
        $syncPolicies = [];

        if(!empty((array)$syncResult['body']->{'syncPolicyElementList'})){
            foreach((array)$syncResult['body']->{'syncPolicyElementList'} as $value){
                $policy = array('name' => $value->{'policygroupName'});
                $syncPolicies = array_merge(array($policy), $syncPolicies);
            }
        }
        
        $backupResult1 = $this->_model->getAllBackupPolicyName(array('token'=>$this->session->get('token')));
        $syncResult1 = $this->_model->getAllSyncPolicyName(array('token'=>$this->session->get('token')));
        $odbPolicyResult1 = $this->_model->getAllOneDrivePolicies(array('token'=>$this->session->get('token')));
        $backupPolicies1 = [];
        foreach((array)$backupResult1['body']->{'stringList'} as $value){
            $policy = $value;
            $backupPolicies1 = array_merge(array($policy), $backupPolicies1);
        }

        $syncPolicies1 = [];
        foreach((array)$syncResult1['body']->{'stringList'} as $value){
            $policy = $value;
            $syncPolicies1 = array_merge(array($policy), $syncPolicies1);
        }
        $odbPolicies1 = [];
        foreach((array)$odbPolicyResult1['body']->{'officeBackupPolicyElementList'} as $value){
            $policy = array('name' => $value->{'policygroupName'});
            $odbPolicies1 = array_merge(array($policy), $odbPolicies1);
        }
        natcasesort($backupPolicies1);
        natcasesort($syncPolicies1);
        
        $onedriveBkpEnabled = 'false';
        if($this->session->get('onedriveBkpEnabled') == true){
            $onedriveBkpEnabled = 'true';
        }
        
        $data = array(
            'title' => $this->language->get('indexPageName'),
            'crumb1' => $this->language->get('importUsers'),
            'active' => 'migration',
            'onedriveBkpEnabled' => $onedriveBkpEnabled,
            'policies' => $policies,
            'syncPolicies' => $syncPolicies,
            'policies1' => $backupPolicies1,
            'syncPolicies1' => $syncPolicies1,
            'odbPolicies1' => $odbPolicies1,
            'csrf_token' => $this->setCSRFToken(),
            'loggedInUser' => $this->session->all(),
            'isLdapEnabled' => $this->session->get('isLdapEnabled'),
            'isAADEnabled' => $this->session->get('isAADEnabled')
        );

        View::renderTemplate('header', $data);
        View::renderTemplate('navigation', $data);
        View::render('migration/importUsers', $data);
        View::renderTemplate('footer', $data);
    }

    public function getUsers(){
        if(!empty($_POST['userList'])){

            $headers = array(
                'Content-Type' => 'application/json'
            );

            $result = $this->_model->getUsersForMigration($headers, json_encode(array('ldapUserNames' => $_POST['userList'])));
            $this->log('result: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $users = [];
                    if(!empty($result['body']->{'ldapUserElementList'})){
                        foreach($result['body']->{'ldapUserElementList'} as $value){
                            $user = array(
                                'userName' => $value->{'userName'},
                                'emailId' => $value->{'emailId'},
                                'organizationUnit' => $value->{'organizationUnit'},
                                'defaultPolicy' => !empty($_POST['policyName']) ? $_POST['policyName'] : '',
                                'defaultSyncPolicy' => !empty($_POST['syncPolicy']) ? $_POST['syncPolicy'] : '',
                                //'defaultO365Policy' => !empty($_POST['defaultOdbPolicy']) ? $_POST['defaultOdbPolicy'] : '',
                                'defaultOdbPolicy' => !empty($_POST['defaultOdbPolicy']) ? $_POST['defaultOdbPolicy'] : '',
                                'displayName' => $value->{'displayName'},
                                'location' => $value->{'location'},
                                'department' => $value->{'department'},
                                'accountStatus' => $value->{'accountStatus'},
                            );
                            $users = array_merge(array($user), $users);
                        }
                    }

                    $response = array(
                        'result' => 'success',
                        'groupName' => $result['header']->{'container'},
                        'policy' => $_POST['policyName'],
                        'syncPolicy' => $_POST['syncPolicy'],
                        'userList' => $users
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (406):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('413')
                    );
                    echo json_encode($response);
                    exit;
                case (417):
                    $response = array(
                        'result' => 'fail_unable',
                        'msg' => 'Unable to Migrate the users. AD Password is incorrect.'
                    );
                    echo json_encode($response);
                    exit;
                case (204):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'Either User not exist/User is not in AD'
                    );
                    echo json_encode($response);
                    exit;
                case (503):
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'Unable to reach AD Server. Please verify the AD IP/Domain Name.'
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    
    public function getUsersAAD(){
        if(!empty($_POST['userList'])){

            $headers = array(
                'Content-Type' => 'application/json',
                'Accept'        => 'application/json',
            );

            $result = $this->_model->getUsersForMigrationAAD($headers, array('aadUserNames' => $_POST['userList']));
            $this->log('result_aadUserNames: '. json_encode($result), 'info');
            switch ($result['status']) {
                case (200):
                    $users = [];
                    if(!empty($result['body']->{'AADUserElementList'})){
                        foreach($result['body']->{'AADUserElementList'} as $value){
                            $user = array(
                                'userName' => $value->{'userName'},
                                'userPrincipalName' => $value->{'userPrincipalName'},
                                'mail' => $value->{'mail'},
                                'organizationUnit' => $value->{'organizationUnit'},
                                'defaultPolicy' => !empty($_POST['policyName']) ? $_POST['policyName'] : '',
                                'defaultSyncPolicy' => !empty($_POST['syncPolicy']) ? $_POST['syncPolicy'] : '',
                                //'defaultO365Policy' => !empty($_POST['defaultOdbPolicy']) ? $_POST['defaultOdbPolicy'] : '',
                                'defaultOdbPolicy' => !empty($_POST['defaultOdbPolicy']) ? $_POST['defaultOdbPolicy'] : '',
                                'displayName' => $value->{'displayName'},
                                 'officeLocation' => $value->{'officeLocation'},
                                'department' => $value->{'department'},
                                'accountStatus' => $value->{'accountStatus'},
                            );
                            $users = array_merge(array($user), $users);
                        }
                    }

                    $response = array(
                        'result' => 'success',
                        'groupName' => $result['header']->{'container'},
                        'policy' => $_POST['policyName'],
                        'syncPolicy' => $_POST['syncPolicy'],
                        'userList' => $users
                    );
                    echo json_encode($response);
                    exit;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (406):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('4133')
                    );
                    echo json_encode($response);
                    exit;
                case (204):
                    $response = array(
                        'result' => 'fail',
                        'msg' => 'Either User not exist/User is not in AAD'
                    );
                    echo json_encode($response);
                    exit;
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (503):
                    $result = array(
                        'result' => 'fail',
                        'msg' => 'Unable to reach AAD Server. Please verify the AAD IP/Domain Name.'
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    
    public function downloadSample(){
        $this->log("here . ","info");
    $filePath = OVERVIEW_REPORT_PATH.BULK_BLOCK_UNBLOCK_DELETE_USERS_SAMPLE;
    $this->log("path -> ".$filePath,"info");
            if(file_exists($filePath)){
                header('Content-Type: application/csv');
                header('Content-Disposition: attachment; filename='.USER_MIGRATION_SAMPLE);
                header('Pragma: no-cache');
                ob_clean();
                readfile($filePath);
            }else{
                header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=404'));
            }
/*        }else{
            header('Location: '.Url::basePath('report/'.$_GET['from'].'?result=500'));
        }*/

    }

    public function migrateUsers(){
        if(!empty($_POST['userList'])){

            $headers = array(
                'Content-Type' => 'application/json',
                'groupName' => $_POST['groupName'],
                'adminName' => $this->session->get('userName')
            );
            if($_POST['migrationType'] == 'sync' || $_POST['migrationType'] == 'both'){
                $headers['syncEnabled'] = 'true';
            }else{
                $headers['syncEnabled'] = 'false';
            }
            if($_POST['migrationType'] == 'backup' || $_POST['migrationType'] == 'both'){
                $headers['backupEnabled'] = 'true';
            }else{
                $headers['backupEnabled'] = 'false';
            }
            if($_POST['migrationType'] == 'o365' || $_POST['migrationType'] == 'both'){
                $headers['o365BackupEnabled'] = 'true';
            }else{
                $headers['o365BackupEnabled'] = 'false';
            }

            $result = $this->_model->migrateUsers($headers, json_encode(array('ldapUserElements' => $_POST['userList'])));
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('migratedUsers')
                    );
                    echo json_encode($response);
                    exit;
                case (206):
                    if($result['body']->{'totalUsersMigrated'} <= 0){
                        $response = array(
                            'result' => 'fail',
                            'msg' => 'None of the users migrated'
                        );
                    }else if($result['body']->{'totalUsersMigrated'} == 1){
                        $response = array(
                            'result' => 'fail',
                            'msg' => 'Partially Migrated ,'. $result['body']->{'totalUsersMigrated'}.' user out of '.$result['body']->{'totalUsersCount'}. ' users.',
                        );
                    }else{
                        $response = array(
                            'result' => 'fail',
                            'msg' => 'Partially Migrated ,'. $result['body']->{'totalUsersMigrated'}.' users out of '.$result['body']->{'totalUsersCount'}. ' users.',
                        );
                    }
                    echo json_encode($response);
                    exit;
                case (406):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('413')
                    );
                    echo json_encode($response);
                    exit;
                case (401):
                    if($result['header']->{'container'}['AD_Unauthorized'] == 'true'){
                        $response = array(
                            'result' => 'fail',
                            'msg' => 'Unable to Migrate the users. AD Password is incorrect.'
                        );
                    }
                    echo json_encode($response);
                    exit;
                case (413):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('413')
                    );
                    echo json_encode($result);
                    exit();
                case (417):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('417')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
    
    public function migrateUsersAAD(){
        if(!empty($_POST['userList'])){

            $headers = array(
                'Content-Type' => 'application/json',
                //'groupName' => $_POST['groupName'],
                'adminName' => $this->session->get('userName')
            );
            if($_POST['migrationType'] == 'sync' || $_POST['migrationType'] == 'both'){
                $headers['syncEnabled'] = 'true';
            }else{
                $headers['syncEnabled'] = 'false';
            }
            if($_POST['migrationType'] == 'backup' || $_POST['migrationType'] == 'both'){
                $headers['backupEnabled'] = 'true';
            }else{
                $headers['backupEnabled'] = 'false';
            }
            if($_POST['migrationType'] == 'o365' || $_POST['migrationType'] == 'both'){
                $headers['o365BackupEnabled'] = 'true';
            }else{
                $headers['o365BackupEnabled'] = 'false';
            }

            $result = $this->_model->migrateUsersAAD($headers, json_encode(array('aadUsersList' => $_POST['userList'])));
            switch ($result['status']) {
                case (200):

                    $response = array(
                        'result' => 'success',
                        'msg' => $this->language->get('migratedUsers')
                    );
                    echo json_encode($response);
                    exit;
                case (206):
                    if($result['body']->{'totalUsersMigrated'} <= 0){
                        $response = array(
                            'result' => 'fail',
                            'msg' => 'None of the users migrated'
                        );
                    }else if($result['body']->{'totalUsersMigrated'} == 1){
                        $response = array(
                            'result' => 'fail',
                            'msg' => 'Partially Migrated ,'. $result['body']->{'totalUsersMigrated'}.' user out of '.$result['body']->{'totalUsersCount'}. ' users.',
                        );
                    }else{
                        $response = array(
                            'result' => 'fail',
                            'msg' => 'Partially Migrated ,'. $result['body']->{'totalUsersMigrated'}.' users out of '.$result['body']->{'totalUsersCount'}. ' users.',
                        );
                    }
                    echo json_encode($response);
                    exit;
                case (406):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('4133')
                    );
                    echo json_encode($response);
                    exit;
                case (413):
                    $response = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('4133')
                    );
                    echo json_encode($response);
                    exit;
                case (417):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('417')
                    );
                    echo json_encode($result);
                    exit();
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            echo json_encode(array(
                    'result' => 'noData',
                    'message' => $this->language->get('noData'),
                    'redirect' => (!empty($this->session->get('currentDeviceUUID'))) ? true : false
                )
            );
        }
    }
}
