<?php use \Core\View;
use Helpers\Form;
use Helpers\Auth;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('users')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['subTitle']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="UserController">
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <div class="row">
                <div class="panel panel-default">
                    <div class="panel-heading">
                        <h4>
                            <?=Language::show('createUser', 'keywords');?>
                        </h4>
                    </div>
                    <div class="panel-body">
                        <?=
                        Form::open(array(
                            'ng-submit' => 'saveNewUserDetails()',
                            'method' => 'post',
                            'class' => 'userCreationFrom',
			    'id' => 'userCreationFrom',
                            'csrf' => $data['csrf_token'],
                            'autocomplete' => 'off',
                            'data-parsley-validate' => true
                        ));
                        ?>
                        <div class="row" style="margin-left:10px;">
                            <legend class="h4" style="color: #585f69;"><?=Language::show('Basic Information', 'keywords')?></legend>
			    <div class="form-group col-lg-6 hide">
                                <label for="relax"><?=Language::show('relax', 'keywords');?></label>
                                <input type="text" class="form-control" name="relax" id="relax" <?php if(RELAXED_CHECK == true){?> value="relaxed" <?php } else { ?> value="notrelaxed" <?php } ?>>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="username"><?=Language::show('username', 'keywords');?></label>
                                <input type="text" class="form-control" name="username" id="username" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('username', 'keywords');?>" required autocomplete="off" minlength="3" maxlength="104" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are '@','_' and '.' Any other special characters are not allowed.">
                            </div>
			                <div class="form-group col-lg-6">
                                <label for="email"><?=Language::show('email', 'keywords');?></label>
                                <input type="text" class="form-control" name="email" id="email" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('email', 'keywords');?>" required autocomplete="off" data-parsley-type="email" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="This value should be a valid email.">
                            </div>
			                <div class="form-group col-lg-6">
                                <label for="password"><?=Language::show('password', 'keywords');?></label>
				                <?php if(complexPassword == true) { ?>
                                <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-minlength="6" data-parsley-required data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')" data-parsley-trigger="change">
				                <?php } else { ?>
                                <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" required autocomplete="off"  data-parsley-required data-parsley-minlength="6">
                                <?php } ?>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="rePassword"><?=Language::show('rePassword', 'keywords');?></label>
                                <input type="password" class="form-control" name="rePassword" id="rePassword" placeholder="<?=Language::show('rePassword', 'keywords');?>" required autocomplete="off" data-parsley-required data-parsley-equalto="#password" data-parsley-trigger="change">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="displayName"><?=Language::show('displayName', 'keywords');?></label>
                                <input type="text" class="form-control" name="displayName" id="displayName" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('displayName', 'keywords');?>" autocomplete="off" minlength="3" maxlength="104" data-toggle="popover" data-trigger="focus" data-placement="bottom" data-content="Only allowed special characters are @ and. Any other special characters are not allowed.">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="location"><?=Language::show('location', 'keywords');?></label>
                                <input type="text" class="form-control" name="location" id="location" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('location', 'keywords');?>" autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="department"><?=Language::show('department', 'keywords');?></label>
                                <input type="text" class="form-control" name="department" id="department" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('department', 'keywords');?>" autocomplete="off">
                            </div>
                            
                            <div class="form-group col-lg-6 account_type" style="margin-bottom:20px;">
                                <label for="account_type"><?=Language::show('account_type', 'keywords')?></label>
                                <select class="form-control selectPicker" name="account_type" id="account_type" required="">
                                    <option value="user"><?=Language::show('user', 'keywords')?></option>
                                    <?php if($data['loggedInUser']['readOnlyAdmin'] != true){ ?>
                                    <option value="admin"><?=Language::show('admin', 'keywords')?></option>
                                    <option value="read_only_admin"><?=Language::show('read_only_admin', 'keywords')?></option>
                                    <?php } ?>
                                </select>
                            </div>
			    <?php if(STORAGE_TYPE == "ONE_DRIVE"){ ?>
                                <div class="form-group col-lg-6">
                                    <label for="odb_login_Id"><?=Language::show('OneDrive for Business Login Id', 'keywords');?></label>
                                    <input type="text" class="form-control" name="odb_login_Id" id="odb_login_Id" value="<?=$data['userDetails']->{'odb-loginId'};?>" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('OneDrive for Business Login Id', 'keywords');?>" autocomplete="off">
                                </div>
                            <?php } ?>
</div>
<?php if(Auth::checkCloudPermission('backup') == true){ ?>
<div class="row <?php if(DISABLE_BLUVAULT == true || Auth::checkCloudPermission('backup') == false) { echo 'hide'; } ?>" style="margin-left:10px;">
                            <legend class="h4" style="color: #585f69;"><?=Language::show('Backup Information', 'keywords')?></legend>
<?php if($data['loggedInUser']['backupEnabled'] == true){ ?>
                                <div class="form-group col-lg-6 backup <?php if(DISABLE_BLUVAULT == true) { echo 'hide'; } ?>">
                                    <label for="backup"><?=Language::show('backup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="backup" id="backup" required="">
                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6 backup backupPolicyName <?php if(DISABLE_BLUVAULT == true) { echo 'hide'; } ?>">
                                    <label for="policyName"><?=Language::show('backupPolicyName', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="policyName" id="policyName" required="">
                                        <?php if(!empty($data['backupPolicies1'])){ ?>
                                            <?php foreach($data['backupPolicies1'] as $key => $value){ 
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                                <option value="<?=$value?>"><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                            <?php } ?>
                            <?php if($data['loggedInUser']['serverBackupEnabled'] == true){ ?>
                                <div class="form-group col-lg-6 serverBackup">
                                    <label for="serverBackup"><?=Language::show('serverBackup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="serverBackup" id="serverBackup" required="">
                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
                            <?php } ?>
			    <div class="form-group col-lg-12 backupPoliciesAdmin">
                                <label for="backupPoliciesAdmin">Manage Backup Policies</label>
                                    <select name="backupPoliciesAdmin[]" id="backupPoliciesAdmin" class="form-control selectPicker" title="Select Backup Policies Name" multiple <?php if(Auth::checkCloudPermission('backup') == true && $data['userDetails']->{'is-readonly-admin'} == 'true' ) { echo "required";} ?>>
                                                <?php if(!empty($data['backupPolicies1'])){ ?>
                                                    <?php foreach($data['backupPolicies1'] as $key => $value){ 
                                                    $label = $value;
                                                    if( strlen( $label ) > 25 ) {
                                                       $label = substr( $label, 0, 25 ) . '...';
                                                    }
                                                    ?>
                                                        <option value="<?=$value?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                    </select>
                            </div>
</div>
<?php } ?>
<?php if(Auth::checkCloudPermission('sync') == true){ ?>
<div class="row <?php if(DISABLE_BLUSYNC == true || Auth::checkCloudPermission('sync') == false) { echo 'hide'; } ?> " style="margin-left:10px;">
                            <legend class="h4" style="color: #585f69;"><?php if(BLUDRIVE_MODE == false){ ?><?=Language::show('Sync Information', 'keywords')?> <?php } else {?><?=Language::show('BluDrive Information', 'keywords')?><?php } ?></legend>


                            <?php if($data['loggedInUser']['syncWebAccessEnabled'] == true || $data['loggedInUser']['syncEnabled'] == true){ ?>
                                <?php if(!empty($data['miniClouds']->{'mini-cloud'})){ ?>
                                    <div class="form-group col-lg-6 miniCloudName <?php if(DISABLE_BLUSYNC == true) { echo 'hide'; } ?>">
                                        <label for="miniCloudName"><?=Language::show('miniCloudName', 'keywords')?></label>
                                        <select class="form-control selectPicker" name="miniCloudName[]" id="miniCloudName" multiple title='Select Mini Clouds'>
                                            <?php foreach($data['mini'] as $key => $value){ ?>
                                            <?php
                                                $trimmedName = str_replace("_mc_","",$value->{'mini-cloud-name'});
                                            ?>
                                                <option value="<?=$value->{'mini-cloud-name'}?>"><?=$trimmedName?></option>
                                            <?php } ?>
                                        </select>
                                    </div>
                                <?php } ?>
                            <?php } ?>
                        <?php if($data['loggedInUser']['syncWebAccessEnabled'] == true || $data['loggedInUser']['syncEnabled'] == true){ ?>
                                <div class="form-group col-lg-6 sync_access <?php if(DISABLE_BLUSYNC == true) { echo 'hide'; } ?>">
                                    <label for="sync_access"><?php if(BLUDRIVE_MODE == false){?><?=Language::show('sync_access', 'keywords')?><?php } else { ?>BluDrive Access <?php } ?></label>
                                    <select class="form-control selectPicker" name="sync_access" id="sync_access" required="">
                                        <option value="false"><?=Language::show('web_access', 'keywords')?></option>
                                        <?php if(BLUDRIVE_MODE == false) {?> <option value="true"><?=Language::show('epa_web_access', 'keywords')?></option> <?php } ?>
                                    </select>
                                </div>
                                <div class="form-group col-lg-6 sync <?php if(DISABLE_BLUSYNC == true) { echo 'hide'; } ?>">
                                    <label for="syncPolicyName"><?php if(BLUDRIVE_MODE == false){ ?><?=Language::show('syncPolicyName', 'keywords');?><?php } else { ?> BluDrive Policy Name <?php } ?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="syncPolicyName" id="syncPolicyName" required="">
                                        <?php if(!empty($data['syncPolicies1'])){ ?>
                                            <?php foreach($data['syncPolicies1'] as $key => $value){ 
                                            $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                                <option value="<?=$value?>"><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>

                                <div class="form-group col-lg-6 share_enabled hide">
                                    <label for="share_enabled"><?=Language::show('share_enabled', 'keywords')?></label>
                                    <select class="form-control" name="share_enabled" id="share_enabled" required="">
                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>
				<div class="form-group <?php if(!empty($data['miniClouds']->{'mini-cloud'})){ ?> col-lg-6 <?php } else { ?> col-lg-12 <?php } ?> syncPoliciesAdmin">
                                    <label for="syncPoliciesAdmin"><?php if(BLUDRIVE_MODE == false){ ?> Manage Sync Policies <?php } else { ?>Manage BluDrive Policies <?php } ?></label>
                                    <select name="syncPoliciesAdmin[]" id="syncPoliciesAdmin" class="form-control selectPicker" <?php if(BLUDRIVE_MODE == false){?> title="Select Sync Policies Name" <?php } else { ?> title="Select BluDrive Policies Name" <?php } ?> multiple  <?php if(Auth::checkCloudPermission('sync') == true && $data['userDetails']->{'is-readonly-admin'} == 'true') { echo 'required';} ?>>
                                        <?php if(!empty($data['syncPolicies1'])){ ?>
                                             <?php foreach($data['syncPolicies1'] as $key => $value){ 
                                             $label = $value;
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                             ?>
                                                <option value="<?=$value?>"><?=$label?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
                        <?php } ?>
                            </div>
    <?php } ?>          
    <?php if(Auth::checkCloudPermission('office365') == true){ ?>
    <!--<div class="row <?php if(DISABLE_BLUVAULT == true || Auth::checkCloudPermission('backup') == false) { echo 'hide'; } ?>" style="margin-left:10px;">-->
    <div class="row" style="margin-left:10px;">
                            <legend class="h4" style="color: #585f69;"><?=Language::show('Office 365 Information', 'keywords')?></legend>
                                <!--<div class="form-group col-lg-6 onedriveBkpEnabled">
                                    <label for="onedriveBkpEnabled"><?=Language::show('Office 365 Backup', 'keywords')?></label>
                                    <select class="form-control selectPicker" name="onedriveBkpEnabled" id="onedriveBkpEnabled" required="">
                                        <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                        <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                    </select>
                                </div>-->
	    			<div class="form-group col-lg-6">
					<label class="star" for="onedriveBkpEnabled"><?=Language::show('Office 365 Backup', 'keywords')?></label>
                                        <div class="checkbox check-primary">
						<?php if(Auth::checkCloudPermission('onedrive') == true){ ?>
						    <input id="onedriveBkpEnabled" name="onedriveBkpEnabled" type="checkbox" value="enabled">
						    <label for="onedriveBkpEnabled"><?=Language::show('Enable OneDrive', 'keywords');?></label>
						<?php } ?>
						<?php if(Auth::checkCloudPermission('exchange') == true){ ?>
							<input id="exchangeBkpEnabled" name="exchangeBkpEnabled" type="checkbox" value="enabled">
							<label for="exchangeBkpEnabled"><?=Language::show('Enable Exchange', 'keywords');?></label>
						<?php } ?>
                                        </div>
                                    </div>
                                <div class="form-group col-lg-6 odbPolicyName">
                                    <label for="odbPolicyName"><?=Language::show('Office 365 Policy Name', 'keywords');?></label><br/>
                                    <select class="form-control selectPolicyPicker" name="odbPolicyName" id="odbPolicyName" required="">
                                        <?php if(!empty($data['odbPolicies1'])){ ?>
                                            <?php foreach($data['odbPolicies1'] as $key => $value){ 
                                            $label = $value['name'];
                                            if( strlen( $label ) > 25 ) {
                                               $label = substr( $label, 0, 25 ) . '...';
                                            }
                                            ?>
                                            <option value="<?=$value['name']?>"><?=$value['name']?></option>
                                            <?php } ?>
                                        <?php } ?>
                                    </select>
                                </div>
</div>
                            <div class="form-group col-lg-12 odbPoliciesAdmin">
                                <label for="odbPoliciesAdmin">Manage Office365 Policies</label>
                                    <select name="odbPoliciesAdmin[]" id="odbPoliciesAdmin" class="form-control selectPicker" title="Select Office 365 Policies Name" multiple <?php if(Auth::checkCloudPermission('office365') == true && $data['userDetails']->{'is-readonly-admin'} == 'true' ) { echo "required";} ?>>
                                                <?php if(!empty($data['odbPolicies1'])){ ?>
                                                    <?php foreach($data['odbPolicies1'] as $key => $value){
                                                    $label = $value['name'];
                                                    if( strlen( $label ) > 25 ) {
                                                       $label = substr( $label, 0, 25 ) . '...';
                                                    }
                                                    ?>
                                                        <option value="<?=$value['name']?>"><?=$label?></option>
                                                    <?php } ?>
                                                <?php } ?>
                                    </select>
                            </div>
<?php } ?>
                        
                        <div class="form-group col-lg-12">
                            <button type="submit" class="userSave btn btn-primary pull-right"><?=Language::show('save', 'keywords');?></button>
                        </div>
                        <?=
                        Form::close();
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('.selectPolicyPicker').selectpicker('render');
    $('#backup').on('change', function(){
        if($('#backup').val() == 'true'){
            $('.backupPolicyName').show()
            $('#policyName').attr('required', 'required');
            $('#policyName').selectpicker('refresh');
        }else{
            $('.backupPolicyName').hide()
            $('#policyName').removeAttr('required', 'required');
            $('#policyName').selectpicker('refresh');
        }
    });
    $(".backupPoliciesAdmin").hide();
    $(".syncPoliciesAdmin").hide();
    $(".odbPoliciesAdmin").hide();
    $("#backupPoliciesAdmin").removeAttr('required');
    $("#syncPoliciesAdmin").removeAttr('required');
    $("#odbPoliciesAdmin").removeAttr('required');
    $("#account_type").on('change',function(){
        if($("#account_type").val() == 'read_only_admin'){
            <?php if(Auth::checkCloudPermission('backup') == true){ ?>
                $(".backupPoliciesAdmin").show();
                //$("#backupPoliciesAdmin").attr("required", "true");
                $("#backupPoliciesAdmin").selectpicker('refresh');
            <?php }?>
            <?php if(Auth::checkCloudPermission('sync') == true){ ?>
                $(".syncPoliciesAdmin").show();
                //$("#syncPoliciesAdmin").attr("required", "true");
                $("#syncPoliciesAdmin").selectpicker('refresh');
            <?php }?>
            <?php if(Auth::checkCloudPermission('office365') == true){ ?>
                $(".odbPoliciesAdmin").show();
                //$("#odbPoliciesAdmin").attr("required", "true");
                $("#odbPoliciesAdmin").selectpicker('refresh');
            <?php }?>
        }
        else{
            <?php if(Auth::checkCloudPermission('backup') == true){ ?>
                $(".backupPoliciesAdmin").hide();
                //$("#backupPoliciesAdmin").removeAttr('required');
                $("#backupPoliciesAdmin").selectpicker('refresh');
            <?php }?>
            <?php if(Auth::checkCloudPermission('sync') == true){ ?>
                $(".syncPoliciesAdmin").hide();
                //$("#syncPoliciesAdmin").removeAttr('required');
                $("#syncPoliciesAdmin").selectpicker('refresh');
            <?php }?>
            <?php if(Auth::checkCloudPermission('office365') == true){ ?>
                $(".odbPoliciesAdmin").hide();
                //$("#odbPoliciesAdmin").removeAttr('required');
                $("#odbPoliciesAdmin").selectpicker('refresh');
            <?php }?>
        }
    });
    /*
$(document).ready(function (){
	$('#username').on('click', function (e) {
            $('[name="username"]').popover('hide');
            $('[name="username"]').popover('destroy');
    });
});*/
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/UserController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
