<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
use Helpers\Form;
use Helpers\Auth;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><?=$data['title']?></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
    </div>
</div>
<div class="main" ng-controller="DeviceController">
    <span class="hide currentPage"><?='devicesListPage'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
<div class="col-lg-11 col-md-11 col-sm-11 ng-cloak" >
            
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak" >
            <div class="panel nodevice1" style="display:none">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('list_of_devices', 'keywords');?>
                    </h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <h2 align="center"><?=Language::show('noDevices', 'keywords');?></h2>
                        </div>
                    </div>
                </div>
            </div>
			<div class="panel hasDevices" style="display:none;">
                <div class="panel-heading">
                    <h4>
                        <?=Language::show('list_of_devices', 'keywords');?>
                        <?php if(block == false){ ?>
                            <a class="btn btn-danger btn-small pull-right" disabled style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Devices in bulk</a>
                        <?php } else {?>
                        <?php if(!isMobile()){ ?>
                            <a class="btn btn-danger btn-small pull-right" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Devices in bulk</a>
                        <?php }else { ?>
                            <a class="btn btn-danger btn-small" style="margin-right: 10px; color: #ffffff;" href="<?=Url::basePath('devices/devicesBulkBlock')?>">Manage Devices in bulk</a>
                        <?php } ?>
                        <?php } ?>
                        <?php if(!isMobile()){ ?>
                            <a ng-click="exportDevicesToExcel()" class="btn btn-small pull-right" style="margin-right: 10px;">Export Devices</a>
                        <?php } else { ?>
                            <a ng-click="exportDevicesToExcel()" class="btn btn-small" style="margin-top: 2px;margin-right: 10px;">Export Devices</a>
                        <?php } ?>
                    </h4>
                </div>
                <div class="panel-body">
                    <div class="row">
                        <!--<div class="col-lg-12">
                            <form ng-submit="searchDevice(search.deviceName)">
                                <input name="deviceName"
                                       type="text"
                                       class="pull-right form-control"
                                       ng-model="search.deviceName"
                                       placeholder="Enter a 'Device Name' or 'all (for all devices)' and hit enter to search"
                                       data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                       data-content="Entered Device Name was not found!!! "
                                />
                            </form>
                        </div>-->
                        <form ng-submit="searchDevice1(search.deviceName)" data-parsley-validate>
                            <div class="col-lg-10">
                                <select class="searchDeviceName" id="deviceName" style="width: 100%;" ng-model="search.deviceName" data-parsley-trigger="change" multiple="multiple"></select>
                            </div>
                            <div class="col-lg-2">
                                <button type="submit" class="btn btn-default">Search Devices</button>
                            </div>
                        </form>
                    </div>
                    <br/>
                    <div class="table-responsive">
                        <div class="h4 loading text-center">Loading.....</div>
                        <div class="h4 nodevice text-center" style="display: none;">No device matched</div>
                        <table class="table table-bordered table-striped deviceListTable" style="display: none;">
                            <thead>
                            <tr>
                                <th class="text-center"><?=Language::show('osType', 'keywords')?></th>
                                <th class="clickAble" ng-click="sortType = 'deviceName'; sortReverse = !sortReverse">
                                    <?=Language::show('deviceName', 'keywords')?>
                                    <span ng-show="sortType == 'deviceName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'deviceName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                    <?=Language::show('userId', 'keywords')?>
                                    <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="clickAble" ng-click="sortType = 'status'; sortReverse = !sortReverse">
                                    <?=Language::show('status', 'keywords')?>
                                    <span ng-show="sortType == 'status' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="sortType == 'status' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-center"><?=Language::show('action', 'keywords')?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr ng-repeat="value in devices | orderBy:sortType:sortReverse">
                                <td class="text-center" ng-cloak><i class="fa fa-{{ value.icon }}"></i></td>
                                <td title="{{ value.deviceName }}" ng-cloak>{{ value.deviceName | limitTo:20}}{{value.deviceName.length > 20 ? '...' : ''}}</td>
                                <td title="{{ value.userName }}" ng-cloak>{{ value.userName | limitTo:20}}{{value.userName.length > 20 ? '...' : ''}}</td>
                                <td ng-cloak class="text-center">
                                    <h5><label class="label label-success" ng-if="value.blocked == false && value.decoupled == false"><?=Language::show('Active', 'keywords')?></label></h5>
                                    <h5><label class="label label-danger" ng-if="value.blocked == true"><?=Language::show('Blocked', 'keywords')?></label></h5>
                                    <h5><label class="label label-danger" ng-if="value.blocked == false && value.decoupled == true"><?=Language::show('Decoupled', 'keywords')?></label></h5>
                                </td>
                                <td>
                                    <span class="hide ownerFor{{value.deviceId}}" id="ownerFor{{value.deviceId}}">{{value.ownerList}}</span>
                                    <a ng-click="properties(value.deviceUUID)" class="btn btn-small btn-default">Properties</a>
				                    <button ng-click="logAction(value.deviceUUID,value.deviceType)" class="btn btn-small btn-default" ng-class="[{true:'not-allowed'}[value.blocked],{true:'not-allowed'}[value.decoupled]]">Actions</button>
                                    <a ng-bootbox-confirm="<h4><?=Language::show('unBlockConfirmDevice', 'keywords')?></h4>"
                                       ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, false,value.userName, value.deviceName)"
                                       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-success" ng-if="value.blocked == true"><i class="fa fa-plus-circle"></i> <?=Language::show('unblock', 'keywords');?></a>
                                    <a ng-bootbox-confirm="<h4><?=Language::show('deleteConfirmDevice', 'keywords')?></h4><br><span style='font-size:12px;'>Note : This action will result in <u>permanently</u> deleting all backups for this device.  Are you sure you wish to proceed?</span>"
                                       ng-bootbox-confirm-action="deleteDevice(value.deviceUUID,value.userName, value.deviceName)"
                                       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-danger" ng-if="value.blocked == true"><i class="fa fa-minus-circle"></i> <?=Language::show('Delete', 'keywords');?></a>				    
                                    <a ng-hide="value.blocked == false" class="btn btn-default btn-small" name="{{value.deviceUUID}}" id="{{value.deviceId}}" title="{{value.deviceName}}" onclick="addCurrentOwner(this.id, this.title, this.name)">Assign additional owners</a>
                                    <a ng-bootbox-confirm="<h4><?=Language::show('blockConfirmDevice', 'keywords')?></h4>"
                                       ng-bootbox-confirm-action="blockUnBlockDevice(value.deviceUUID, true,value.userName, value.deviceName)"
                                       ng-bootbox-confirm-action-cancel="" class="btn btn-small btn-danger" ng-if="value.blocked == false"><i class="fa fa-minus-circle"></i> <?=Language::show('block', 'keywords');?></a>
                                    <?php if(\Helpers\Auth::checkCloudPermission('backup')){ ?>
                                        <?php if(RESTORE_FROM_PORTAL){ ?>
                                            <a ng-click="initiateRestoreBackup(value.deviceUUID, value.deviceName, $index)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Restore Entire Device</a>
                                            <a ng-click="sendMeTo('<?=Url::basePath("backup/files/restore")?>/'+value.deviceId+'/'+value.deviceName+'/'+value.deviceUUID)" class="btn btn-primary btn-small initiateRestoreBtn{{$index}}">Restore Selected Files</a>
                                        <?php } ?>
                                    <?php } ?>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="row deviceListTableNavigate">
                        <div class="col-lg-12 text-center">
                            <p><span ng-cloak>Page {{currentpageCount}} of {{totalpageCount}}</span></p>
                            <a class="btn btn-primary first" ng-click="updateDevicesNavigate('all',first)" style="display: none;"><i class="fa fa-angle-double-left"></i></a>
                            <a class="btn btn-primary previous" ng-click="updateDevicesNavigate('all',previous)" style="display: none;"><i class="fa fa-angle-left"></i></a>
                            <a class="btn btn-primary next" ng-click="updateDevicesNavigate('all',next)" style="display: none;"><i class="fa fa-angle-right"></i></a>
                            <a class="btn btn-primary last" ng-click="updateDevicesNavigate('all',last)" style="display: none;"><i class="fa fa-angle-double-right"></i></a>
                        </div>
                    </div>
                    <!--<div class="row loadMore" style="display: none;">
                        <div class="col-lg-12 text-center">
                            <a class="loadMoreBtn btn btn-primary" ng-click="loadMoreDevices(skipValue)">Load More ...</a>
                        </div>
                    </div>-->
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade restoreBucket">
        <div class="modal-dialog">
            <div class="modal-content">
                <form class="form-inline" data-parsley-validate>
                    <div class="modal-header" style="margin-bottom: -10px;">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">Restore Bucket</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="">
                                    <br/>
                                    <div class="form-group col-lg-12">
                                        <label for="searchDeviceName">Select a Device to restore on:</label>
                                        <select class="searchDeviceName" style="width: 100%;" id="deviceName" ng-model="restoreBucket.deviceName" data-parsley-trigger="change"></select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="restoreAllVersions">Do you want to restore all versions</label>
                                        <select class="form-control selectPicker" name="restoreAllVersions" id="restoreAllVersions" required="">
                                            <option value="true"><?=Language::show('Yes', 'keywords')?></option>
                                            <option value="false" selected><?=Language::show('No', 'keywords')?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-lg-12">
                                        <br/>
                                        <label for="destinationPath">Enter a Destination Path(optional)</label>
                                        <input type="text" class="form-control" style="width: 100%;" ng-model="restoreBucket.destinationPath" id="destinationPath" placeholder="Enter Destination Path" />
                                        <span class="help-block">Note:- If Destination Path is not entered file will be restored on to the same location, as where it was backuped up from.</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" ng-click="sendFilesForRestore(restoreBucket.deviceName, restoreBucket.destinationPath)"  class="btn btn-default">Initiate Restore</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="modal fade deviceDetails">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Device Details</h4>
                </div>
                <div class="modal-body">
                    <p><b>Created At</b>: <span class="pull-right" ng-cloak>{{ selectedDevice.createdTimeStamp }}</span></p>
                    <p><b>Name</b>: <span class="pull-right" ng-cloak>{{ selectedDevice.deviceName }}</span></p>
                    <p><b>Os Type</b>: <span class="pull-right" ng-cloak>{{ selectedDevice.osType }}</span></p>
                    <p ng-if="selectedDevice.decoupled == 'true'" ng-cloak><b>Has Device De-Coupled</b>: <span class="pull-right">Yes</span></p>
                    <p ng-if="selectedDevice.decoupled == 'false'" ng-cloak><b>Has Device De-Coupled</b>: <span class="pull-right">No</span></p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="ownerShipChange" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <?=
            Form::open(array(
                'csrf' => $data['csrf_token'],
                'class' => 'ownerShipForm',
                'autocomplete' => 'off',
                'ng-submit' => 'changeDeviceOwner()',
                ));
            ?>
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title">Assign additional owners to manage the selected device</h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="deviceNamee">Device Name : </label>
                        <span name="deviceNamee" id="deviceNamee"></span>
                    </div>
                    <div class="form-group hide">
                        <label for="deviceName"></label>
                        <input name="deviceName" id="ownerShipMiniCloud" type="text"/>
                    </div>
                    <div class="form-group">
                        <label for="owner"></label>
                        <select class="form-control ownerShipChange" style="width: 100%;" name="owner[]" id="selectOwnerShip" multiple="multiple"></select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary changeOwnerSaveBtn">Save changes</button>
                </div>
            </div>
            <?=
            Form::close();
            ?>
        </div>
    </div>
    <div class="modal fade deviceLogs">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
<!--                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                    <h4 class="modal-title">Device Actions</h4>
                </div>
                <div class="modal-body">
					<?=
                    Form::open(array(
                        'csrf' => $data['csrf_token'],
                        'class' => 'eventHubForm',
                        'autocomplete' => 'off',
                        'ng-submit' => 'saveEventHub()',
                        'data-parsley-validate' => true
                    ));
                    ?>
					
					<span class="hide" id="actionToUserName"></span>
					<span class="hide" id="actionToDeviceUUID"></span>
					<span class="hide" id="deviceType"></span>
					<div class="col-lg-12 hide" style="margin-bottom: 10px;">
						<div class="col-lg-6">
							<p><b>Backup Policy Refresh</b>:</p>
						</div>
						<div class="col-lg-6">
							<input id="backupPolicyRefresh" name="backupPolicyRefresh" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
						</div>
					</div></br>
					<?php if(Auth::checkCloudPermission('backup')  || Auth::checkCloudPermission('office365')) {?>
					<div class="col-lg-12" style="margin-bottom: 10px;">
 						<div class="col-lg-6">
 							<p><b>Current Backup Status</b>:</p>
 						</div>
 						<div class="col-lg-6">
                            			<center>
					       		<label ng-if="currentBackup == true">Running</label>
		                    	   		<label ng-if="currentBackup == false">Not Running</label>
                            			</center>
 						</div>
 					</div>
 					<?php } ?>
<?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
                                        <div class="col-lg-12" style="margin-bottom: 10px;">
                                                <div class="col-lg-6">
                                                        <p><b>Current Restore Status</b>:</p>
                                                </div>
                                                <div class="col-lg-6">
                                                <center>
                                                        <label ng-if="currentRestore == true">Running</label>
                                                        <label ng-if="currentRestore == false">Not Running</label>
                                                </center>
                                                </div>
                                        </div>
                                        <?php } ?>
					<div class="col-lg-12 agLogs" style="margin-bottom: 10px;">
                        <div class="col-lg-6">
                            <p><b>Pull Agent Logs</b>:</p>
                        </div>
                        <div class="col-lg-6">
                            <center>
                                <input id="agentLogs" name="agentLogs" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                                <div class="checkbox check-primary" id="historicalLogsBlock" style="display: none;margin-top: 8px;">
                                    <input id="historicalLogs" name="historicalLogs" type="checkbox" value="enabled">
                                    <label for="historicalLogs"><?=Language::show('Include Historical Logs', 'keywords');?></label>
                                    <input id="setupLogs" name="setupLogs" type="checkbox" value="enabled">
                                    <label for="setupLogs"><?=Language::show('Include Setup Logs', 'keywords');?></label>
                                    <input id="databases" name="databases" type="checkbox" value="enabled">
                                    <label for="databases"><?=Language::show('Include Databases', 'keywords');?></label>
                                </div>
                            </center>
                        </div>
                    </div>
                    <div class="col-lg-12 fBackup" style="margin-bottom: 10px;display:none;">
                        <div class="col-lg-6">
                            <p><b>Full Backup</b>:</p>
                        </div>
                        <div class="col-lg-6">
                            <center>
                                <input id="fullBackup" name="fullBackup" type="checkbox" value="Yes" data-style="ios" data-toggle="toggle" data-on="Enabled" data-off="Disabled">
                            </center>
                        </div>
                    </div>
<?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
		     <div class="col-lg-12" style="margin-bottom: 10px;">
                         		<div class="col-lg-6">
                             		<p><b>Agent Backup</b>:</p>
                         		</div>
                         		<div class="col-lg-6">
                                    <center>
                             			<a ng-if="buttonValue=='startBackup'" class="btn btn-small btn-success startBackup" ng-class="{'false': 'disabled'}[isAllowBackup]" id="startBackup" name="startBackup" val="No" ng-click="startBackupButton()">Start Backup</a>
                             			<a ng-if="buttonValue=='stopBackup'" class="btn btn-small btn-danger stopBackup" id="stopBackup" name="stopBackup" val="false" ng-bootbox-confirm="<h4>Stop Backup </h4><br><?=Language::show('Are you sure?', 'keywords')?>" ng-bootbox-confirm-action="stopBackupButton()" ng-bootbox-confirm-action-cancel="" href="javascript:;"><?=Language::show('Stop Backup', 'keywords');?></a>
                                        <a ng-if="buttonPauseValue=='pauseBackup'" class="btn btn-small btn-danger pauseBackup" id="pauseBackup" name="pauseBackup" val="false" ng-click="pauseBackupButton()">Pause Backup</a>
                             			<a ng-if="buttonValue=='cancelBackup'" class="btn btn-small btn-warning cancelBackup" id="cancelBackup" name="cancelBackup" val="No" ng-click="cancelBackupButton()">Cancel Schedule</a>
                                    </center>
                                </div>
                    </div>
                    <?php } ?>
<?php if(Auth::checkCloudPermission('backup') || Auth::checkCloudPermission('office365')) {?>
                     <div class="col-lg-12 hide" style="margin-bottom: 10px;">
                                        <div class="col-lg-6">
                                        <p><b>Restore</b>:</p>
                                        </div>
                                        <div class="col-lg-6">
                                    <center>
                                                <a ng-if="buttonValueRestore=='startRestore'" class="btn btn-small btn-success startRestore" id="startRestore" name="startRestore" val="No" ng-click="startRestoreButton()">Start Restore</a>
                                                <a ng-if="buttonValueRestore=='stopRestore'" class="btn btn-small btn-danger stopRestore" id="stopRestore" name="stopRestore" val="false" ng-bootbox-confirm="<h4>Stop Restore </h4><br><?=Language::show('Are you sure?', 'keywords')?>" ng-bootbox-confirm-action="stopRestoreButton()" ng-bootbox-confirm-action-cancel="" href="javascript:;"><?=Language::show('Stop Restore', 'keywords');?></a>
<!--                                        <a ng-if="buttonPauseValueRestore=='pauseRestore'" class="btn btn-small btn-danger pauseRestore" id="pauseRestore" name="pauseRestore" val="false" ng-click="pauseRestoreButton()">Pause Restore</a>-->
                                                <a ng-if="buttonValueRestore=='cancelRestore'" class="btn btn-small btn-warning cancelRestore" id="cancelRestore" name="cancelRestore" val="No" ng-click="cancelRestoreButton()">Cancel Restore</a>
                                    </center>
                                </div>
                    </div>
                    <?php } ?>
                    <div class="col-lg-12 stopBackupWhileRestoreBlock hide">
                        <div class="col-lg-6">
                             <label for="stopBackupWhileRestoree" style="font-weight:600!important;"><?=Language::show('Disable Backup:', 'keywords');?></label>
                        </div>
                        <div class="form-group col-lg-6">
                            <center>
                                <label class="switch">
                                    <input id="stopBackupWhileRestore" name="stopBackupWhileRestore" type="checkbox">
                                    <div class="slider round"></div>
                                </label>
                            </center>
                        </div>
                    </div>
                    <p>Note: Some of the changes may take effect only during next policy refresh.</p>
                    <?= Form::close(); ?>
                </div>
                <div class="modal-footer">
					<!--<button type="submit" class="btn btn-primary">Save changes</button>-->
					<a class="btn btn-success disabled" id="saveBtn" data-dismiss="modal" ng-click="saveEventHub()">Save</a>
                    <button type="button" id="modalClose" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/DeviceController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('#agentLogs').on('change', function(){
        $('#saveBtn').removeClass('disabled');
            if($(this).prop('checked')){
                $('#historicalLogsBlock').show();
            }else{
                $('#historicalLogsBlock').hide();
                //$('#historicalLogs').prop('checked',false);
            }
    });
    $("#stopBackupWhileRestore").click(function(){
        $('#saveBtn').removeClass('disabled');
    });
</script>
<style>
.not-allowed {
    pointer-events: none !important; 
    opacity : 0.5 !important;
}
</style>
<script>
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"backup/getAllUnblockedDevicesForDeviceList",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        return { id: o.deviceName, text: o.deviceName };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select Devices'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
    
    //new start
    var owner = $(".ownerShipChange").select2({
    //        maximumSelectionLength: 1,
        ajax: {
	    url: "<?=DIR?>"+"user/searchUserWithDeviceOwner",	
            //url: "<?=DIR?>"+"user/getAllUnBlockedUsersWithLoggedInUser",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                console.log(data);
                params.page = params.page || 1;
                if(data.users.length > 0){
                    $('.changeOwnerSaveBtn').removeAttr('disabled', 'disabled');
                }
                return {
                    results: $.map(data.users, function (o) {
                        return { id: o.userName, text: o.userName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
	minimumInputLength: 3,
        placeholder: 'Select a Owner'
    });

    function addCurrentOwner(deviceId, deviceName, deviceUUID) {
	var abc = deviceUUID;
        //console.log("called addcurrentowner : "+deviceUUID);
        //console.log("called addcurrentowner : "+devicName);
        owner.val(null).trigger("change");
        var miniClouds = $('#ownerFor'+deviceId).html().split(',');
//var miniClouds = [];
        miniClouds.forEach(function(value, key){
            if(value.length > 0){
                //console.log("inside :"+value);
                $('#selectOwnerShip').append($('<option>', {
                    value: value,
                    text: value
                }));
            }
        });

        $('[name="deviceName"]').val(abc);
        document.getElementById("deviceNamee").innerHTML = deviceName;
        $('#ownerShipChange').modal('show');
        owner.val(miniClouds).trigger("change");
    }

    $('#ownerShipChange').on('hidden.bs.modal', function () {
        window.location.reload(true);
    });
    
//new end

$("#agentLogs").click(function(){
$('#saveBtn').removeClass('disabled');
});

$("#historicalLogs").click(function(){
$('#saveBtn').removeClass('disabled');
});

$("#setupLogs").click(function(){
$('#saveBtn').removeClass('disabled');
});

$("#databases").click(function(){
$('#saveBtn').removeClass('disabled');
});

document.getElementById('agentLogs').addEventListener('click', function(){
    $('#saveBtn').removeClass('disabled');
});
</script>
<style>
.switch {
  position: relative;
  display: inline-block;
  width: 45%;
  height: 34px;
}

.switch input {display:none;}

.slider {
  position: absolute;
  cursor: pointer;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: #ccc;
  -webkit-transition: .4s;
  transition: .4s;
}

.slider:before {
  position: absolute;
  content: "";
  height: 26px;
  width: 26px;
  left: 4px;
  bottom: 4px;
  background-color: white;
  -webkit-transition: .4s;
  transition: .4s;
}

input:checked + .slider {
  background-color: #2196F3;
}

input:focus + .slider {
  box-shadow: 0 0 1px #2196F3;
}

input:checked + .slider:before {
  -webkit-transform: translateX(70px);
  -ms-transform: translateX(70px);
  transform: translateX(70px);
}

/* Rounded sliders */
.slider.round {
  border-radius: 34px;
}

.slider.round:before {
  border-radius: 50%;
}
</style>
<script>
$(function () {
  $('.ios').tooltip({ trigger: 'click' });
});
</script>
