<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/
?>
<span ng-controller="SyncController" xmlns="http://www.w3.org/1999/html">
<div class="container">
    <?php if(WORKFLOW_IMAGE == true){ ?>
        <div class="row text-center" style="margin-top: 5%">
            <img src="<?=Url::templatePath()?>images/wiproFilesWorkfloChange.png" />
        </div>
    <?php } ?>
    <div class="row">
	<?php if($data['lastLoginTime'] != "nil"){ ?>
	<div class="col-lg-6" style="float:right;margin-top: 5px;">
		<span style="font-size: 12px;float:right;"><?php if($data['lastLoginTime']) { ?>Last Login Time : <?php echo $data['lastLoginTime']; } ?></span>
	</div>
	<?php } ?>
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <?php if(BLUDRIVE_MODE == true){?>
                    <li><h3><?=Language::show('My BluDrive', 'keywords')?></h3></li>
                <?php } else { ?>
                    <li><h3><?=$data['title']?></h3></li>
                <?php } ?>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>

        <div class="col-lg-6">
            <?php View::renderTemplate('partials/createButton', $data)?>
	    <?php View::renderTemplate('partials/createButton1', $data)?>
        </div>
    </div>
</div>
<div class="main">
    <span class="hide shareType"><?php if(SHARE_WITHIN_ORG == true){echo 'shareWith';}else{echo 'share';}?></span>
    <span class="hide currentPage"><?='files'?></span>
    <span class="hide csrf_token"><?=$data['csrf_token']?></span>
    <span class="hide isAdmin"><?=$data['isAdmin']?></span>
    <span class="hide extensionsToPdfView"><?=$data['extensionsToPdfView']?></span>
    <span class="hide isAdminDeleteBackupFile"><?=$data['isAdminDeleteBackupFile']?></span>
    <span class="hide openFileRevision"><?php if(!empty($_SESSION['openFileRevision'])){echo htmlspecialchars($_SESSION['openFileRevision']);}else{echo 'none';}$_SESSION['openFileRevision'] = null;?></span>
    <span class="hide shareDefault7Days"><?php if(SHARE_DEFAULT_7_DAYS == true){echo 'true';}else{echo 'false';}?></span>
    <span class="hide operation"></span>
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 status" style="display: none">
            <div class="statusMessage text-center"></div>
        </div>
        <div id="drop-target" class="col-lg-11 col-md-11 col-sm-11 filePanel">
            <div class="panel panel-default no-box-shadow panel-actions">
                <div class="panel-body">
                    <ul class="nav navbar-nav nav-breadcrumb" id="breadCrumb">
                        <li style="float:left !important;" ng-repeat="value in crumb track by $index" ng-cloak><a href="javascript:;" ng-click="updateFileListFromBreadCrumb(value, $index)" class="toolTip" data-toggle="tooltip" data-placement="top" data-original-title="{{ stripAddr(value) }}" ng-cloak>{{ stripAddr(value) }}</a></li>
                    </ul>
		    <span class="hide" id="cru"></span>
                    <span class="hide" id="filesListing"></span>
                    <ul class="nav navbar-nav pull-right nav-actions">
                        <li ng-if="showView == true" style="float:left !important;" ><a class="viewAction toolTip" ng-click="view()" data-toggle="tooltip" data-placement="top" title="View" style="color:black !important;" href="javascript:;"><i class="fa fa-eye"></i></a></li>
                        <li ng-if="showVersions == true" style="float:left !important;" ><a class="versionsAction toolTip" ng-click="versions()" data-toggle="tooltip" data-placement="top" title="Versions" style="display:none;color:black !important;" href="javascript:;"><i class="fa fa-clock-o"></i></a></li>
			<li ng-if="showdownload == true" style="float:left !important;" ><a class="downloadAction toolTip" ng-click="download('')" data-toggle="tooltip" data-placement="top" title="Download" style="color:black !important;" href="javascript:;"><i class="fa fa-download"></i></a></li>			    
                        <?php if($data['policy']['menuOptions']['share'] == "1"){ ?>
                            <?php if(SHARE_WITHIN_ORG == false){?>
                                <li ng-if="showShare == true" style="float:left !important;" ><a class="shareAction toolTip" ng-click="share()" data-toggle="tooltip" data-placement="top" title="Share" style="color:black !important;" href="javascript:;"><i class="fa fa-share"></i></a></li>
                            <?php }else{ ?>
                                <li ng-if="showShare == true" style="float:left !important;" ><a class="shareAction toolTip" ng-click="shareWith()" data-toggle="tooltip" data-placement="top" title="Share" style="color:black !important;" href="javascript:;"><i class="fa fa-share"></i></a></li>
                            <?php } ?>
                        <?php } ?>                        
                        <li ng-if="showDelete == true" style="float:left !important;" ><a class="deleteAction toolTip" ng-click="delete()" data-toggle="tooltip" data-placement="top" title="Delete" style="color:black !important;" href="javascript:;"><i class="fa fa-trash"></i></a></li>
                        <li ng-if="showrename == true" style="float:left !important;" ><a class="renameAction toolTip" ng-click="rename()" data-toggle="tooltip" data-placement="top" title="Rename" style="display:none;color:black !important;" href="javascript:;"><i class="fa fa-edit"></i></a></li>
                        <li ng-if="showcutcopypaste == true" style="float:left !important;" ><a class="cutAction toolTip" ng-click="cut()" data-toggle="tooltip" data-placement="top" title="Cut" style="color:black !important;" href="javascript:;"><i class="fa fa-cut"></i></a></li>
                        <li ng-if="showcutcopypaste == true" style="float:left !important;" ><a class="copyAction toolTip" ng-click="copy()" data-toggle="tooltip" data-placement="top" title="Copy" style="color:black !important;" href="javascript:;"><i class="fa fa-copy"></i></a></li>
                        <li style="float:left !important;" ng-if="showcutcopypaste == true && selectedFilesForCopyCut.length > 0 && currentCrumb != selectedFilesForCopyCutFromPath"><a class="pasteAction toolTip" ng-click="paste()" data-toggle="tooltip" data-placement="top" title="Paste" href="javascript:;" style="color:black !important;"><i class="fa fa-clipboard"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="panel panel-default files-panel no-box-shadow" ng-if="items.length > 0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover files-table">
                        <thead>
                        <tr>
                            <th class="clickAble" ng-click="sortType = 'fileName'; sortReverse = !sortReverse">
                                Name
                                <span ng-show="sortType == 'fileName' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'fileName' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'type'; sortReverse = !sortReverse">
                                Type
                                <span ng-show="sortType == 'type' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'type' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'modifiedTimeInMillis'; sortReverse = !sortReverse">
                                Last modified
                                <span ng-show="sortType == 'modifiedTimeInMillis' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'modifiedTimeInMillis' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th class="clickAble" ng-click="sortType = 'rawSize'; sortReverse = !sortReverse">
                                Size
                                <span ng-show="sortType == 'rawSize' && !sortReverse" class="fa fa-caret-up"></span>
                                <span ng-show="sortType == 'rawSize' && sortReverse" class="fa fa-caret-down"></span>
                            </th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody id="selectable"
                               selectable="tr"
                               selectable-list="items"
                               selectable-out="selected"
                               selectable-options="{filter:'.selectable', cancel: 'a.folder,.cancel'}"
                               selectable-events="{start:'selectionStart($selected)', stop:'selectionStop($selected)'}"
                               block-ui="myBlockUI"
                               context-menu="menuOptions">
                        <tr ng-repeat="value in items | orderBy:sortType:sortReverse" ng-class="{'selectable': value.selectable == 'yes'}">
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'Mini Cloud'" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" ng-click="updateFileList(crumbString+value.fileName, value.fileName, true)" style="cursor: pointer;color: #000 !important;"><span ng-bind-html="stripUsername(value.fileName) | charLimit"></span></a></td>
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'Folder'" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <a class="folder" ng-click="updateFileList(crumbString+value.fileName, value.fileName, true)" style="cursor: pointer;color: #000 !important;"><span ng-bind-html="value.fileName | charLimit"></span></a></td>
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'File'" ng-cloak><i class="fa fa-{{ value.icon }} fa-1x"></i> <a style="cursor: pointer;color: #000 !important;"><span ng-bind-html="value.fileName | charLimit"></span> <span class="text-warning" ng-if="value.storagePlace.length <= 0"><i class="fa fa-arrow-up faa-float animated"></i></span></a></td>
                            <td ng-cloak> {{ value.type }} </td>
                            <td ng-if="value.type == 'File'" ng-cloak> {{ value.modifiedTime}} </td>
 			    <td ng-if="value.type == 'Folder' || value.type == 'Mini Cloud'" ng-cloak> - </td>
                            <td ng-if="value.type == 'Mini Cloud'" ng-cloak> - </td>
                            <td ng-if="value.type == 'Folder'" ng-cloak> - </td>
                            <td ng-if="value.type == 'File'" ng-cloak>
                                {{ value.size }}
                                <!--                                    <span ng-if="value.storagePlace.length <= 0" class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span>-->
                            </td>
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'Mini Cloud'" ng-cloak>-</td>
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'Folder'" ng-cloak>-</td>
                            <td data-name="{{value.fileName}}" ng-if="value.type == 'File'" ng-cloak>
                                <a ng-if="showView == true" class="folder toolTip" data-toggle="tooltip" data-placement="top" title="View"  style="cursor: pointer;color: #000 !important;" ng-click="selectFileForView(value.fileName)"><i class="fa fa-eye"></i></a>
                                &nbsp;&nbsp;
                                <a ng-if="showdownload == true" class="folder toolTip" data-toggle="tooltip" data-placement="top" title="Download"  style="cursor: pointer;color: #000 !important;" ng-click="selectFileForDownload(value.fileName)"><i class="fa fa-download"></i></a>
                                &nbsp;&nbsp;
                                <?php if($data['policy']['menuOptions']['share'] == "1"){ ?>
                                    <?php if(SHARE_WITHIN_ORG == false){?>
                                        <a ng-if="showShare == true" class="folder toolTip" data-toggle="tooltip" data-placement="top" title="Share"  style="cursor: pointer;color: #000 !important;" ng-click="selectFileForShare(value.fileName, 'share')"><i class="fa fa-share"></i></a>
                                    <?php }else{ ?>
                                        <a ng-if="showShare == true" class="folder toolTip" data-toggle="tooltip" data-placement="top" title="Share With"  style="cursor: pointer;color: #000 !important;" ng-click="selectFileForShare(value.fileName, 'shareWith')"><i class="fa fa-share"></i></a>
                                    <?php } ?>
                                <?php } ?>
                                &nbsp;&nbsp;
                                <a ng-if="showDelete == true" class="folder toolTip" data-toggle="tooltip" data-placement="top" title="Delete"  style="cursor: pointer;color: #000 !important;" ng-click="selectFileForDelete(value.fileName)"><i class="fa fa-trash"></i></a>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
                <?php if(DISABLE_SHOW_PG_ICON){ ?>
                <div class="panel-footer" ng-if="items.length > 0">
                    <p style="margin: 0 0 0px;">Note:- <span class="text-warning"><i class="fa fa-arrow-up faa-float animated"></i></span> means that the particular file is still on the Parablu Server.</p>
                </div>
                <?php } ?>
                <div class="panel-footer">
                    <center><p style="margin: 0 0 0px;font-weight: 700;"> Drag files/folders here to upload</p></center>
                </div>
            </div>
            <div class="text-center status" style="display: none;">
                <h3>There are no files or folders</h3>
		<center>
			<p style="margin: 0 0 0px;font-weight: 700;"> Drag files/folders here to upload</p>
		</center>
            </div>
            <?php if(isMobile()){ ?>
                <div class="text-center">
                    <span class="help-line text-muted">Note:- Upload feature is available from your workstation.</span>
                </div>
            <?php } ?>
            <div class="modal fade deleteConfirmation">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">Delete Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <p>
                                <span ng-if="selected.length == 1">Do you want to permanently delete the below selected file or a folder?</span>
                                <span ng-if="selected.length > 1">Do you want to permanently delete the below selected files and folders?</span>
                            </p>
                            <p>
                                <span ng-repeat="value in selected track by $index">
                                    <span ng-if="$index == (selected.length - 1)">{{ value.name }}</span>
                                    <span ng-if="$index < (selected.length - 1)">{{ value.name+', ' }}</span>
                                </span>
                            </p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" ng-click="deleteFile()" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal" id="paraviewContainer" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" style="background-color:white;">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h5 class="modal-title">Loading ...</h5>
                        </div>
                        <br/><br/>
                        <div class="modal-body">
                            <div class="pageContainer" style="background-color: white;display: none;"></div>
                            <div class="pdfContainer" style="display: none;"></div>
                            <div class="excelContainer" style="background-color: white;display: none;"></div>
                            <div class="content" style="text-align: -webkit-auto;display: none;"></div>
                            <div class="imageViewer" style="display: none;"></div>
			    <div class="pptxViewer" style="background-color: white;display: none;"></div>
                            <div class="paraviewLoading" style="margin-top: 15%">
                                <img width="5%" src="<?=Url::templatePath('default/images/gears.gif');?>" />
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade <?php if(!isMobile()){ ?>whiteAndBigModal<?php } ?> syncFileVersions">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header" style="margin-bottom: -10px;">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">File Versions list - File Name: <span>{{ selectedFiles[0].fileName }}</span></h4>
                        </div>
                        <div class="modal-body">
                            <div class="table-responsive" style="margin-top: -20px;">
                                <hr/>
                                <div class="h4 loading text-center">Loading.....</div>
                                <table class="table table-striped fileVersionsTable" style="display: none;">
                                    <tbody>
                                    <tr ng-repeat="value in fileVersions track by $index">
                                        <td ng-if="$index != 0" ng-cloak>{{ value.version + (fileVersions.length-$index)}}</td>
                                        <td ng-if="$index == 0" ng-cloak>{{ value.version + (fileVersions.length-$index)}} (Current Version)</td>
                                        <td class="text-success" ng-if="value.status == 'ADDED'" ng-cloak>{{ value.status }}</td>
                                        <td class="text-info" ng-if="value.status == 'MODIFIED'" ng-cloak>{{ value.status}}</td>
                                        <td class="text-info" ng-if="value.status == 'RESTORED'" ng-cloak>{{ value.status}}</td>
                                        <td class="text-danger" ng-if="value.status == 'DELETED'" ng-cloak>{{ value.status}}</td>
                                        <td ng-cloak>by {{ value.fileUser }}</td>
                                        <td ng-if="value.fileDevice.length > 0" ng-cloak>from {{ value.fileDevice }}</td>
                                        <td ng-if="value.fileDevice.length <= 0" ng-cloak>from Portal</td>
                                        <td ng-cloak>on {{ value.checksum }}</td>
                                        <td ng-cloak>{{ value.size }}</td>
                                        <td>
					    <a ng-if="showView == true" class="btn btn-success btn-small" ng-click="viewVersions(value.revisionId)"><i class="fa fa-eye"></i></a>
                                            <a class="btn btn-small btn-primary" ng-click="revisionCommentBox($index)"><i class="fa fa-comment"></i></a>
                                            <a ng-if="showdownload == true" ng-hide="value.status == 'DELETED'" class="btn btn-small btn-info" ng-click="download($index, true)"><i class="fa fa-download"></i></a>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="modal-footer" style="z-index: 10000000000;">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="commentsModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="saveComment(fileRevisionComments)">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="myModalLabel">Save File version comments</h4>
                            </div>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label for="fileRevisionComments">Comments</label>
                                    <textarea class="form-control" id="fileRevisionComments" required></textarea>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveComments btn btn-success">Save Comments</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="modal fade" id="rename" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="saveRename(changedName)">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="myModalLabel">Rename the selected file or folder</h4>
                            </div>
                            <div class="modal-body">
                                <div class="form-group">
                                    <label for="changedName">Name</label>
                                    <input type="text" class="form-control" id="changedName" required />
                                </div>
                                <span class="renameError"></span>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
	    <div class="modal fade" id="extensionsToPdfView" data-backdrop="static" data-keyboard="false" style="z-index: 1000000000;">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h4 class="modal-title">Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <p>Your file will need to converted to PDF before it is shared.  Please select an option below to proceed.</p>
                        </div>
                        <div class="modal-footer">
                            <button type="button" ng-click="proceed()" class="btn btn-primary pull-right" style="margin-left: 5px;">Share</button>
                            <button type="button" ng-click="preview()" class="btn btn-primary pull-right">Preview</button>
                            <button type="button" class="btn btn-default pull-right" ng-click="cancell()">Cancel</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="shareWith" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <form id="fileShareWithForm" data-parsley-validate ng-submit="saveShareWith('simple')">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="myModalLabel">Share Details</h4>
                            </div>
                            <div class="modal-body shareLoading">
                                <span>Loading ...</span>
                            </div>
                            <div style="display: none;" class="modal-body shareWithBodyStatus">File has already been shared</div>
                            <div class="modal-body shareBody shareWithBody">
                                <div class="form-group">
                                    <div class="">
                                        <div class="mt-md mb-md">
                                            <div class="form-group <?php if(SHARE_DEFAULT_7_DAYS == true){echo 'hide';} ?>">
                                                <label for="till">Valid Till <span class="shareWithRemoveValidUntil text-danger clickable" style="display: none;">(Remove Validity)</span></label>
                                                <input type="text" class="shareWithValidTill form-control" id="till1" placeholder="Valid Till" data-parsley-trigger="change" readonly <?php if($data['policy']['expiredDate'] == "1"){ echo " required"; }?>>
                                            </div>
                                            <div class="form-group">
                                                <label for="listOfUsers">Email Address: </label>
                                                <input type="text" class="listOfUsers form-control" name="userNames" id="listOfUsers" placeholder="Enter Email address" required/>
                                            </div>
                                            <div class="form-group">
                                                <label for="shareWithSubject">Subject: </label>
                                                <input type="text" style="width:100%" class="shareWithSubject" name="shareWithSubject" id="shareWithSubject" placeholder="Enter your Subject" data-parsley-trigger="change" data-parsley-minlength="5" data-parsley-maxlength="256" />
                                            </div>
                                            <div class="form-group">
                                                <label for="message">Message: </label>
                                                <textarea style="width:100%" class="shareWithMessage" name="shareWithMessage" id="shareWithMessage" placeholder="Enter your message" data-parsley-trigger="change" data-parsley-minlength="20" data-parsley-maxlength="512"></textarea>
                                            </div>
                                            <div class="granular hide">
                                                <?php if($data['policy']['preventDownloadEnabled'] != "1"){ ?>
                                                    <div class="hide">
                                                        <label for="shareWithEnableDownload">Enable Download (with View): </label>
                                                        <input type="checkbox" id="shareWithEnableDownload" class="shareWithEnableDownload" />
                                                    </div>
                                                <?php } else{ ?>
                                                    <label for="shareWithEnableDownload">Enable Download (with View): </label>
                                                    <input type="checkbox" id="shareWithEnableDownload" class="shareWithEnableDownload" checked />
                                                <?php } ?>
                                                <div class="hide">
                                                    <label for="shareWithEnableView">Allow View: </label>
                                                    <input type="checkbox" id="shareWithEnableView" class="shareWithEnableView" checked />
                                                </div>
                                                <span>Note:- Files will be shared with a default validity of 7 days.</span>
                                            </div>
					    <span class="changeImpactTextSharewith" style="font-size: 12px;color: #f55753;isplay: none;">Note :- “Please note that any changes made above will impact the experience for all recipients who access this link going forward – including recipients who’ve already received this link.”</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">                                
                                <button type="submit" class="shareBtn btn btn-success">Share</button>
                                <a ng-click="updateSharePolicy()" style="display: none;" class="updateShareWithDetails btn btn-danger">OK</a>
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <a ng-click="unShare()" style="float:left;display: none;" class="unShareBtn btn btn-danger">Un-Share</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="share" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <form id="fileShareForm" data-parsley-validate ng-submit="saveShare()">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="myModalLabel">Share Details</h4>
                            </div>
                            <div class="modal-body shareLoading">
                                <span>Loading ...</span>
                            </div>
                            <div class="modal-body shareBody">
                                <div class="form-group">
                                    <div class="">
                                        <div class="mt-md mb-md">
                                            <h4>Password Protected:
                                                <span><input type="checkbox" class="sharePasswordSwitch" <?php if($data['policy']['complexPasswordRequired'] == "1"){echo "checked='checked'"; echo "disabled ='true'";}?>/></span>
                                            </h4>
                                            <span class="sharePasswordBlock" <?php if($data['policy']['complexPasswordRequired'] == "1"){ ?>style="display: block;" <?php }else { ?> style="display:none;"<?php } ?>>
                                                <div class="form-group">
                                                    <label for="password">Password</label>
                                                    <input type="password" class="form-control" id="sharePassword" placeholder="Enter a Password" data-parsley-minlength="6" <?php if($data['policy']['complexPasswordRequired'] == "1"){ ?>data-parsley-pattern="(?=.*\d)(?=.*[a-z])(?=.*[A-Z])(?!.*[!#\$%&\?])^\D" data-parsley-pattern-message="Password Should Contain one number, one uppercase, one lowercase and cannot start with a number (Special Characters Allowed '@' '.')"<?php } ?> data-parsley-trigger="change" <?php if($data['policy']['complexPasswordRequired'] == "1"){echo " required"; }?>>
                                                </div>
                                                <div class="form-group">
                                                    <label for="rePassword">Re Type Password</label>
                                                    <input type="password" class="form-control" id="reSharePassword" placeholder="Re-Type the password" data-parsley-minlength="6" data-parsley-equalto="#sharePassword" data-parsley-trigger="change" <?php if($data['policy']['complexPasswordRequired'] == "1"){echo " required"; }?>>
                                                </div>
                                            </span>
                                            <div class="form-group">
                                                <label for="till">Valid Till <span class="removeValidUntil text-danger clickable" style="display: none;">(Remove Validity)</span></label>
                                                <input type="text" class="form-control till" id="till" placeholder="Valid Till" data-parsley-trigger="change" readonly <?php if($data['policy']['expiredDate'] == "1"){ echo " required"; }?>>
                                            </div>
                                            <div class="granular">
                                                <?php if($data['policy']['preventDownloadEnabled'] != "1"){ ?>
                                                    <div class="hide">
                                                        <label for="enableDownload">Enable Download (with View): </label>
                                                        <input type="checkbox" id="enableDownload" class="enableDownload" />
                                                    </div>
                                                <?php } else { ?>
                                                    <label for="enableDownload">Enable Download (with View): </label>
                                                    <input type="checkbox" id="enableDownload" class="enableDownload" checked />
                                                <?php } ?>
                                                <div class="hide">
                                                    <label for="enableView">Allow View: </label>
                                                    <input type="checkbox" id="enableView" class="enableView" checked />
                                                </div>
                                            </div>
                                            <div class="shareLinkBlock" style="display: none;">
                                                <h4>
                                                    Share the below link to share the file:
                                                    
                                                    <a ng-click="sendEmailShareLink()" title="Email" class="clickAble pull-right sendEmailShareLink"><i class="fa fa-envelope"></i></a>
                                                </h4>
                                                <textarea class="js-copytextarea shareLink" style="width:100%;word-wrap: break-word;" rows="5" readonly></textarea>
                                                <h4><a class="js-textareacopybtn clickAble pull-right" title="Copy Share Link" style="margin-left: 5px;" ng-click="copyToClipboard()"><i class="fa fa-clipboard" aria-hidden="true"></i></a></h4>
                                                <!--<h5 id="copyTarget" class="shareLink" style="word-wrap: break-word;"></h5>-->
                                                <br>
                                            </div>
                                            <div class="form-group sendEmailShareForm hide">
                                                <label for="emails">Emails</label>
                                                <textarea name="emails" ng-model="emails" class="form-control" id="emails"> </textarea>
                                                <a ng-click="sendShareEmail(emails)" class="btn btn-small btn-default shareEmailLinkSendBtn"> Send</a>
                                            </div>
					    <span class="changeImpactText" style="font-size: 12px;color: #f55753;isplay: none;">Note :- “Please note that any changes made above will impact the experience for all recipients who access this link going forward – including recipients who’ve already received this link.”</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">                                
                                <button type="submit" class="shareBtn btn btn-success">Share</button>
                                <a ng-click="updateSharePolicy()" style="display: none;" class="updateShareDetails btn btn-danger">OK</a>
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <a ng-click="unShare()" style="float:left;display: none;" class="unShareBtn btn btn-danger">Un-Share</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="deleteConfirm" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" id="myModalLabel">Delete Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <p class="deleteConfirmMessage"></p>
                            <br/><br/>
                            <a type="button" class="pull-right btn btn-default" style="margin-top: -30px" data-dismiss="modal">Cancel</a>
                            <a type="button" ng-click="deletedConfirmed()" style="margin-top: -30px; margin-right: 5px;" class="pull-right btn btn-danger">Delete</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<div id="UploadAl" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">File Uploaded Already</h4>
            </div>
            <div class="modal-body">
                <div>
                    <div align="center">
                        Click ok to Upload New Files...!
                    </div>
                    <span class="pull-right">
                        <button type="button" id="UploadAlready" class="btn btn-default">Ok</button>
                    </span>
                    <br/><br/>
                </div>
            </div>
        </div>
    </div>
</div>
<div id="networkFailure" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Network Failure.... !</h4>
            </div>
            <div class="modal-body">
                <div>
                    <div align="center">
                        Files are not uploaded successfully....!!
                    </div>
                    <span class="pull-right">
                        <button type="button" id="netFail" class="btn btn-default">Ok</button>
                    </span>
                    <br/><br/>
                </div>
            </div>
        </div>
    </div>
</div>
   <pre id="log" style="height: 300px; overflow: auto;display:none;"></pre>
   <div id="overlayText"><center><h2 style="color:white;margin-top:20%;">Your files are being prepared for download. This operation could take some time. Please be patient during this time and don’t close this tab. If you wish to perform other operations – you can duplicate this tab and continue to perform other actions.</h2></center></div>
   <div id="overlayTextPaste"><center><h2 style="color:white;margin-top:20%;">This operation could take some time. Please be patient during this time and don’t close this tab. If you wish to perform other operations – you can duplicate this tab and continue to perform other actions.</h2></center></div>	
<?php View::renderTemplate('partials/search', $data); ?>

</div><!-- /.container -->
</span>
<?php View::renderTemplate('partials/scripts')?>
<script>
    <?php if(SHARE_WITHIN_ORG == false){?>
    $('.till').datepicker({
	format: 'dd-M-yyyy',	    
        //format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-0d',
        endDate: '+1y',
        todayHighlight: true
    }).on('changeDate', function(){
        if($('.till').val() != ''){
            $('.removeValidUntil').show();
        }
    });

    $('.removeValidUntil').on('click', function(){
        $('.till').val('');
        $('.removeValidUntil').hide();
    });
    <?php }else{ ?>
    $('.shareWithValidTill').datepicker({
        //format: 'mm/dd/yyyy',
	format: 'dd-M-yyyy',
        autoclose: true,
        startDate: '-0d',
        endDate: '+1y',
        todayHighlight: true
    }).on('changeDate', function(){
        if($('.shareWithValidTill').val() != ''){
            $('.shareWithRemoveValidUntil').show();
        }
    });

    $('.shareWithRemoveValidUntil').on('click', function(){
        $('.shareWithValidTill').val('');
        $('.shareWithRemoveValidUntil').hide();
    });
    <?php } ?>
    jQuery(document).bind("keyup keydown", function(e){
        if(e.ctrlKey && e.keyCode == 80){
            return false;
        }
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/SyncController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    //    var assignUsers = $(".assignUsers").select2({
    //        ajax: {
    //            url: "<?//=DIR?>//"+"userGroups/getAllUnBlockedUsersWithGroups",
    //            dataType: 'json',
    //            delay: 250,
    //            data: function (params) {
    //                return {
    //                    q: params.term,
    //                    page: params.page
    //                };
    //            },
    //            processResults: function (data, params) {
    //                params.page = params.page || 1;
    //                if(data.users.length > 0){
    //                    $('.assignSaveBtn').removeAttr('disabled');
    //                }
    //                return {
    //                    results: $.map(data.users, function (o) {
    //                        return { id: o.userName, text: o.emailId, img: o.profilePic };
    //                    }),
    //                    pagination: {
    //                        more: (params.page * 30) < data.total_count
    //                    }
    //                };
    //            },
    //            cache: true
    //        },
    //        escapeMarkup: function (markup) { return markup; },
    //        templateResult: selectTemplateResult,
    //        templateSelection: selectTemplateSelection,
    //        placeholder: 'Select users'
    //    });
    //
    //    function selectTemplateResult(users){
    //        if(users.text != undefined){
    //            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
    //            if(users.img){
    //                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
    //            }
    //            template += users.text + "</div></div>";
    //            return template;
    //        }else{
    //            return "<div class='select2-user-result'>Fetching...</div>";
    //        }
    //    }
    //
    //    function selectTemplateSelection(users){
    //        return users.text;
    //    }
    //
    //    $('#assignUsers').on('hidden.bs.modal', function () {
    //        window.location.reload(true);
    //    })
</script>
<script>
    var copyTextareaBtn = document.querySelector('.js-textareacopybtn');

copyTextareaBtn.addEventListener('click', function(event) {
  var copyTextarea = document.querySelector('.js-copytextarea');
  copyTextarea.select();

  try {
    var successful = document.execCommand('copy');
    var msg = successful ? 'successful' : 'unsuccessful';
    //console.log('Copying text command was ' + msg);
  } catch (err) {
    //console.log('Oops, unable to copy');
  }
});
</script>
<script>
  var cloudName = $('.cloudNameConstant').html(); 
  var uploadUserName = $('.uploadUserName').html();
var i = 0;
var rrr = $('.filesListing').html();
/*var ext = "*";
if($('.fileIncludeExtensions').html().length > 0){
ext = $('.fileIncludeExtensions').html();
}*/

//console.log("GGGG  "+rrr);
      var uploader = new plupload.Uploader({
//        runtimes : 'html5,flash,silverlight,html4',
runtimes : 'html5,flash,gears,browserplus,silverlight,html4',
        drop_element : 'drop-target',
        browse_button : 'pickfiles',
        //max_file_size : '100gb',
        autostart: true,
	prevent_duplicates: false,
	unique_names: true,
        url : "<?=DIR?>"+"up",
        chunk_size : '100mb',
        filters : [
          /*  {title : "Image files", extensions : "jpg,gif,png,jpeg"},
            {title : "Text files", extensions : "txt"},
            {title : "Video files", extensions :"mp4"},
            {title : "Zip files", extensions : "zip" },
            {title : "Excel Files", extensions: "xls,xslx,csv"},
            {title :"Custom files", extensions:"xlsx,pdf,docx,png,xls,gif,doc,tar,exe,jar,crt,ods,odt"}*/
	    //{title :"Custom files", extensions:ext}
        ],
//      retry_interval: 1,
max_retries: 10,
        multi_selection: true,
      });

        uploader.bind('Init', function(up, params) {
                if (uploader.features.dragdrop) {
                document.getElementById('debug').innerHTML = "";
                var target = $("drop-target");
                target.ondragover = function(event) {
                event.dataTransfer.dropEffect = "copy";
                };

                target.ondragenter = function() {
                this.className = "dragover";
                };
                target.ondragleave = function() {
                this.className = "";
                };
		target.ondrop = function() {
                this.className = "";
                };
                }
                });

        uploader.bind('PostInit',function() {
                        document.getElementById('filelist').innerHTML = '';
                });

/*uploader.bind('UploadFile', function(up, file) {
var allowedFileAttributes = $('.fileIncludeExtensions').html().replace(' ', '').split(',');
var name = file.name;
var extension = name.substring(name.lastIndexOf('.')+1);
if(allowedFileAttributes.indexOf(extension)>=0){
return true;
}
else {
up.splice(0);
}

});


uploader.bind('BeforeUpload', function(up, file) {
var allowedFileAttributes = $('.fileIncludeExtensions').html().replace(' ', '').split(',');
var extension = file.name.substring(file.name.lastIndexOf('.')+1);
if(allowedFileAttributes.indexOf(extension)>=0){
return true;
}
else {
return false;
}

});*/
var currentCountForFolder = 0;
	uploader.bind('FilesAdded', function(up, files) {
//	document.getElementById("overlayText").style.display = "block";
/*	document.getElementById("menu1").style.overflow = "scroll";
	document.getElementById("menu1").style.height = "400px";*/
	document.getElementById("totalCountForFolder").innerHTML = files.length;
        document.getElementById("currentCountForFolder").innerHTML = currentCountForFolder;
        $('#pickfiles').hide();
        $('#crawlingSpinner').show();
        $('#statusForFolder').hide();
if(!$('#uploadFilesNew').hasClass('in')){
	//Do something here
	/*if(files.length >=6 ){
                        $('#menu1').css('overflowY', 'scroll');
                    $('#menu1').height('400px');
                }*/
                $('#uploadFilesNew').modal('show');
                }
console.log("lengthhhhhhhhhhhhhhh : "+files.length);
/*        var ddd = $('#filesListing').html();
var fileUploadLimitSize = $('.file-limit-size').html();
var allowedFileAttributes = $('.fileIncludeExtensions').html().replace(' ', '').split(',');
var notAllowedFileAttributes = $('.fileExcludeExtensions').html().replace(' ', '').split(',');
//console.log("LIMITSIZE : "+fileUploadLimitSize);
//console.log("ALLOWED : "+allowedFileAttributes);
//console.log("NOT ALLOWED : "+notAllowedFileAttributes);
//      console.log("VVVVVVV : "+ddd);
                plupload.each(files, function(file) {
			var filename = file.name;
			console.log("filenameeeeeee : "+filename);
			var datew = file.lastModifiedDate;
			console.log("dateeeeeeeeeeeee : "+datew);
			//console.log("converted : "+datew.getTime());
                        if(filename.length > 25)
                        {
                            filename = filename.substring(0,25)+"...";      
                        }
angular.element(document.getElementById('cru')).scope().check(file);  //new
var extension = file.name.substring(file.name.lastIndexOf('.')+1);
extension = extension.toLowerCase();			
if(!document.getElementById("filelist"))
{
var g = document.createElement('div');
g.setAttribute("id","filelist");
}

if($('.fileIncludeExtensions').html().length == 0 && $('.fileExcludeExtensions').html().length == 0){
//console.log("inside == 0");
if(fileUploadLimitSize.length > 0)
		{console.log("inside uploadsize");
		if(file.size <= (fileUploadLimitSize*1000*1000))
			{//console.log("above bar");
document.getElementById('filelist').innerHTML += '<div id="filesQueue'+file.id+'" style="border: 1px solid #ddd;padding:10px;width:90%;border-radius:5px;margin:5px;"><div id="' + file.id + '"><i class="fa fa-file fa-1x ng-binding" style="float:left;"> ' + filename + '  (' + plupload.formatSize(file.size) + ') </i>&nbsp;&nbsp;<span id="uploadStatusText'+file.id+'"></span>&nbsp;&nbsp;<a type="button" id="cancel'+file.id+'" name="'+file.name+'" class="btn btn-small btn-danger" onclick="deleteThisFile(this);" style="margin: 2px;">Cancel</a><span id="per'+file.id+'" class="percentage pull-right"></span><div id="myProgress" style="border-radius: 5px;"><div class="progress-bar progress-bar-striped active" aria-valuenow="" id="myBar'+file.id+'" name="'+file.name+'/'+file.size+'" class="'+file.origSize+'"></div></div><b></b></div></div>';
}
else{
//console.log("inside else"+file.name);
uploader.removeFile(file);
}
}}

if($('.fileIncludeExtensions').html().length > 0){
if(fileUploadLimitSize.length > 0)
		{
		if(file.size <= (fileUploadLimitSize*1000*1000))
			{
if(allowedFileAttributes.indexOf(extension)>=0)
{
document.getElementById('filelist').innerHTML += '<div id="filesQueue'+file.id+'" style="border: 1px solid #ddd;padding:10px;width:90%;border-radius:5px;margin:5px;"><div id="' + file.id + '"><i class="fa fa-file fa-1x ng-binding" style="float:left;"> ' + filename + '  (' + plupload.formatSize(file.size) + ') </i>&nbsp;&nbsp;<span id="uploadStatusText'+file.id+'"></span>&nbsp;&nbsp;<a type="button" id="cancel'+file.id+'" name="'+file.name+'" class="btn btn-small btn-danger" onclick="deleteThisFile(this);" style="margin: 2px;">Cancel</a><span id="per'+file.id+'" class="percentage pull-right"></span><div id="myProgress" style="border-radius: 5px;"><div class="progress-bar progress-bar-striped active" aria-valuenow="" id="myBar'+file.id+'" name="'+file.name+'/'+file.size+'" class="'+file.origSize+'"></div></div><b></b></div></div>';
}
}
else{
//console.log("inside else"+file.name);
uploader.removeFile(file);
}
}}

if($('.fileExcludeExtensions').html().length > 0){
if(notAllowedFileAttributes.indexOf(extension)>=0)
{
//alert("Not Allowed");
//setTimeout(function(){ location.reload(); }, 1000);
}else{
if(fileUploadLimitSize.length > 0)
                {
                if(file.size <= (fileUploadLimitSize*1000*1000))
                        {

document.getElementById('filelist').innerHTML += '<div id="filesQueue'+file.id+'" style="border: 1px solid #ddd;padding:10px;width:90%;border-radius:5px;margin:5px;"><div id="' + file.id + '"><i class="fa fa-file fa-1x ng-binding" style="float:left;"> ' + filename + ' (' + plupload.formatSize(file.size) + ')</i>&nbsp;&nbsp;<span id="uploadStatusText'+file.id+'"></span>&nbsp;&nbsp;<a type="button" id="cancel'+file.id+'" name="'+file.name+'" class="btn btn-small btn-danger" onclick="deleteThisFile(this);" style="margin: 2px;">Cancel</a><span id="per'+file.id+'" class="percentage pull-right"></span><div id="myProgress" style="border-radius: 5px;"><div class="progress-bar progress-bar-striped active" aria-valuenow="" id="myBar'+file.id+'" name="'+file.name+'/'+file.size+'" class="'+file.origSize+'"></div></div><b></b></div></div>';
}
else{
//console.log("inside else"+file.name);
uploader.removeFile(file);
}

}
}}


i++;
		});*/
setTimeout(function () { uploader.start(); }, 3000);

                });

function deleteThisFile(item) {
	var id = $(item).attr("id");
	console.log("id ::::: "+id);
	var x = id.replace('cancel', '');
	var name = $(item).attr("name");
	/*var extension = name.substring(name.lastIndexOf('.')+1);
        extension = extension.toLowerCase();
        var nowtest = x+'.'+extension;*/
	if(name.lastIndexOf('.') != '-1'){
                var extension = name.substring(name.lastIndexOf('.')+1);
        }
        if(extension){
        	var nowtest = x+'.'+extension;
        }else{
        	var nowtest = x;
        }
//console.log("File Id : "+x);
//$("#filesQueue"+x).remove();
//var x = i.replace('dele', '');
//$('#filesQueue'+x).remove();
uploader.removeFile(uploader.getFile(x));
$("#filesQueue"+x).remove();	
angular.element(document.getElementById('cru')).scope().cancelFile(name);
//delete file start
console.log("inside delete for: "+name);
//start foldername
var d = new Date();         //get the date
                var month = d.getMonth();   //get the month
                var day = d.getDate().toString();   //get the day and convert to string
                var year = d.getFullYear(); //get the year
                year = year.toString().substr(-2);  //pull the last two digits of the year
month = (month + 1).toString();     //increment month by 1 since it is 0 indexed and converts month to a string
                if (month.length === 1)     //if month is 1-9 pad right with a 0 for two digits
                {
                month = "0" + month;
                }
                if (day.length === 1)       //if day is between 1-9 pad right with a 0 for two digits
                {
                day = "0" + day;
                }
                //return the string "MMddyy"
//              console.log(day+month+year);        //return the string "ddMMyy"
                var folderName = day+month+year;
		//end foldername
$.ajax({
   url: "<?=DIR?>"+"del",
   type: 'post',
   data: {path: "/parablu/"+cloudName+"/sync-upload/Portal/"+Base64.encode(htmlspecialchars_decode(uploadUserName))+"/"+nowtest+".part"},
   success: function(response){
// Changing image source when remove
    if(response == 1){
//alert("file deleted successfully");
    }
   }
  });
//delete file end
}

uploader.bind('UploadComplete', function(up, files) {
	currentCountForFolder = 0;
	$('#uploadFilesNew').modal('hide');
	setTimeout(function () { location.reload(); }, 5000);
	$('#pickfiles').show();
        $('#crawlingSpinner').hide();
        $('#statusForFolder').hide();
            var ids = "";
                $('#pickfiles').show();
//                document.getElementById('filesQueue').remove();
//                $('#uploadFilesNew').modal('hide');
//setTimeout(function () { location.reload(); }, 5000);
var list = document.getElementById("filelist");
var inner = document.getElementById("fileQueue");
while (list.hasChildNodes()) {   
console.log("id1 : "+list.firstChild.id);
ids = "uploadStatusText"+list.firstChild.id;
console.log("id11 : "+ids);
//if(inner){
if(document.getElementById(ids).innerHTML != "Working on your file. Please wait until the process is completed...."){
console.log("inside my if");
console.log("innerHTLM : "+ids.innerHTML);

    list.removeChild(list.firstChild);
}}
//}

                });
var attempts = 0;
uploader.bind('Error', function(up, args) {
//angular.element(document.getElementById('cru')).scope().errorNetwork();
/*console.log( "Error during upload." );
console.log("Errors code"+args.code);
console.log("Errors msg : "+args.message);
console.log("attempts" +attempts);
log('[Error] ', args);*/
attempts++;
});

uploader.bind('FilesRemoved', function(up, files) {
                // Called when files are removed from queue
  //              log('[FilesRemoved]');
  
                plupload.each(files, function(file) {
//                    log('  File:', file);
                });
            });

        uploader.bind('UploadProgress', function(up, file) {
		//console.log("File Id: "+file.id);
		/*expppp start*/
                $('#statusForFolder').show();
                $('#crawlingSpinner').hide();
                var ddd = $('#filesListing').html();
var fileUploadLimitSize = $('.file-limit-size').html();
var allowedFileAttributes = $('.fileIncludeExtensions').html().replace(' ', '').split(',');
var notAllowedFileAttributes = $('.fileExcludeExtensions').html().replace(' ', '').split(',');
                var filename = file.name;
                        if(filename.length > 25)
                        {
                            filename = filename.substring(0,25)+"...";
                        }
angular.element(document.getElementById('cru')).scope().check(file);  //new
var extension = file.name.substring(file.name.lastIndexOf('.')+1);
extension = extension.toLowerCase();
if(!document.getElementById("filelist"))
{
var g = document.createElement('div');
g.setAttribute("id","filelist");
}
                if($('.fileIncludeExtensions').html().length == 0 && $('.fileExcludeExtensions').html().length == 0){
if(fileUploadLimitSize.length > 0)
                {console.log("inside uploadsize");
                if(file.size <= (fileUploadLimitSize*1000*1000))
                        {//console.log("above bar");
		if(!document.getElementById('filesQueue'+file.id)){
			document.getElementById('filelist').innerHTML += '<div id="filesQueue'+file.id+'" style="border: 1px solid #ddd;padding:10px;width:90%;border-radius:5px;margin:5px;"><div id="' + file.id + '"><i class="fa fa-file-photo-o fa-1x ng-binding" style="float:left;"> ' + filename + '  (' + plupload.formatSize(file.size) + ') </i>&nbsp;&nbsp;<span id="uploadStatusText'+file.id+'"></span>&nbsp;&nbsp;<a type="button" id="cancel'+file.id+'" name="'+file.name+'" class="btn btn-small btn-danger" onclick="deleteThisFile(this);" style="margin: 2px;">Cancel</a><span id="per'+file.id+'" class="percentage pull-right"></span><div id="myProgress" style="border-radius: 5px;"><div class="progress-bar progress-bar-striped active" aria-valuenow="" id="myBar'+file.id+'" name="'+file.name+'/'+file.size+'" class="'+file.origSize+'"></div></div><b></b></div></div>';
                }
}
else{
uploader.removeFile(file);
}
                }

if($('.fileIncludeExtensions').html().length > 0){
if(fileUploadLimitSize.length > 0)
                {
                if(file.size <= (fileUploadLimitSize*1000*1000))
                        {
if(allowedFileAttributes.indexOf(extension)>=0)
{
document.getElementById('filelist').innerHTML += '<div id="filesQueue'+file.id+'" style="border: 1px solid #ddd;padding:10px;width:90%;border-radius:5px;margin:5px;"><div id="' + file.id + '"><i class="fa fa-file fa-1x ng-binding" style="float:left;"> ' + filename + '  (' + plupload.formatSize(file.size) + ') </i>&nbsp;&nbsp;<span id="uploadStatusText'+file.id+'"></span>&nbsp;&nbsp;<a type="button" id="cancel'+file.id+'" name="'+file.name+'" class="btn btn-small btn-danger" onclick="deleteThisFile(this);" style="margin: 2px;">Cancel</a><span id="per'+file.id+'" class="percentage pull-right"></span><div id="myProgress" style="border-radius: 5px;"><div class="progress-bar progress-bar-striped active" aria-valuenow="" id="myBar'+file.id+'" name="'+file.name+'/'+file.size+'" class="'+file.origSize+'"></div></div><b></b></div></div>';
}
}
else{
	//console.log("inside else"+file.name);
uploader.removeFile(file);
}
}}

if($('.fileExcludeExtensions').html().length > 0){
if(notAllowedFileAttributes.indexOf(extension)>=0)
{
//alert("Not Allowed");
//setTimeout(function(){ location.reload(); }, 1000);
}else{
if(fileUploadLimitSize.length > 0)
                {
                if(file.size <= (fileUploadLimitSize*1000*1000))
                        {

document.getElementById('filelist').innerHTML += '<div id="filesQueue'+file.id+'" style="border: 1px solid #ddd;padding:10px;width:90%;border-radius:5px;margin:5px;"><div id="' + file.id + '"><i class="fa fa-file fa-1x ng-binding" style="float:left;"> ' + filename + ' (' + plupload.formatSize(file.size) + ')</i>&nbsp;&nbsp;<span id="uploadStatusText'+file.id+'"></span>&nbsp;&nbsp;<a type="button" id="cancel'+file.id+'" name="'+file.name+'" class="btn btn-small btn-danger" onclick="deleteThisFile(this);" style="margin: 2px;">Cancel</a><span id="per'+file.id+'" class="percentage pull-right"></span><div id="myProgress" style="border-radius: 5px;"><div class="progress-bar progress-bar-striped active" aria-valuenow="" id="myBar'+file.id+'" name="'+file.name+'/'+file.size+'" class="'+file.origSize+'"></div></div><b></b></div></div>';
}
else{
//console.log("inside else"+file.name);
uploader.removeFile(file);
}

}
}}              }
                /*exp end*/
if(document.getElementById('per'+file.id) !== null){
                document.getElementById('per'+file.id).innerHTML = file.percent+" %";
                document.getElementById('myBar'+file.id).style.position = "absolute";
		document.getElementById('myBar'+file.id).style.width = file.percent+"%";
		document.getElementById('myBar'+file.id).style.height = "100%";
		document.getElementById('myBar'+file.id).style.borderRadius = "5px";
		document.getElementById('uploadStatusText'+file.id).innerHTML = "Upload in progress...";
                $("#myBar"+file.id).attr("aria-valuenow", file.percent);
}
                });

        uploader.bind('ChunkUploaded', function(up, file, info) {
var isOffline;	
    console.log( "Chunk uploaded....!!" );

window.addEventListener('offline', offlineIndi);
function offlineIndi() {
    isOffline = setTimeout(function(){  $('#networkFailure').modal('show'); }, 120000);
}

window.addEventListener('online', onlineIndi);
function onlineIndi() {
    clearTimeout(isOffline);
}

//console.log("Info : " +info.status+ " Response : "+info.response);
                });

	uploader.bind('FileUploaded' , function(up, file, info) {
		currentCountForFolder = currentCountForFolder+1;
	        document.getElementById("currentCountForFolder").innerHTML = currentCountForFolder;
		$("#menu1").scrollTop('0px');
            if(document.getElementById('uploadStatusText'+file.id)){
		document.getElementById('uploadStatusText'+file.id).innerHTML = "Working on your file. Please wait until the process is completed....";
                var obj = JSON.parse(info.response);
                //start
                var d = new Date();         //get the date
                var month = d.getMonth();   //get the month
                var day = d.getDate().toString();   //get the day and convert to string
                var year = d.getFullYear(); //get the year
                year = year.toString().substr(-2);  //pull the last two digits of the year
month = (month + 1).toString();     //increment month by 1 since it is 0 indexed and converts month to a string
                if (month.length === 1)     //if month is 1-9 pad right with a 0 for two digits
                {
                month = "0" + month;
                }
                if (day.length === 1)       //if day is between 1-9 pad right with a 0 for two digits
                {
                day = "0" + day;
                }
                //return the string "MMddyy"
//              console.log(day+month+year);        //return the string "ddMMyy"
function htmlspecialchars_decode(string, quote_style) {
        var optTemp = 0,
            i = 0,
            noquotes = false;
        if (typeof quote_style === 'undefined') {
            quote_style = 2;
        }
        string = string.toString()
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>');
        var OPTS = {
            'ENT_NOQUOTES': 0,
            'ENT_HTML_QUOTE_SINGLE': 1,
            'ENT_HTML_QUOTE_DOUBLE': 2,
            'ENT_COMPAT': 2,
            'ENT_QUOTES': 3,
            'ENT_IGNORE': 4
        };
        if (quote_style === 0) {
            noquotes = true;
        }
        if (typeof quote_style !== 'number') { // Allow for a single string or an array of string flags
            quote_style = [].concat(quote_style);
            for (i = 0; i < quote_style.length; i++) {
                // Resolve string input to bitwise e.g. 'PATHINFO_EXTENSION' becomes 4
                if (OPTS[quote_style[i]] === 0) {
                    noquotes = true;
                } else if (OPTS[quote_style[i]]) {
                    optTemp = optTemp | OPTS[quote_style[i]];
                }
            }
            quote_style = optTemp;
        }
        if (quote_style & OPTS.ENT_HTML_QUOTE_SINGLE) {
            string = string.replace(/&#0*39;/g, "'"); // PHP doesn't currently escape if more than one 0, but it should
            // string = string.replace(/&apos;|&#x0*27;/g, "'"); // This would also be useful here, but not a part of PHP
        }
        if (!noquotes) {
            string = string.replace(/&quot;/g, '"');
        }
        // Put this in last place to avoid escape being double-decoded
        string = string.replace(/&amp;/g, '&');

        return string;
    }
                var folderName = day+month+year;
                var filePath = $('#cru').html();
//		filePath = Base64.encode(htmlspecialchars_decode(filePath));
		filePath = filePath.slice(0,-1);
		var rela = file.relativePath;
		rela = rela.substring(0, rela.lastIndexOf("/") );
		rela = rela+"/";
//		var kk = Base64.encode(htmlspecialchars_decode(filePath)+file.relativePath);
		var kk = Base64.encode(htmlspecialchars_decode(filePath)+rela);
		var d = new Date();		
		var n = d.getTime();
		var fileLastModifiedDate = file.lastModifiedDate;
		fileLastModifiedDate = new Date(fileLastModifiedDate).getTime();
		/*var extension = file.name.substring(file.name.lastIndexOf('.')+1);
                extension = extension.toLowerCase();
                var nowtest = file.id+'.'+extension;*/
		if(file.name.lastIndexOf('.') != '-1'){
                        var extension = file.name.substring(file.name.lastIndexOf('.')+1);
                }
                if(extension){
                        var nowtest = file.id+'.'+extension;
                }else{
                        var nowtest = file.id;
                }
                //var cloudName = $('.cloudNameConstant').html();
                var headers = {
                        'token'          : $('.uploadToken').html(),
                        'is-exists'      : 'false',
                        'is-folder'      : 'false',
                        'is-base-folder' : 'false',
                };
                var body = {
                	'Content-type'	: 'application/json',
                	'Accept'        : 'application/json',
			'userName'      : $('.uploadUserName').html(),
			'fileCompletePath'    : kk,
//                        'fileCompletePath'	: filePath.slice(0,-1),
                        'fileName'      : Base64.encode(htmlspecialchars_decode(file.name)),
                        'fileSize'      : file.size,
                        'cloudName'     : $('.cloudNameConstant').html(),
                        'gatewayName'   : $('.blukryptIP').html(),
			'modified'      : file.getSource().lastModifiedDate,
			'fileTmpPath'   : "/parablu/"+cloudName+"/sync-upload/Portal/"+Base64.encode(htmlspecialchars_decode(uploadUserName))+"/"+nowtest,
//                        'fileTmpPath'   : "/parablu/"+cloudName+"/sync-upload/Portal/"+uploadUserName+"/"+file.name,
		};
console.log("relaaaa : "+rela);		
console.log("body : "+JSON.stringify(body));
                $.ajax({
url: $('.blukryptIPAddress').html()+$('.cloudNameConstant').html()+'/sync/portal/new/upload/file/',
headers: headers,
data: JSON.stringify(body),
contentType: 'application/json',			
method: 'POST'
}).done(function(data,textStatus,xhr){
//var jData = JSON.parse(data);
//console.log("DATA : "+jData.status);
//console.log("String : "+JSON.stringify(data));
//console.log("String2 : "+JSON.stringify(textStatus));
//console.log("Try1 : "+xhr.status);
if(xhr.status == '200') {
$("#filesQueue"+file.id).remove();
if($('div[id ^= "filesQueue"]').length <=0){
// $('#uploadFilesNew').modal('hide');
// setTimeout(function () { location.reload(); }, 5000);
}
//angular.element(document.getElementById('cru')).scope().updateFileList('root', 'root', true, true);
angular.element(document.getElementById('cru')).scope().uploadSuccess(file.name);
//delete file start
$.ajax({
   url: "<?=DIR?>"+"del",
	   type: 'post',
	   data: {path: "/parablu/"+cloudName+"/sync-upload/Portal/"+Base64.encode(htmlspecialchars_decode(uploadUserName))+"/"+nowtest},
//   data: {path: "/parablu/"+cloudName+"/sync-upload/Portal/"+uploadUserName+"/"+file.name},
   success: function(response){
// Changing image source when remove
    if(response == 1){
//alert("file deleted successfully");
    }
   }
  });
//delete file end
}
}).fail(function(response){
//console.log("response code : "+response.status);
//              alert("Error"+file.name);
/*if(response.status == '448'){
angular.element(document.getElementById('cru')).scope().alreadyExists(file.name);
$("#filesQueue"+file.id).remove();
uploader.removeFile(file);
}else{*/
if(response.status == '448') {
$("#filesQueue"+file.id).remove();
if($('div[id ^= "filesQueue"]').length <=0){
// $('#uploadFilesNew').modal('hide');
// setTimeout(function () { location.reload(); }, 5000);
}
//angular.element(document.getElementById('cru')).scope().updateFileList('root', 'root', true, true);
angular.element(document.getElementById('cru')).scope().alreadyExists(file.name);
//delete file start
$.ajax({
   url: "<?=DIR?>"+"del",
   type: 'post',
   data: {path: "/parablu/"+cloudName+"/sync-upload/Portal/"+Base64.encode(htmlspecialchars_decode(uploadUserName))+"/"+nowtest},
   success: function(response){
// Changing image source when remove
    if(response == 1){
//alert("file deleted successfully");
    }
   }
  });
//delete file end
}else if(response.status == '507') {
$("#filesQueue"+file.id).remove();
if($('div[id ^= "filesQueue"]').length <=0){
// $('#uploadFilesNew').modal('hide');
 angular.element(document.getElementById('cru')).scope().spaceExceeded(file.name);
// setTimeout(function () { location.reload(); }, 5000);
}
//angular.element(document.getElementById('cru')).scope().updateFileList('root', 'root', true, true);
//delete file start
$.ajax({
   url: "<?=DIR?>"+"del",
   type: 'post',
   data: {path: "/parablu/"+cloudName+"/sync-upload/Portal/"+Base64.encode(htmlspecialchars_decode(uploadUserName))+"/"+nowtest},
   success: function(response){
// Changing image source when remove
    if(response == 1){
//alert("file deleted successfully");
    }
   }
  });
//delete file end
}else if(response.status == '449') {
$("#filesQueue"+file.id).remove();
if($('div[id ^= "filesQueue"]').length <=0){
// $('#uploadFilesNew').modal('hide');
 angular.element(document.getElementById('cru')).scope().spaceExceededUser(file.name);
// setTimeout(function () { location.reload(); }, 5000);
}
//angular.element(document.getElementById('cru')).scope().updateFileList('root', 'root', true, true);
//delete file start
$.ajax({
   url: "<?=DIR?>"+"del",
   type: 'post',
   data: {path: "/parablu/"+cloudName+"/sync-upload/Portal/"+Base64.encode(htmlspecialchars_decode(uploadUserName))+"/"+nowtest},
   success: function(response){
// Changing image source when remove
    if(response == 1){
//alert("file deleted successfully");
    }
   }
  });
//delete file end
}else{
angular.element(document.getElementById('cru')).scope().uploadFailed(file.name);
$("#filesQueue"+file.id).remove();
uploader.removeFile(file);
}
                });
        }
});

uploader.init();
/*function deleteFile(i) {
console.log("File Id : "+i);
//var x = i.replace('dele', '');
uploader.removeFile(uploader.getFile(i));
    }
*/
function log() {
        var str = "";
 
        plupload.each(arguments, function(arg) {
            var row = "";
if (typeof(arg) != "string") {
                plupload.each(arg, function(value, key) {
                    // Convert items in File objects to human readable form
                    if (arg instanceof plupload.File) {
                        // Convert status to human readable
                        switch (value) {
                            case plupload.QUEUED:
                                value = 'QUEUED';
                                break;
 
                            case plupload.UPLOADING:
                                value = 'UPLOADING';
                                break;
 
                            case plupload.FAILED:
                                value = 'FAILED';
                                break;
			    case plupload.DONE:
                                value = 'DONE';
                                break;
                        }
                    }
 
                    if (typeof(value) != "function") {
                        row += (row ? ', ' : '') + key + '=' + value;
                    }
                });
 
                str += row + " ";
            } else {
                str += arg + " ";
            }
        });
var log = $('#log');
        log.append(str + "\n");
        log.scrollTop(log[0].scrollHeight);
    }
	
var Base64 = {


    _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",


    encode: function(input) {
        var output = "";
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;

        input = Base64._utf8_encode(input);

        while (i < input.length) {

            chr1 = input.charCodeAt(i++);
            chr2 = input.charCodeAt(i++);
            chr3 = input.charCodeAt(i++);

            enc1 = chr1 >> 2;
            enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
            enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
            enc4 = chr3 & 63;

            if (isNaN(chr2)) {
                enc3 = enc4 = 64;
            } else if (isNaN(chr3)) {
                enc4 = 64;
            }

            output = output + this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) + this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);

        }

        return output;
},


    decode: function(input) {
        var output = "";
        var chr1, chr2, chr3;
        var enc1, enc2, enc3, enc4;
        var i = 0;

        input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

        while (i < input.length) {

            enc1 = this._keyStr.indexOf(input.charAt(i++));
            enc2 = this._keyStr.indexOf(input.charAt(i++));
            enc3 = this._keyStr.indexOf(input.charAt(i++));
            enc4 = this._keyStr.indexOf(input.charAt(i++));
            chr1 = (enc1 << 2) | (enc2 >> 4);
            chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
            chr3 = ((enc3 & 3) << 6) | enc4;

            output = output + String.fromCharCode(chr1);

            if (enc3 != 64) {
                output = output + String.fromCharCode(chr2);
            }
            if (enc4 != 64) {
                output = output + String.fromCharCode(chr3);
            }

        }

        output = Base64._utf8_decode(output);

        return output;
    },

    _utf8_encode: function(string) {
        string = string.replace(/\r\n/g, "\n");
        var utftext = "";

        for (var n = 0; n < string.length; n++) {

            var c = string.charCodeAt(n);

            if (c < 128) {
                utftext += String.fromCharCode(c);
            }
            else if ((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            }
            else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }

        }

        return utftext;
    },

    _utf8_decode: function(utftext) {
        var string = "";
        var i = 0;
        var c = c1 = c2 = 0;

        while (i < utftext.length) {
        c = utftext.charCodeAt(i);

            if (c < 128) {
                string += String.fromCharCode(c);
                i++;
            }
            else if ((c > 191) && (c < 224)) {
                c2 = utftext.charCodeAt(i + 1);
                string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                i += 2;
            }
            else {
                c2 = utftext.charCodeAt(i + 1);
                c3 = utftext.charCodeAt(i + 2);
                string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                i += 3;
            }
        }

        return string;
    }

}	

</script>
<style>
#myProgress {
    position: relative;
    height: 10px;
    background-color: grey;
}
#drop-target2 {
        border: 1px dashed #999;
        color: #999;
        cursor: pointer;
 }

      #drop-target1 {
        border: 10px dashed #999;
        text-align: center;
        color: #999;
        font-size: 20px;
        width: 600px;
        height: 300px;
        line-height: 300px;
        cursor: pointer;
      }

      #drop-target.dragover {
        background: rgba(255, 255, 255, 0.4);
        border-color: green;
      }
</style>
<script>
function disableF5(e) { if ((e.which || e.keyCode) == 116) e.preventDefault(); };
$(document).on("keydown", disableF5);
</script>
<script>
$("#closeNewUpload").click(function() {
uploader.stop();
$('#pickfiles').show();
var list = document.getElementById("filelist");
var inner = document.getElementById("fileQueue");
while (list.hasChildNodes()) {   

console.log(list.firstChild.id);
    list.removeChild(list.firstChild);
}
$('#uploadFilesNew').modal('hide');
location.reload();

});
</script>
<script>
$("#UploadAlready").click(function() {
$('#UploadAl').modal('hide');
$('#uploadFilesNew').modal('hide');
location.reload();
});
</script>
<script>
$("#netFail").click(function() {
$('#networkFailure').modal('hide');
$('#uploadFilesNew').modal('hide');
location.reload();
});
</script>

<script>
window.addEventListener("dragover",function(e){
  e = e || event;
//  console.log(e);
  if (e.target.tagName != "drop-target") { // check wich element is our target
    e.preventDefault();
  }
},false);
window.addEventListener("drop",function(e){
  e = e || event;
//  console.log(e);
  if (e.target.tagName != "drop-target") {  // check wich element is our target
    e.preventDefault();
    document.getElementById('drop-target').style.border = "none";
  }  
},false);
document.getElementById('drop-target').addEventListener("dragenter", function(event) {
        document.getElementById('drop-target').style.border = "3px dashed #f27331";
});
	
	/*for share modal starts*/	
	$( "#sharePassword" ).change(function(){
        console.log("sharePassword clicked");
        if($(".shareLinkBlock").is(":visible")) {
		$('.shareBtn').show();
		$('.shareBtn').html('Save');
		$('.changeImpactText').show();
        }
});

$( "#till" ).change(function(){
        console.log("valid clicked");
        if($(".shareLinkBlock").is(":visible")) {
		$('.shareBtn').show();
		$('.shareBtn').html('Save');
		$('.changeImpactText').show();
        }
});

var enableDownload = document.querySelector('.enableDownload');
    if(enableDownload){
            enableDownload.onchange = function() {
                    if($(".shareLinkBlock").is(":visible")) {
			$('.shareBtn').show();
			$('.shareBtn').html('Save');
			$('.changeImpactText').show();
                    }
        };
    }
	
var sharePasswordSwitch = document.querySelector('.sharePasswordSwitch');
    if(sharePasswordSwitch){
            sharePasswordSwitch.onchange = function() {
                    if($(".shareLinkBlock").is(":visible")) {
			$('.shareBtn').show();
			$('.shareBtn').html('Save');
			$('.changeImpactText').show();
                    }
        };
    }

$('#share').on('hidden.bs.modal', function(){
        $("#fileShareForm").parsley().reset();
});

$('form').on('reset', function() {
  var $form = $(this);
  $form.find('.error,.valid').css('border-color', '').removeClass('error').removeClass('valid');
  $form.find('.form-error').remove();
});	
	
/*for share modal ends*/	

/*share with start*/
$( "#listOfUsers" ).change(function(){
        console.log("listOfUsers clicked");
        if($(".unShareBtn").is(":visible")) {
        $('.shareBtn').show();
	$('.shareBtn').html('Save');
        $('.changeImpactTextSharewith').show();
        }
});

$( "#shareWithSubject" ).change(function(){
        console.log("shareWithSubject clicked");
        if($(".unShareBtn").is(":visible")) {
        $('.shareBtn').show();
	$('.shareBtn').html('Save');
        $('.changeImpactTextSharewith').show();
        }
});

$( "#shareWithMessage" ).change(function(){
        console.log("shareWithMessage clicked");
        if($(".unShareBtn").is(":visible")) {
        $('.shareBtn').show();
	$('.shareBtn').html('Save');
        $('.changeImpactTextSharewith').show();
        }
});

$( "#till1" ).change(function(){
        console.log("valid clicked");
        if($(".unShareBtn").is(":visible")) {
        $('.shareBtn').show();
	$('.shareBtn').html('Save');
        $('.changeImpactTextSharewith').show();
        }
});
	
var enableDownload = document.querySelector('.shareWithEnableDownload');
    if(enableDownload){
            enableDownload.onchange = function() {
                    if($(".unShareBtn").is(":visible")) {
                $('.shareBtn').show();
		$('.shareBtn').html('Save');
                $('.changeImpactTextSharewith').show();
                    }
        };
    }

var sharePasswordSwitch = document.querySelector('.shareWithEnableView');
    if(sharePasswordSwitch){
            sharePasswordSwitch.onchange = function() {
                    if($(".unShareBtn").is(":visible")) {
                $('.shareBtn').show();
		$('.shareBtn').html('Save');
                $('.changeImpactTextSharewith').show();
                    }
        };
    }

$('#shareWith').on('hidden.bs.modal', function(){
        $("#fileShareWithForm").parsley().reset();
});
/*share with ends*/
	
	$("#share").on("hidden.bs.modal", function(){
                $('#sharePassword').val('');
                $('#reSharePassword').val('');
                $('#till').val('');
        });

	$("#shareWith").on("hidden.bs.modal", function(){
		$('#till1').val('');
		$('#listOfUsers').val('');
		$('#shareWithSubject').val('');
		$('#shareWithMessage').val('');
        });
</script>
<style>
canvas{
border: 2px solid black;
margin: 5px;
width:400px;
height:500px;
}
</style>
<script src="<?=Url::templatePath()?>js/plugins/plupload1.full.min.js?<?=VERSIONS_NUMBER?>" type="text/javascript" charset="UTF-8"></script>	
<script>
var uploader1 = new plupload.Uploader({
//        runtimes : 'html5',
runtimes : 'html5,flash,gears,browserplus,silverlight,html4',
//        drop_element : 'drop-target',
        browse_button : 'pickfiles1',
        select_folder: true,
        //max_file_size : '100gb',
        autostart: true,
	prevent_duplicates: false,
	unique_names: true,
        url : "<?=DIR?>"+"up",
        chunk_size : '100mb',
});

uploader1.bind('Init', function(up, params) {
	document.getElementById('debug1').innerHTML = "";
                if (uploader.features.dragdrop) {
                document.getElementById('debug1').innerHTML = "";
                var target = $("drop-target");
                target.ondragover = function(event) {
                event.dataTransfer.dropEffect = "copy";
                };

                target.ondragenter = function() {
                this.className = "dragover";
                };
                target.ondragleave = function() {
                this.className = "";
                };
target.ondrop = function() {
                this.className = "";
                };
                }
});

uploader1.bind('PostInit',function() {
                        document.getElementById('filelist1').innerHTML = '';
                });

/*uploader1.bind('UploadFile', function(up, file) {
var allowedFileAttributes = $('.fileIncludeExtensions').html().replace(' ', '').split(',');
var name = file.name;
var extension = name.substring(name.lastIndexOf('.')+1);
if(allowedFileAttributes.indexOf(extension)>=0){
return true;
}
else {
up.splice(0);
}
});
uploader1.bind('BeforeUpload', function(up, file) {
var allowedFileAttributes = $('.fileIncludeExtensions').html().replace(' ', '').split(',');
var extension = file.name.substring(file.name.lastIndexOf('.')+1);
if(allowedFileAttributes.indexOf(extension)>=0){
return true;
}
else {
return false;
}
});*/
var currentCountForFolder1 = 0;
uploader1.bind('FilesAdded', function(up, files) {
//	document.getElementById("overlayText").style.display = "block";
		//console.log('length : '+files.length);
//		document.getElementById("menu11").style.overflow = "scroll";
	//                document.getElementById("menu11").style.height = "400px";
	document.getElementById("totalCountForFolder1").innerHTML = files.length;
        document.getElementById("currentCountForFolder1").innerHTML = currentCountForFolder1;
        $('#pickfiles1').hide();
        $('#crawlingSpinner1').show();
        $('#statusForFolder1').hide();
	if(!$('#uploadFilesNew1').hasClass('in')){
	//Do something here
	/*if(files.length >=6 ){
                        $('#menu11').css('overflowY', 'scroll');
                    $('#menu11').height('400px');
                }*/
                $('#uploadFilesNew1').modal('show');
                }

/*        var ddd = $('#filesListing').html();
var fileUploadLimitSize = $('.file-limit-size').html();
var allowedFileAttributes = $('.fileIncludeExtensions').html().replace(' ', '').split(',');
var notAllowedFileAttributes = $('.fileExcludeExtensions').html().replace(' ', '').split(',');
//console.log("LIMITSIZE : "+fileUploadLimitSize);
//console.log("ALLOWED : "+allowedFileAttributes);
//console.log("NOT ALLOWED : "+notAllowedFileAttributes);
//      console.log("VVVVVVV : "+ddd);
                plupload.each(files, function(file) {
var filename = file.name;
                        if(filename.length > 25)
                        {
                            filename = filename.substring(0,25)+"...";
                        }
angular.element(document.getElementById('cru')).scope().check(file);  //new
var extension = file.name.substring(file.name.lastIndexOf('.')+1);
extension = extension.toLowerCase();
if(!document.getElementById("filelist1"))
{
var g = document.createElement('div');
g.setAttribute("id","filelist1");
}

if($('.fileIncludeExtensions').html().length == 0 && $('.fileExcludeExtensions').html().length == 0){
//console.log("inside == 0");
if(fileUploadLimitSize.length > 0)
		{console.log("inside uploadsize");
		if(file.size <= (fileUploadLimitSize*1000*1000))
			{//console.log("above bar");
document.getElementById('filelist1').innerHTML += '<div id="filesQueue'+file.id+'" style="border: 1px solid #ddd;padding:10px;width:90%;border-radius:5px;margin:5px;"><div id="' + file.id + '"><i class="fa fa-file fa-1x ng-binding" style="float:left;"> ' + filename + '  (' + plupload.formatSize(file.size) + ') </i>&nbsp;&nbsp;<span id="uploadStatusText'+file.id+'"></span>&nbsp;&nbsp;<a type="button" id="cancel'+file.id+'" name="'+file.name+'" class="btn btn-danger btn-small" onclick="deleteThisFile1(this);" style="margin: 2px;">Cancel</a><span id="per'+file.id+'" class="percentage pull-right"></span><div id="myProgress" style="border-radius: 5px;"><div class="progress-bar progress-bar-striped active" aria-valuenow="" id="myBar'+file.id+'" name="'+file.name+'/'+file.size+'" class="'+file.origSize+'"></div></div><b></b></div></div>';
}
else{
//console.log("inside else"+file.name);
uploader1.removeFile(file);
}
}}

if($('.fileIncludeExtensions').html().length > 0){
if(fileUploadLimitSize.length > 0)
		{
		if(file.size <= (fileUploadLimitSize*1000*1000))
			{
if(allowedFileAttributes.indexOf(extension)>=0)
{
document.getElementById('filelist1').innerHTML += '<div id="filesQueue'+file.id+'" style="border: 1px solid #ddd;padding:10px;width:90%;border-radius:5px;margin:5px;"><div id="' + file.id + '"><i class="fa fa-file fa-1x ng-binding" style="float:left;"> ' + filename + '  (' + plupload.formatSize(file.size) + ') </i>&nbsp;&nbsp;<span id="uploadStatusText'+file.id+'"></span>&nbsp;&nbsp;<a type="button" id="cancel'+file.id+'" name="'+file.name+'" class="btn btn-danger btn-small" onclick="deleteThisFile1(this);" style="margin: 2px;">Cancel</a><span id="per'+file.id+'" class="percentage pull-right"></span><div id="myProgress" style="border-radius: 5px;"><div class="progress-bar progress-bar-striped active" aria-valuenow="" id="myBar'+file.id+'" name="'+file.name+'/'+file.size+'" class="'+file.origSize+'"></div></div><b></b></div></div>';
}
}
else{
//console.log("inside else"+file.name);
uploader1.removeFile(file);
}
}}

if($('.fileExcludeExtensions').html().length > 0){
if(notAllowedFileAttributes.indexOf(extension)>=0)
{
//alert("Not Allowed");
//setTimeout(function(){ location.reload(); }, 1000);
}else{
if(fileUploadLimitSize.length > 0)
                {
                if(file.size <= (fileUploadLimitSize*1000*1000))
                        {

document.getElementById('filelist1').innerHTML += '<div id="filesQueue'+file.id+'" style="border: 1px solid #ddd;padding:10px;width:90%;border-radius:5px;margin:5px;"><div id="' + file.id + '"><i class="fa fa-file fa-1x ng-binding" style="float:left;"> ' + filename + ' (' + plupload.formatSize(file.size) + ')</i>&nbsp;&nbsp;<span id="uploadStatusText'+file.id+'"></span>&nbsp;&nbsp;<a type="button" id="cancel'+file.id+'" name="'+file.name+'" class="btn btn-danger btn-small" onclick="deleteThisFile1(this);" style="margin: 2px;">Cancel</a><span id="per'+file.id+'" class="percentage pull-right"></span><div id="myProgress" style="border-radius: 5px;"><div class="progress-bar progress-bar-striped active" aria-valuenow="" id="myBar'+file.id+'" name="'+file.name+'/'+file.size+'" class="'+file.origSize+'"></div></div><b></b></div></div>';
}
else{
//console.log("inside else"+file.name);
uploader1.removeFile(file);
}

}
}}


i++;
		});*/
setTimeout(function () { uploader1.start(); }, 3000);

                });

function deleteThisFile1(item) {
	var id = $(item).attr("id");
	var x = id.replace('cancel', '');
	var name = $(item).attr("name");
	/*var extension = name.substring(name.lastIndexOf('.')+1);
        extension = extension.toLowerCase();
        var nowtest = x+'.'+extension;*/
	if(name.lastIndexOf('.') != '-1'){
        	var extension = name.substring(name.lastIndexOf('.')+1);
        }
        if(extension){
        	var nowtest = x+'.'+extension;
        }else{
        	var nowtest = x;
        }
//console.log("File Id : "+x);
//$("#filesQueue"+x).remove();
//var x = i.replace('dele', '');
//$('#filesQueue'+x).remove();
uploader1.removeFile(uploader1.getFile(x));
$('#filesQueue'+x).remove();	
angular.element(document.getElementById('cru')).scope().cancelFile(name);
//delete file start
console.log("inside delete for: "+name);
//start foldername
var d = new Date();         //get the date
                var month = d.getMonth();   //get the month
                var day = d.getDate().toString();   //get the day and convert to string
                var year = d.getFullYear(); //get the year
                year = year.toString().substr(-2);  //pull the last two digits of the year
		month = (month + 1).toString();     //increment month by 1 since it is 0 indexed and converts month to a string
                if (month.length === 1)     //if month is 1-9 pad right with a 0 for two digits
                {
                month = "0" + month;
                }
                if (day.length === 1)       //if day is between 1-9 pad right with a 0 for two digits
                {
                day = "0" + day;
                }
                //return the string "MMddyy"
//              console.log(day+month+year);        //return the string "ddMMyy"
                var folderName = day+month+year;
		//end foldername
$.ajax({
   url: "<?=DIR?>"+"del",
   type: 'post',
   data: {path: "/parablu/"+cloudName+"/sync-upload/Portal/"+Base64.encode(htmlspecialchars_decode(uploadUserName))+"/"+nowtest+".part"},
   success: function(response){
// Changing image source when remove
    if(response == 1){
//alert("file deleted successfully");
    }
   }
  });
//delete file end
}

	uploader1.bind('UploadComplete', function(up, files) {
		currentCountForFolder1 = 0;
		$('#uploadFilesNew1').modal('hide');
		setTimeout(function () { location.reload(); }, 5000);
		$('#pickfiles1').show();
        	$('#crawlingSpinner1').hide();
	        $('#statusForFolder1').hide();
            var ids = "";
                $('#pickfiles1').show();
//                document.getElementById('filesQueue').remove();
//                $('#uploadFilesNew').modal('hide');
//setTimeout(function () { location.reload(); }, 5000);
var list = document.getElementById("filelist1");
var inner = document.getElementById("fileQueue");
while (list.hasChildNodes()) {
console.log("id1 : "+list.firstChild.id);
ids = "uploadStatusText"+list.firstChild.id;
console.log("id11 : "+ids);
//if(inner){
if(document.getElementById(ids).innerHTML != "Working on your file. Please wait until the process is completed...."){
console.log("inside my if");
console.log("innerHTLM : "+ids.innerHTML);

    list.removeChild(list.firstChild);
}}
//}

                });
var attempts = 0;
uploader1.bind('Error', function(up, args) {
//angular.element(document.getElementById('cru')).scope().errorNetwork();
/*console.log( "Error during upload." );
console.log("Errors code"+args.code);
console.log("Errors msg : "+args.message);
console.log("attempts" +attempts);
log('[Error] ', args);*/
attempts++;
});

uploader1.bind('FilesRemoved', function(up, files) {
                // Called when files are removed from queue
  //              log('[FilesRemoved]');

                plupload.each(files, function(file) {
//                    log('  File:', file);
                });
            });

	uploader1.bind('UploadProgress', function(up, file) {
		$('#statusForFolder1').show();
		/*expppp start*/
                $('#crawlingSpinner1').hide();
                var ddd = $('#filesListing').html();
var fileUploadLimitSize = $('.file-limit-size').html();
var allowedFileAttributes = $('.fileIncludeExtensions').html().replace(' ', '').split(',');
var notAllowedFileAttributes = $('.fileExcludeExtensions').html().replace(' ', '').split(',');
                var filename = file.name;
                        if(filename.length > 25)
                        {
                            filename = filename.substring(0,25)+"...";
                        }
angular.element(document.getElementById('cru')).scope().check(file);  //new
var extension = file.name.substring(file.name.lastIndexOf('.')+1);
extension = extension.toLowerCase();
if(!document.getElementById("filelist1"))
{
var g = document.createElement('div');
g.setAttribute("id","filelist1");
}
                if($('.fileIncludeExtensions').html().length == 0 && $('.fileExcludeExtensions').html().length == 0){
if(fileUploadLimitSize.length > 0)
                {console.log("inside uploadsize");
                if(file.size <= (fileUploadLimitSize*1000*1000))
                        {//console.log("above bar");
                if(!document.getElementById('filesQueue'+file.id)){
                        document.getElementById('filelist1').innerHTML += '<div id="filesQueue'+file.id+'" style="border: 1px solid #ddd;padding:10px;width:90%;border-radius:5px;margin:5px;"><div id="' + file.id + '"><i class="fa fa-file-photo-o fa-1x ng-binding" style="float:left;"> ' + filename + '  (' + plupload.formatSize(file.size) + ') </i>&nbsp;&nbsp;<span id="uploadStatusText'+file.id+'"></span>&nbsp;&nbsp;<a type="button" id="cancel'+file.id+'" name="'+file.name+'" class="btn btn-small btn-danger" onclick="deleteThisFile1(this);" style="margin: 2px;">Cancel</a><span id="per'+file.id+'" class="percentage pull-right"></span><div id="myProgress" style="border-radius: 5px;"><div class="progress-bar progress-bar-striped active" aria-valuenow="" id="myBar'+file.id+'" name="'+file.name+'/'+file.size+'" class="'+file.origSize+'"></div></div><b></b></div></div>';
                }
}
else{
	uploader.removeFile(file);
	}
                }

if($('.fileIncludeExtensions').html().length > 0){
if(fileUploadLimitSize.length > 0)
                {
                if(file.size <= (fileUploadLimitSize*1000*1000))
                        {
if(allowedFileAttributes.indexOf(extension)>=0)
{
document.getElementById('filelist1').innerHTML += '<div id="filesQueue'+file.id+'" style="border: 1px solid #ddd;padding:10px;width:90%;border-radius:5px;margin:5px;"><div id="' + file.id + '"><i class="fa fa-file fa-1x ng-binding" style="float:left;"> ' + filename + '  (' + plupload.formatSize(file.size) + ') </i>&nbsp;&nbsp;<span id="uploadStatusText'+file.id+'"></span>&nbsp;&nbsp;<a type="button" id="cancel'+file.id+'" name="'+file.name+'" class="btn btn-small btn-danger" onclick="deleteThisFile1(this);" style="margin: 2px;">Cancel</a><span id="per'+file.id+'" class="percentage pull-right"></span><div id="myProgress" style="border-radius: 5px;"><div class="progress-bar progress-bar-striped active" aria-valuenow="" id="myBar'+file.id+'" name="'+file.name+'/'+file.size+'" class="'+file.origSize+'"></div></div><b></b></div></div>';
}
}
else{
//console.log("inside else"+file.name);
uploader.removeFile(file);
}
}}

if($('.fileExcludeExtensions').html().length > 0){
if(notAllowedFileAttributes.indexOf(extension)>=0)
{
//alert("Not Allowed");
//setTimeout(function(){ location.reload(); }, 1000);
}else{
if(fileUploadLimitSize.length > 0)
                {
			if(file.size <= (fileUploadLimitSize*1000*1000))
				{

document.getElementById('filelist1').innerHTML += '<div id="filesQueue'+file.id+'" style="border: 1px solid #ddd;padding:10px;width:90%;border-radius:5px;margin:5px;"><div id="' + file.id + '"><i class="fa fa-file fa-1x ng-binding" style="float:left;"> ' + filename + ' (' + plupload.formatSize(file.size) + ')</i>&nbsp;&nbsp;<span id="uploadStatusText'+file.id+'"></span>&nbsp;&nbsp;<a type="button" id="cancel'+file.id+'" name="'+file.name+'" class="btn btn-small btn-danger" onclick="deleteThisFile1(this);" style="margin: 2px;">Cancel</a><span id="per'+file.id+'" class="percentage pull-right"></span><div id="myProgress" style="border-radius: 5px;"><div class="progress-bar progress-bar-striped active" aria-valuenow="" id="myBar'+file.id+'" name="'+file.name+'/'+file.size+'" class="'+file.origSize+'"></div></div><b></b></div></div>';
}
else{
//console.log("inside else"+file.name);
uploader.removeFile(file);
}

}
}}              }
                /*exp end*/
//console.log("File Id: "+file.id);
if(document.getElementById('per'+file.id) !== null){
                document.getElementById('per'+file.id).innerHTML = file.percent+" %";
                document.getElementById('myBar'+file.id).style.position = "absolute";
		document.getElementById('myBar'+file.id).style.width = file.percent+"%";
                document.getElementById('myBar'+file.id).style.height = "100%";
		document.getElementById('myBar'+file.id).style.borderRadius = "5px";
		document.getElementById('uploadStatusText'+file.id).innerHTML = "Upload in progress...";
                $("#myBar"+file.id).attr("aria-valuenow", file.percent);
}
                });

        uploader1.bind('ChunkUploaded', function(up, file, info) {
var isOffline;
    console.log( "Chunk uploaded....!!" );

window.addEventListener('offline', offlineIndi);
function offlineIndi() {
    isOffline = setTimeout(function(){  $('#networkFailure').modal('show'); }, 120000);
}

window.addEventListener('online', onlineIndi);
function onlineIndi() {
    clearTimeout(isOffline);
}

//console.log("Info : " +info.status+ " Response : "+info.response);
                });

uploader1.bind('FileUploaded' , function(up, file, info) {
	currentCountForFolder1 = currentCountForFolder1+1;
        document.getElementById("currentCountForFolder1").innerHTML = currentCountForFolder1;
	console.log("fileUploaded calleddddddddd");
	$("#menu11").scrollTop('0px');
//	$(window).scrollTop($('#menu11').position().top);
            if(document.getElementById('uploadStatusText'+file.id)){
		document.getElementById('uploadStatusText'+file.id).innerHTML = "Working on your file. Please wait until the process is completed....";
                var obj = JSON.parse(info.response);
                //start
                var d = new Date();         //get the date
                var month = d.getMonth();   //get the month
                var day = d.getDate().toString();   //get the day and convert to string
                var year = d.getFullYear(); //get the year
                year = year.toString().substr(-2);  //pull the last two digits of the year
month = (month + 1).toString();     //increment month by 1 since it is 0 indexed and converts month to a string
                if (month.length === 1)     //if month is 1-9 pad right with a 0 for two digits
                {
                month = "0" + month;
                }
                if (day.length === 1)       //if day is between 1-9 pad right with a 0 for two digits
                {
                day = "0" + day;
                }
                //return the string "MMddyy"
//              console.log(day+month+year);        //return the string "ddMMyy"
function htmlspecialchars_decode(string, quote_style) {
        var optTemp = 0,
            i = 0,
            noquotes = false;
        if (typeof quote_style === 'undefined') {
            quote_style = 2;
        }
        string = string.toString()
            .replace(/&lt;/g, '<')
            .replace(/&gt;/g, '>');
        var OPTS = {
            'ENT_NOQUOTES': 0,
            'ENT_HTML_QUOTE_SINGLE': 1,
            'ENT_HTML_QUOTE_DOUBLE': 2,
            'ENT_COMPAT': 2,
            'ENT_QUOTES': 3,
            'ENT_IGNORE': 4
        };
        if (quote_style === 0) {
            noquotes = true;
        }
        if (typeof quote_style !== 'number') { // Allow for a single string or an array of string flags
            quote_style = [].concat(quote_style);
            for (i = 0; i < quote_style.length; i++) {
                // Resolve string input to bitwise e.g. 'PATHINFO_EXTENSION' becomes 4
                if (OPTS[quote_style[i]] === 0) {
                    noquotes = true;
                } else if (OPTS[quote_style[i]]) {
                    optTemp = optTemp | OPTS[quote_style[i]];
                }
            }
            quote_style = optTemp;
        }
        if (quote_style & OPTS.ENT_HTML_QUOTE_SINGLE) {
            string = string.replace(/&#0*39;/g, "'"); // PHP doesn't currently escape if more than one 0, but it should
            // string = string.replace(/&apos;|&#x0*27;/g, "'"); // This would also be useful here, but not a part of PHP
        }
        if (!noquotes) {
            string = string.replace(/&quot;/g, '"');
        }
        // Put this in last place to avoid escape being double-decoded
        string = string.replace(/&amp;/g, '&');

        return string;
    }
                var folderName = day+month+year;
                var filePath = $('#cru').html();
//              filePath = Base64.encode(htmlspecialchars_decode(filePath));
                filePath = filePath.slice(0,-1);
                var rela = file.relativePath;
                rela = rela.substring(0, rela.lastIndexOf("/") );
                rela = rela+"/";
//              var kk = Base64.encode(htmlspecialchars_decode(filePath)+file.relativePath);
                var kk = Base64.encode(htmlspecialchars_decode(filePath)+rela);
                var d = new Date();
		var n = d.getTime();
		var fileLastModifiedDate = file.lastModifiedDate;
		fileLastModifiedDate = new Date(fileLastModifiedDate).getTime();
		/*var extension = file.name.substring(file.name.lastIndexOf('.')+1);
		extension = extension.toLowerCase();
		var nowtest = file.id+'.'+extension;*/
		if(file.name.lastIndexOf('.') != '-1'){
                        var extension = file.name.substring(file.name.lastIndexOf('.')+1);
                }
                if(extension){
                        var nowtest = file.id+'.'+extension;
                }else{
                        var nowtest = file.id;
                }
                //var cloudName = $('.cloudNameConstant').html();
                var headers = {
                        'token'          : $('.uploadToken').html(),
                        'is-exists'      : 'false',
                        'is-folder'      : 'false',
                        'is-base-folder' : 'false',
                };
                var body = {
                	'Content-type'	: 'application/json',
                	'Accept'        : 'application/json',
                        'userName'      : $('.uploadUserName').html(),
			'fileCompletePath'    : kk,
                        //'fileCompletePath'	: filePath.slice(0,-1),
                        'fileName'      : Base64.encode(htmlspecialchars_decode(file.name)),
                        'fileSize'      : file.size,
                        'cloudName'     : $('.cloudNameConstant').html(),
                        'gatewayName'   : $('.blukryptIP').html(),
			'modified'      : file.getSource().lastModifiedDate,
			'fileTmpPath'   : "/parablu/"+cloudName+"/sync-upload/Portal/"+Base64.encode(htmlspecialchars_decode(uploadUserName))+"/"+nowtest,
//                        'fileTmpPath'   : "/parablu/"+cloudName+"/sync-upload/Portal/"+uploadUserName+"/"+file.name,
                };

                $.ajax({
url: $('.blukryptIPAddress').html()+$('.cloudNameConstant').html()+'/sync/portal/new/upload/file/',
headers: headers,
data: JSON.stringify(body),
contentType: 'application/json',
method: 'POST'
}).done(function(data,textStatus,xhr){
//var jData = JSON.parse(data);
//console.log("DATA : "+jData.status);
//console.log("String : "+JSON.stringify(data));
//console.log("String2 : "+JSON.stringify(textStatus));
//console.log("Try1 : "+xhr.status);
if(xhr.status == '200') {
$("#filesQueue"+file.id).remove();
if($('div[id ^= "filesQueue"]').length <=0){
//	$('#uploadFilesNew1').modal('hide');
// setTimeout(function () { location.reload(); }, 5000);
}
//angular.element(document.getElementById('cru')).scope().updateFileList('root', 'root', true, true);
angular.element(document.getElementById('cru')).scope().uploadSuccess(file.name);
//delete file start
$.ajax({
   url: "<?=DIR?>"+"del",
	   type: 'post',
	   data: {path: "/parablu/"+cloudName+"/sync-upload/Portal/"+Base64.encode(htmlspecialchars_decode(uploadUserName))+"/"+nowtest},
//   data: {path: "/parablu/"+cloudName+"/sync-upload/Portal/"+uploadUserName+"/"+file.name},
   success: function(response){
// Changing image source when remove
    if(response == 1){
//alert("file deleted successfully");
    }
   }
  });
//delete file end
}
}).fail(function(response){
//console.log("response code : "+response.status);
//              alert("Error"+file.name);
/*if(response.status == '448'){
angular.element(document.getElementById('cru')).scope().alreadyExists(file.name);
$("#filesQueue"+file.id).remove();
uploader1.removeFile(file);
}else{*/
if(response.status == '448') {
$("#filesQueue"+file.id).remove();
if($('div[id ^= "filesQueue"]').length <=0){
// $('#uploadFilesNew1').modal('hide');
// setTimeout(function () { location.reload(); }, 5000);
}
//angular.element(document.getElementById('cru')).scope().updateFileList('root', 'root', true, true);
angular.element(document.getElementById('cru')).scope().alreadyExists(file.name);
//delete file start
$.ajax({
   url: "<?=DIR?>"+"del",
   type: 'post',
   data: {path: "/parablu/"+cloudName+"/sync-upload/Portal/"+Base64.encode(htmlspecialchars_decode(uploadUserName))+"/"+nowtest},
   success: function(response){
// Changing image source when remove
    if(response == 1){
//alert("file deleted successfully");
    }
   }
  });
//delete file end
}else if(response.status == '507') {
$("#filesQueue"+file.id).remove();
if($('div[id ^= "filesQueue"]').length <=0){
// $('#uploadFilesNew1').modal('hide');
 angular.element(document.getElementById('cru')).scope().spaceExceeded(file.name);
// setTimeout(function () { location.reload(); }, 5000);
}
//angular.element(document.getElementById('cru')).scope().updateFileList('root', 'root', true, true);
//delete file start
$.ajax({
   url: "<?=DIR?>"+"del",
   type: 'post',
   data: {path: "/parablu/"+cloudName+"/sync-upload/Portal/"+Base64.encode(htmlspecialchars_decode(uploadUserName))+"/"+nowtest},
   success: function(response){
// Changing image source when remove
    if(response == 1){
//alert("file deleted successfully");
    }
   }
  });
//delete file end
}else if(response.status == '449') {
$("#filesQueue"+file.id).remove();
if($('div[id ^= "filesQueue"]').length <=0){
// $('#uploadFilesNew1').modal('hide');
 angular.element(document.getElementById('cru')).scope().spaceExceededUser(file.name);
// setTimeout(function () { location.reload(); }, 5000);
}
//angular.element(document.getElementById('cru')).scope().updateFileList('root', 'root', true, true);
//delete file start
$.ajax({
   url: "<?=DIR?>"+"del",
   type: 'post',
   data: {path: "/parablu/"+cloudName+"/sync-upload/Portal/"+Base64.encode(htmlspecialchars_decode(uploadUserName))+"/"+nowtest},
   success: function(response){
// Changing image source when remove
    if(response == 1){
//alert("file deleted successfully");
    }
   }
  });
//delete file end
}else{
angular.element(document.getElementById('cru')).scope().uploadFailed(file.name);
$("#filesQueue"+file.id).remove();
uploader1.removeFile(file);
}
                });
        }
});

uploader1.init();
</script>
<script>
$("#closeNewUpload1").click(function() {
uploader.stop();
$('#pickfiles1').show();
var list = document.getElementById("filelist1");
var inner = document.getElementById("fileQueue");
while (list.hasChildNodes()) {

console.log(list.firstChild.id);
    list.removeChild(list.firstChild);
}
$('#uploadFilesNew1').modal('hide');
location.reload();

});
</script>

<style>
#overlayText {
  position: fixed;
  display: none;
  width: 100%;
  height: 100%;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0,0,0,0.5);
  z-index: 1000000000000;
  cursor: pointer;
}
#overlayTextPaste {
  position: fixed;
  display: none;
  width: 100%;
  height: 100%;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background-color: rgba(0,0,0,0.5);
  z-index: 1000000000000;
  cursor: pointer;
}	
</style>
