<?php

use \Core\View;
use \Helpers\Url;
use Core\Language;
use Helpers\Form;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Naveen Verma - naveenverma@parablu.com
 * @version 2.0
 * @date 12/04/19
 * @time 12:38 AM
 * 
 */
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><a href="<?=Url::basePath('settings/office365Settings')?>"><?=$data['crumb1']?></a></li>
                <li><?=$data['crumb2']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='oneDriveController'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;"><?=Language::show('Agent Settings', 'keywords')?></h4>
                    </div>
                    <div class="panel-body table-responsive controllerPanel" >
                       <form class="saveBlukryptSettings" ng-submit="saveBlukryptSettings()" data-parsley-validate>
                            <input type="text" class="hide" value="<?=$data["csrf_token"]?>" name="csrf_token" />
                            <div class="form-group col-lg-6">
                                <label for="host">Host</label>
                                <input type="text" class="form-control" name="host" id="host" value="<?=$data['proxy'][0]->{'host'}?>" placeholder="Enter your host" required autocomplete="off">
                                <span class="help-line text-muted hide">Note:- Enter the complete host URL, example:- http://www.example.com</span>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="port">Port</label>
                                <input type="number" class="form-control" name="port" id="port" value="<?=$data['proxy'][0]->{'port'}?>" placeholder="Enter your Port" required autocomplete="off">
                                <span class="help-line text-muted hide">Note:- Enter the Port number</span>
                            </div>
                            <div class="form-group col-lg-12">
                                <button style="margin-right: 5px;" type="submit" class="btn btn-success pull-right">Save</button>
                            </div>
                        </form> 
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
