<?php
use \Core\View;
use Helpers\Url;
use Helpers\Form;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('report/dashboard')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="ReportController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
            <div class="row">
                <span class="currentPage hide"><?='userBackupHistory'?></span>
                <span class="csrf_token hide"><?=$data['csrf_token'];?></span>
                <div class="panel">
                    <div class="panel-heading"><h3>User information by Device</div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-lg-12">
                                <form class="form-inline" ng-submit="updateDeviceBackupHistory(search.deviceName, search.from, search.to)" data-parsley-validate>
                                    <div class="form-group">
                                        <select class="searchDeviceName" id="deviceName" ng-model="search.deviceName" data-parsley-trigger="change" required></select>
                                    </div>
                                    <div class="form-group">
                                        <label for="from">From Date</label>
                                        <input type="text" class="form-control" id="from" ng-model="search.from" placeholder="From Date" data-parsley-trigger="change" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="to">To Date</label>
                                        <input type="text" class="form-control" value="" id="to" ng-model="search.to" placeholder="To Date" data-parsley-trigger="change" required>
                                    </div>
                                    <button type="submit" class="btn btn-default">Generate Report</button>
                                    <a ng-click="exportToExcel('#DeviceBackupHistory', 'Device Backup History', deviceBackupHistory)" class="btn btn-default">Export To excel</a>
                                </form>
                            </div>
                        </div>
                        <br/>
                        <div class="h4 loading text-center" style="display: none;">Loading.....</div>
                        <table id="DeviceBackupHistory" class="table table-bordered deviceBackupHistory" style="display: none;">
                            <thead>
                                <tr>
                                    <th class="text-center clickAble" ng-click="sortType = 'userName'; sortReverse = !sortReverse">
                                        <?=Language::show('userName', 'keywords')?>
                                        <span ng-show="sortType == 'userName' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'userName' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center clickAble" ng-click="sortType = 'startTime'; sortReverse = !sortReverse">
                                        <?=Language::show('startTime', 'keywords')?>
                                        <span ng-show="sortType == 'startTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'startTime' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center clickAble" ng-click="sortType = 'endTime'; sortReverse = !sortReverse">
                                        <?=Language::show('endTime', 'keywords')?>
                                        <span ng-show="sortType == 'endTime' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'endTime' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                    <th class="text-center clickAble" ng-click="sortType = 'noOfFiles'; sortReverse = !sortReverse">
                                        <?=Language::show('Files Backed Up', 'keywords')?>
                                        <span ng-show="sortType == 'noOfFiles' && !sortReverse" class="fa fa-caret-up"></span>
                                        <span ng-show="sortType == 'noOfFiles' && sortReverse" class="fa fa-caret-down"></span>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr ng-repeat="value in deviceBackupHistory | orderBy:sortType:sortReverse" class="text-center">
                                    <td class="text-center" ng-cloak>{{ value.userName }}</td>
                                    <td ng-cloak>{{ value.startTime }}</td>
                                    <td ng-cloak>{{ value.endTime }}</td>
                                    <td ng-cloak>{{ value.noOfFiles }}</td>
                                </tr>
                            </tbody>
                        </table>
                        <div class="h4 deviceBackupHistoryError text-center" style="display: none">There was no details found for the User Name</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script>
    $('#from').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-1y',
        endDate: '+2y',
        todayHighlight: true
    });
    var currentDate = new Date();
    currentDate.setDate(currentDate.getDate() - 31);
    $('#from').datepicker('update', currentDate);
    $('#to').datepicker({
        format: 'mm/dd/yyyy',
        autoclose: true,
        startDate: '-1y',
        endDate: '+2y',
        todayHighlight: true
    });
</script>
<script src="<?=Url::templatePath()?>js/angular/controllers/ReportController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
    $('.searchDeviceName').select2({
        ajax: {
            url: "<?=DIR?>"+"device/searchDevices",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data, params) {
                params.page = params.page || 1;
                return {
                    results: $.map(data.devices, function (o) {
                        return { id: o.deviceName, text: o.deviceName, img: o.profilePic };
                    }),
                    pagination: {
                        more: (params.page * 30) < data.total_count
                    }
                };
            },
            cache: true
        },
        escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
        minimumInputLength: 0,
        templateResult: selectTemplateResult,
        templateSelection: selectTemplateSelection,
        placeholder: 'Select Device'
    });

    function selectTemplateResult(users){
        if(users.text != undefined){
            var template = "<div class='select2-result-repository clearfix'><div class='select2-result-repository__avatar'>";
            if(users.img){
                template += "<img style='-webkit-border-radius: 50px;-moz-border-radius: 50px;border-radius: 50px;' width='30px' height='30px' src='"+ users.img +"'> ";
            }
            template += users.text + "</div></div>";
            return template;
        }else{
            return "<div class='select2-user-result'>Fetching...</div>";
        }
    }

    function selectTemplateSelection(users){
        return users.text;
    }
</script>
<script>
    $('.select2-container').css({'margin-top': '-9px'});
    $('.select2-container').css({'width': '260px'});
</script>