<?php
namespace Core;

use Helpers\Curl;
use Helpers\MultiCurl;
use Helpers\Api;
use Core\Logger;

/*
 * model - the base model
 *
 * @author David Carr - dave@simplemvcframework.com
 * @version 2.2
 * @date June 27, 2014
 * @date updated May 18 2015
 */

abstract class Model
{
    /**
     * holds the Curl API connection
     * @var object
     */
    protected $curl;

    /**
     * holds the MultiCurl connection
     * @var object
     */
    protected $multiCurl;

    /**
     * holds the Api connection
     * @var object
     */
    protected $api;

    /**
     * create a new instance of the database helper
     */
    public function __construct()
    {
        $this->curl = new Curl();
        $this->multiCurl = new MultiCurl();
        $this->api = new Api();

    }

    /**
     * Below method is used to log things
     *
     * @param $log
     * @param $type
     */
    public function log($log, $type = 'ERROR'){
        $type = strtoupper($type);
        Logger::$type($log);
    }

    public function getStringForGetFromArray($data){
        $string = "";
        foreach ($data as $key => $value) {
            $string .= "&".$key."=".$value;
        }
        $string = substr( $string, 1 );
        return "?".$string;
    }
    
    public function res($response,$resheader,$status){
        $res =array(
                [$response],
                [$resheader],
                [$status]
        );
        if(REQ_RES_LOGS == true){
            $this->log('Response'.json_encode($res),'info');
        }
    }
    
    public function req($url,$header,$data){
        $res =array(
                [$url],
                [$header],
                [$data]
        );
        if(REQ_RES_LOGS == true){
            $this->log('Request'.json_encode($res),'info');
        }
    }

}
