<?php

namespace Controllers;
require_once(DIRECTORY_PATH.'/Helpers/Paraview/Classes/PHPExcel/IOFactory.php');
use Core\View;
use Models\Backup;
use PHPExcel_IOFactory;
use Core\Controller;
use Helpers\Url;
use Helpers\Auth;
use Helpers\Paraview\docReader;
use Helpers\Paraview\docxReader;
use Helpers\Paraview\odtReader;
use Helpers\Paraview\XMLExtractor;
use Models\ParaView;
use Models\Sync;

/*
 * Copyright 2014
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * ParaView controller
 *
 * @author Prashanth Kumar B - prashanth.kumar@parablu.com (Please do not remove this author thing, i worte man, :)
 * @version 2.0
 * @date June 10, 2015
 *
 */

class ParaViewController extends Controller{

    /**
     * Below variable contains the object reference of a model
     * @version 1.0
     * @var object
     */

    protected $_model;

    /**
     * The below variable holds the data of the base path the file location
     * @version 1.0
     * @var string
     */
    var $filePath = PARAVIEW_TMP_PATH;

    /**
     * Add the extension that you want to support for viewing
     * @version 1.0
     * @var array
     */
    var $allowedExtensions = array('pdf', 'docx', 'odt', 'txt', 'xls','xlsx', 'ods', 'pptx', 'ppt', 'doc');

    /**
     * Add the extension that you want to support for viewing
     * @version 1.0
     * @var array
     */
    var $allowedImageExtensions = array('png', 'jpg', 'jpeg', 'gif', 'tiff', 'TIF', 'tif');

    /**
     * Add the extension that you want to support for viewing
     * @version 1.0
     * @var array
     */
    var $allowedVideoExtensions = array('mp4', 'avi', 'webm', 'ogg');

    /**
     * Call the parent construct
     */
    public function __construct(){
        parent::__construct();
        if(SHARE_LOGIN_CHECK) {
            $this->auth->loginCheck();
        }
        $this->auth->tokenCheck();
        $this->language->load('index');
        $this->_model = new ParaView();
    }

    /**
     * Below function will load appropriate function according
     * to the extension of the file
     */
    public function reader(){
        if(!empty($_POST['fileName']) && !empty($_POST['path'])) {
            $headers = array(
                'Content-Type' => 'application/xml',
                'Accept' => 'application/xml',
                'Accept-Charset' => 'utf-8',
                'token' => $this->session->get('token'),
                'path' => $_POST['path'].$_POST['fileName'],
		'fileRevisionId' => $_POST['fileRevisionId']
            );

            $sync = new Sync();
            $result = $sync->getFileInfo($headers);

            switch ($result['status']) {
                case (200):
//$_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
			    $_POST['fileName'] = str_replace(' ', '-', $_POST['fileName']);
                    $_POST['fileName'] = preg_replace("/[^a-z0-9\_\-\.]/i", '', $_POST['fileName']);
		    $t=time();
                    $_POST['fileName'] = $t.$_POST['fileName'];
                    $fileArray = explode('.', $_POST['fileName']);
                    list($extension) = array_reverse($fileArray);
                    $extension = strtolower($extension);
                    $fullPath = $this->filePath;
                    $this->cleanUpTempDirectory($fullPath);

                    $headers['file-name'] = (string)$result['body']->{'file-name'};
                    $headers['file-path'] = rtrim($_POST['path'], '/');
                    $headers['userName'] = $this->session->get('userName');
                    $headers['syncRevisionId'] = (string)$result['body']->{'file-revision-id'};
                    $headers['blukryptIp'] = $_POST['blukryptIp'];

                    $fileContent = $sync->download($headers);

                    if($fileContent['status'] != 200){
                        echo json_encode(array(
                            'result' => 'fail',
                            'msg' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                        ));
                        exit;
                    }

                    //$fileFullPath   = $fullPath.ltrim($result['body']->{'file-name'}, DS);
			    $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
                    $myFile = fopen($fileFullPath, "w");
                    if(!$myFile){
                        die("Unable to open file!");
                    }
                    $txt = $fileContent['body'];
                    fwrite($myFile, $txt);
                    fclose($myFile);

                    if(in_array($extension, $this->allowedImageExtensions)) {

                        $this->sendImageData($_POST['fileName']);

                    }elseif(in_array($extension, $this->allowedVideoExtensions)) {

                        $this->sendVideoData($_POST['fileName']);

                    }elseif(in_array($extension, $this->allowedExtensions)) {

                        if(method_exists($this, $extension)){

                            $this->$extension();

                        }else{
                            $data = array(
                                'result' => 'fail',
                                'msg' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                            );
                            $jsonDoc = json_encode($data);
                            echo $jsonDoc;
                            exit;
                        }
                    }else{
                        $data = array(
                            'result' => 'fail',
                            'msg' => 'Selected file format is not supported'
                        );
                        $jsonDoc = json_encode($data);
                        echo $jsonDoc;
                        exit;
                    }
                    break;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'No file was passed to view'
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }

    /**
     * Below function will load appropriate function according
     * to the extension of the file
     */
    public function backupReader(){
        if(!empty($_POST['fileName']) && !empty($_POST['filePath'])) {
            $backup = new Backup();
            $result['status'] = 200;
            switch ($result['status']) {
                case (200):
		    //$_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
			    $_POST['fileName'] = str_replace(' ', '-', $_POST['fileName']);
                    $_POST['fileName'] = preg_replace("/[^a-z0-9\_\-\.]/i", '', $_POST['fileName']);
		    $t=time();
                    $_POST['fileName'] = $t.$_POST['fileName'];
                    $fileArray = explode('.', $_POST['fileName']);
                    list($extension) = array_reverse($fileArray);
                    $extension = strtolower($extension);
                    $fullPath = $this->filePath;
                    $this->cleanUpTempDirectory($fullPath);

                    $file['fileName'] = base64_encode($_POST['fileName']);
                    $file['filePath'] = base64_encode(rtrim($_POST['filePath'], '/'));
                    $file['userName'] = base64_encode($_POST['userName']);
		    $file['loginUserName'] = base64_encode($_POST['userName']);
                    $file['backupID'] = $_POST['backupId'];
		    $file['deviceUUID'] = $_POST['deviceUUID'];
                    //$file['deviceUUID'] = "";
                    $file['isSync'] = $_POST['isSync'];
                    $file['cloudName'] = $this->session->get("cloudName");
		    $file['blukryptIp'] = $_POST['blukryptIp'];
                    $fileContent = $backup->download($file);

                    if($fileContent['status'] != 200){
                        echo json_encode(array(
                            'result' => 'fail',
                            'msg' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                        ));
                        exit;
                    }

                    $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
                    $myFile = fopen($fileFullPath, "w");
                    if(!$myFile){
                        die("Unable to open file!");
                    }
                    $txt = $fileContent['body'];
                    fwrite($myFile, $txt);
                    fclose($myFile);

                    if(in_array($extension, $this->allowedImageExtensions)) {

                        $this->sendImageData($_POST['fileName']);

                    }elseif(in_array($extension, $this->allowedVideoExtensions)) {

                        $this->sendVideoData($_POST['fileName']);

                    }elseif(in_array($extension, $this->allowedExtensions)) {

                        if(method_exists($this, $extension)){

                            $this->$extension();

                        }else{
                            $data = array(
                                'result' => 'fail',
                                'msg' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                            );
                            $jsonDoc = json_encode($data);
                            echo $jsonDoc;
                            exit;
                        }
                    }else{
                        $data = array(
                            'result' => 'fail',
                            'msg' => 'Selected file format is not supported'
                        );
                        $jsonDoc = json_encode($data);
                        echo $jsonDoc;
                        exit;
                    }
                    break;
                case (421):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('421')
                    );
                    echo json_encode($result);
                    exit();
                case (500):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('500')
                    );
                    echo json_encode($result);
                    exit();
                case (0):
                    $result = array(
                        'result' => 'fail',
                        'msg' => $this->language->get('0')
                    );
                    echo json_encode($result);
                    exit();
                default:
                    $result = array(
                        'result' => 'fail',
                        'code' => $result,
                        'msg' => $this->language->get('default')
                    );
                    echo json_encode($result);
                    exit();
            }

        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'No file was passed to view'
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }

    /**
     * Below function will load appropriate function according
     * to the extension of the file
     */
    public function sharedFileReader(){
        if(!empty($_POST['path']) && !empty($_POST['fileName']) && !empty($_POST['userName']) && !empty($_POST['syncRevisionId'])){
            //$_POST['fileName'] = urldecode($_POST['fileName']);
	//$_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
		$_POST['fileName'] = str_replace(' ', '-', $_POST['fileName']);
                    $_POST['fileName'] = preg_replace("/[^a-z0-9\_\-\.]/i", '', $_POST['fileName']);
		    $t=time();
                    $_POST['fileName'] = $t.$_POST['fileName'];
            $checkForShareWith = !empty($_POST['shareWith']) ? true : false;

	     if($_POST['passwordProtected'] == 'enabled' && $checkForShareWith == false){
            //if($this->session->get('passwordProtected') == true && $checkForShareWith == false){
                if(!empty($_POST['password'])){
		    if($_POST['passwordHash'] != md5($_POST['password'])){
                    //if($this->session->get('passwordHash') != md5($_POST['password'])){
                        echo json_encode(array(
                            'result' => 'fail',
                            'message' => 'Password Authentication Failed'
                        ));
                        exit;
                    }
                }else{
                    echo json_encode(array(
                        'result' => 'fail',
                        'message' => 'Password Authentication Failed'
                    ));
                    exit;
                }
            }
            $fileArray = explode('.', $_POST['fileName']);
            list($extension) = array_reverse($fileArray);
            $extension = strtolower($extension);
            $fullPath = $this->filePath;
            $this->cleanUpTempDirectory($fullPath);

            $headers['file-name'] = base64_encode($_POST['fileName']);
            $headers['file-path'] = base64_encode(rtrim($_POST['path'], '/'));
            $headers['userName'] = $_POST['userName'];
            $headers['syncRevisionId'] = $_POST['syncRevisionId'];
	    $headers['cloudName'] = $_POST['cloudName'];
            $sync = new Sync();
            $fileContent = $sync->downloadShare($headers);

            if($fileContent['status'] != 200){
                echo json_encode(array(
                    'result' => 'fail',
                    'message' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                ));
                exit;
            }

            $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
            $myFile = fopen($fileFullPath, "w");
            if(!$myFile){
                die("Unable to open file!");
            }
            $txt = $fileContent['body'];
            fwrite($myFile, $txt);
            fclose($myFile);

            if(in_array($extension, $this->allowedImageExtensions)) {

                $this->sendImageData($_POST['fileName']);

            }elseif(in_array($extension, $this->allowedVideoExtensions)) {

                $this->sendVideoData($_POST['fileName']);

            }elseif(in_array($extension, $this->allowedExtensions)) {

                if(method_exists($this, $extension)){
		    if($extension == 'pdf'){
		    	$extension = 'pdfForShare';
		    }
                    $this->$extension();

                }else{
                    $data = array(
                        'result' => 'fail',
                        'message' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                    );
                    $jsonDoc = json_encode($data);
                    echo $jsonDoc;
                    exit;
                }
            }else{
                $data = array(
                    'result' => 'fail',
                    'message' => 'Selected file format is not supported'
                );
                $jsonDoc = json_encode($data);
                echo $jsonDoc;
                exit;
            }

        }else{
            $data = array(
                'error' => 'No file was passed to view',
                'data' => $_POST
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }

    /**
     * Below function will load appropriate function according
     * to the extension of the file
     */
    public function sharedBackupFileReader(){
        if(!empty($_POST['path']) && !empty($_POST['fileName']) && !empty($_POST['userName']) && !empty($_POST['backupID'])){
            //$_POST['fileName'] = urldecode($_POST['fileName']);
            //$_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
		$_POST['fileName'] = str_replace(' ', '-', $_POST['fileName']);
                    $_POST['fileName'] = preg_replace("/[^a-z0-9\_\-\.]/i", '', $_POST['fileName']);
		    $t=time();
                    $_POST['fileName'] = $t.$_POST['fileName'];

            $checkForShareWith = !empty($_POST['shareWith']) ? true : false;

	    if($_POST['passwordProtected'] == 'enabled' && $checkForShareWith == false){
            //if($this->session->get('passwordProtected') == true && $checkForShareWith == false){
                if(!empty($_POST['password'])){
		    if($_POST['passwordHash'] != md5($_POST['password'])){
                    //if($this->session->get('passwordHash') != md5($_POST['password'])){
                        echo json_encode(array(
                            'result' => 'fail',
                            'message' => 'Password Authentication Failed'
                        ));
                        exit;
                    }
                }else{
                    echo json_encode(array(
                        'result' => 'fail',
                        'message' => 'Password Authentication Failed'
                    ));
                    exit;
                }
            }
            $fileArray = explode('.', $_POST['fileName']);
            list($extension) = array_reverse($fileArray);
            $extension = strtolower($extension);
            $fullPath = $this->filePath;
            $this->cleanUpTempDirectory($fullPath);

            $file['fileName'] = base64_encode($_POST['fileName']);
            $file['filePath'] = base64_encode(rtrim($_POST['path'], '/'));
            $file['userName'] = base64_encode($_POST['userName']);
	    $file['loginUserName'] = base64_encode($_POST['userName']);
            $file['backupID'] = $_POST['backupID'];
            $file['deviceUUID'] = "";
            $file['isSync'] = $_POST['isSync'];
            //$file['cloudName'] = $this->session->get("cloudName");
	    $file['cloudName'] = $_POST['cloudName'];
            $backup = new Backup();
            $fileContent = $backup->downloadShare($file);

            if($fileContent['status'] != 200){
                echo json_encode(array(
                    'result' => 'fail',
                    'message' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                ));
                exit;
            }

            $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
            $myFile = fopen($fileFullPath, "w");
            if(!$myFile){
                die("Unable to open file!");
            }
            $txt = $fileContent['body'];
            fwrite($myFile, $txt);
            fclose($myFile);

            if(in_array($extension, $this->allowedImageExtensions)) {

                $this->sendImageData($_POST['fileName']);

            }elseif(in_array($extension, $this->allowedVideoExtensions)) {

                $this->sendVideoData($_POST['fileName']);

            }elseif(in_array($extension, $this->allowedExtensions)) {

                if(method_exists($this, $extension)){
		    if($extension == 'pdf'){
		    	$extension = 'pdfForShare';
		    }
                    $this->$extension();

                }else{
                    $data = array(
                        'result' => 'fail',
                        'message' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                    );
                    $jsonDoc = json_encode($data);
                    echo $jsonDoc;
                    exit;
                }
            }else{
                $data = array(
                    'result' => 'fail',
                    'message' => 'Selected file format is not supported'
                );
                $jsonDoc = json_encode($data);
                echo $jsonDoc;
                exit;
            }

        }else{
            $data = array(
                'error' => 'No file was passed to view',
                'data' => $_POST
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }

    /**
     * Below function will paraview only docx formats
     */
    /*public function docx(){
        if(!empty($_POST['fileName'])) {
            if(file_exists($this->filePath . $_POST['fileName'])) {
                $extract = new DocxReader();
                $extract->docxPath = $this->filePath.$_POST['fileName'];
                $extract->content_folder = 'temp';
                $extract->image_max_width = '10000';
                $extract->imagePathPrefix = Url::basePath('');
                $extract->keepOriginalImage = true;
                $extract->Init();
                $doc = str_replace('<p>Â&nbsp;</p>', ' ', $extract->output);
                $jsonDoc = json_encode($doc);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }*/

    /**
     * Below function will paraview only odt formats
     */
    public function odt(){
        if(!empty($_POST['fileName'])) {
            if(file_exists($this->filePath . $_POST['fileName'])) {
                $extract = new OdtReader();
                $extract->odtPath = $this->filePath . $_POST['fileName'];
                $extract->content_folder = 'temp';
                $extract->image_max_width = '10000';
                $extract->imagePathPrefix = '';
                $extract->keepOriginalImage = true;
                $extract->Init();
                $doc = str_replace('<p>Â&nbsp;</p>', ' ', $extract->output);
                $doc['type'] = 'odt';
                $jsonDoc = json_encode($doc);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }

    /**
     * Below function will read only pdf formats
     * #toolbar=0 Add this to iframe url after file url to disable toolbar for pdf viewer
     */	
    public function pdf(){
        if(!empty($_POST['fileName'])) {
            if(file_exists($this->filePath . $_POST['fileName'])) {
                $data = array(
                    'html' => '<iframe seamless="" style="margin-top: -50px;" width="100%" height="600px" src="'.Url::basePath().'app/templates/default/documents/'.$_POST['fileName'].'"></iframe>',
                    'type' => 'pdf'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }
	
    public function pdfForShare(){
        if(!empty($_POST['fileName'])) {
            if(file_exists($this->filePath . $_POST['fileName'])) {
                $data = array(
                    'html' => '<iframe seamless="" style="margin-top: -50px;" width="100%" height="600" src="'.Url::basePath('pdfViewer?').'file=app/templates/default/documents/'.$_POST['fileName'].'"></iframe>',
                    'type' => 'pdf'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }

    public function pdfViewer(){
        View::render('paraview/pdf');
    }

    /**
     * below function excepts $filename a parameter
     * generates a link to view that file
     * @param $fileName
     */
    public function sendImageData($fileName){
        if(!empty($fileName)) {
            $_POST['fileName'] = rawurlencode(html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5));
            if(file_exists($this->filePath . $fileName)) {
                $data = array(
                    'html' => '<img style="max-height: 500px" src="'.Url::templatePath('default/documents/'.$_POST['fileName']).'">',
		    'fileName' => Url::templatePath('default/documents/'.$_POST['fileName']),
                    'type' => 'image'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }

    /**
     * below function excepts $filename a parameter
     * generates a link to view that video file
     * @param $fileName
     */
    public function sendVideoData($fileName){
        if(!empty($fileName)) {
            $_POST['fileName'] = rawurlencode(html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5));
            if(file_exists($this->filePath . $fileName)) {
                $finfo = finfo_open(FILEINFO_MIME_TYPE);
                $mimeType = finfo_file($finfo, $this->filePath . $fileName);
                finfo_close($finfo);
                $data = '<video height="500" controls>';
                $data .= '<source src="'.Url::templatePath('default/documents/'.$_POST['fileName']).'" type="'.$mimeType.'">';
                $data .= "I'm sorry; your browser doesn't support HTML5 video in WebM with VP8 or MP4 with H.264.";
                $data .= '</video>';
                $data = array(
                    'html' => $data,
                    'type' => 'image'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }

    /*public function xls(){
        if(empty($_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            echo json_encode($data);
            exit;
        }
        if(!file_exists($this->filePath.$_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found'
            );
            echo json_encode($data);
            exit;
        }

        $objPHPExcel = PHPExcel_IOFactory::load($this->filePath.$_POST['fileName']);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                $rowData = array();
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'
                    );
                }
                array_push($data, $rowData);
            }
            array_push($pageWiseData, $data);
        }
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        foreach($pageWiseData as $pageKey => $pageData){
            $sheetName = $sheets[$pageKey];
            $htmlData = '<table id="customers">';
            foreach($pageData as $rowData){
                $htmlData .= '<tr>';
                if(!empty($rowData[0])) {
                    foreach ($rowData[0] as $value) {
                        $htmlData .= '<td style="'.$this->convertArrayToStylesString($rowData['styles']).'">' . $value . '</td>';
                    }
                }else{

                    $htmlData .= '<td></td>';
                }
                $htmlData .= '</tr>';
            }
            $htmlData .= '</table><br/>';
            $sheetId = strtolower($sheetName);
            $sheetId = str_replace(' ', '_', $sheetId);
            $html[$pageKey] = array(
                'sheetName' => $sheetName,
                'id' => $sheetId,
                'html' => $htmlData
            );

        }
        $data = array(
            'type' => 'excel',
            'html' => array_values($html)
        );
        echo json_encode($data);
    }

    public function xlsx(){
        if(empty($_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            echo json_encode($data);
            exit;
        }
        if(!file_exists($this->filePath.$_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found'
            );
            echo json_encode($data);
            exit;
        }
        $objPHPExcel = PHPExcel_IOFactory::load($this->filePath.$_POST['fileName']);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                $rowData = array();
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'

                    );
                }
                array_push($data, $rowData);
            }
            array_push($pageWiseData, $data);
        }
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        foreach($pageWiseData as $pageKey => $pageData){
            $sheetName = $sheets[$pageKey];
            $htmlData = '<table id="customers">';
            foreach($pageData as $rowData){
                $htmlData .= '<tr>';
                if(!empty($rowData[0])) {
                    foreach ($rowData[0] as $value) {
                        $htmlData .= '<td style="'.$this->convertArrayToStylesString($rowData['styles']).'">' . $value . '</td>';
                    }
                }else{

                    $htmlData .= '<td></td>';
                }
                $htmlData .= '</tr>';
            }
            $htmlData .= '</table><br/>';
            $sheetId = strtolower($sheetName);
            $sheetId = str_replace(' ', '_', $sheetId);
            $html[$pageKey] = array(
                'sheetName' => $sheetName,
                'id' => $sheetId,
                'html' => $htmlData
            );

        }
        $data = array(
            'type' => 'excel',
            'html' => array_values($html)
        );
        echo json_encode($data);
    }*/

    public function ods(){
        if(empty($_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            echo json_encode($data);
            exit;
        }
        if(!file_exists($this->filePath.$_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found'
            );
            echo json_encode($data);
            exit;
        }

        $objPHPExcel = PHPExcel_IOFactory::load($this->filePath.$_POST['fileName']);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                $rowData = array();
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'

                    );
                }
                array_push($data, $rowData);
            }
            array_push($pageWiseData, $data);
        }
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        foreach($pageWiseData as $pageKey => $pageData){
            $sheetName = $sheets[$pageKey];
            $htmlData = '<table id="customers">';
            foreach($pageData as $rowData){
                $htmlData .= '<tr>';
                if(!empty($rowData[0])) {
                    foreach ($rowData[0] as $value) {
                        $htmlData .= '<td style="'.$this->convertArrayToStylesString($rowData['styles']).'">' . $value . '</td>';
                    }
                }else{
                    $htmlData .= '<td></td>';
                }
                $htmlData .= '</tr>';
            }
            $htmlData .= '</table><br/>';
            $sheetId = strtolower($sheetName);
            $sheetId = str_replace(' ', '_', $sheetId);
            $html[$pageKey] = array(
                'sheetName' => $sheetName,
                'id' => $sheetId,
                'html' => $htmlData
            );

        }
        $data = array(
            'type' => 'excel',
            'html' => array_values($html)
        );
        echo json_encode($data);
    }

    public function convertArrayToStylesString($style){
        $string = '';
        if(is_array($style)){
            foreach($style as $key => $value){
                $string .= $key . ': ' . $value . ';';
            }
            return $string;
        }else{
            return '';
        }

    }

    /*public function txt(){
        $fileName = $_POST['fileName'];
        if(!empty($fileName)) {
            if(file_exists($this->filePath.$fileName)) {
                $data = array(
                    'html' => file_get_contents($this->filePath.$fileName),
                    'type' => 'text'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
        exit;
    }

    public function doc(){
        $fileName = $_POST['fileName'];
        if(!empty($fileName)) {
            if(file_exists($this->filePath.$fileName)) {
                $data = array(
                    'html' => nl2br(file_get_contents($this->filePath.$fileName)),
                    'type' => 'text'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }*/

    public function cleanUpTempDirectory($fullPath){
        $files = glob($fullPath.DS.'{,.}*', GLOB_BRACE);
        foreach($files as $file){
            if(is_file($file)){
                unlink($file);
            }
        }
    }

    public function readFileFromUpload($fileName){
        if(empty($fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            return json_encode($resultData);
        }
        if(!file_exists($this->filePath.$fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found' .$this->filePath.$fileName
            );
            return json_encode($resultData);
        }

        $objPHPExcel = PHPExcel_IOFactory::load($this->filePath.$fileName);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        $data = array();
        $username = array();
        $test = array();
        $rowData = array();
        $sheet1 = $objPHPExcel->getSheet(0);
        $highestColumn1 = $sheet1->getHighestColumn();
            $highestRow1 = $sheet1->getHighestRow();
            $row1 = $objPHPExcel->getActiveSheet()->getCell('A2')->getRow();
            $this->log('Result_row1: '.json_encode($row1), 'info');
            $this->log('Result_highestColumn1111: '.json_encode($highestColumn1), 'info');
            $this->log('Result_highestRow1111: '.json_encode($highestRow1), 'info');
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'
                    );
                }
                $rowData = array_map('array_filter', $rowData);
                if (!in_array(null, $rowData)) {
                array_push($data, $rowData);
                }
            }
            array_push($pageWiseData, $data);
        }
        
        
        $pageWiseData = array_unique($pageWiseData);
        $this->log('Result_Test11: '.json_encode($test), 'info');
        $this->log('Result_PagewiseData: '.json_encode($pageWiseData), 'info');
        $this->log('Result_PagewiseData0000: '.json_encode($pageWiseData[0]), 'info');
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();

        foreach($pageWiseData as $pageKey => $pageData){
            $this->log('Result_$1111: ', 'info');
        foreach($pageData as $rowDatar){
            $this->log('Result_$2222: ', 'info');
                if(!empty($rowDatar[0])) {
                    foreach( $rowDatar[0] as $key => $value ) {
                        
                        if($value == 'userName'){
                            $userNameColumnNumber = $key;
                        }
                                            
                    }
                    
                }
            }   
        }
        
$this->log('CAUTCH KEY FOR userNameColumnNumber COLUMN: '.$userNameColumnNumber, 'info');


foreach($pageWiseData as $pageKey => $pageData){
            $this->log('Result_$1111: ', 'info');
        foreach($pageData as $rowDatar){
            $this->log('Result_$2222: ', 'info');
                if(!empty($rowDatar[0])) {
                    foreach( $rowDatar[0] as $key => $value ) {
                        $this->log('KEY : '.$key.' : VALUE : '.$value, 'info');
                        
                        if($key === $userNameColumnNumber && $value != ''){
                        $data = (string)$value;
                        }
                        $username = array_merge(array($data), $username);
                                           
                    }
                }
            }
            
        }
$username = array_keys(array_flip($username));
$this->log('NEEEEEEEEEEEEEEE: '.json_encode($username), 'info');

        $html[$pageKey] = array(
                'sheetName' => $sheetName,
                'id' => $sheetId,
                'userNames' => $username
            );
        $resultData = array(
            'result' => 'success',
            'data' => array_values($html)
        );//$this->log('Result_resultDatahhh: '.json_encode($resultData), 'info');
        return json_encode($resultData);
    }


public function readFileFromUploadForDevices($fileName){
        if(empty($fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            return json_encode($resultData);
        }
        if(!file_exists($this->filePath.$fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found' .$this->filePath.$fileName
            );
            return json_encode($resultData);
        }

        $objPHPExcel = PHPExcel_IOFactory::load($this->filePath.$fileName);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        $data = array();
        $rowData = array();
        $data = array();
        $sheet1 = $objPHPExcel->getSheet(0);
        $highestColumn1 = $sheet1->getHighestColumn();
            $highestRow1 = $sheet1->getHighestRow();
            $row1 = $objPHPExcel->getActiveSheet()->getCell('A2')->getRow();
            $this->log('Result_row1: '.json_encode($row1), 'info');
            $this->log('Result_highestColumn1111: '.json_encode($highestColumn1), 'info');
            $this->log('Result_highestRow1111: '.json_encode($highestRow1), 'info');
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                //$rowData = array();
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
		if($rowData[0][0] != ''){
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'
                    );
		}
                }
                $rowData = array_map('array_filter', $rowData);
                if (!in_array(null, $rowData) || !in_array($data, $rowData)) {
                array_push($data, $rowData);


                }
                 $this->log('Result_xxxxxxxgggggggggg: '.json_encode($data), 'info');
                
            }
            array_push($pageWiseData, $data);
        }
    
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        $combined = [];
        $odd = array();
            $even = array();
        $this->log('Result_$pageWiseData: '.json_encode($pageWiseData), 'info');

// -------------------------------------------------------------------------------------
foreach($pageWiseData as $pageKey => $pageData){
            $this->log('Result_$1111: ', 'info');
        foreach($pageData as $rowDatar){
            $this->log('Result_$2222: ', 'info');
                if(!empty($rowDatar[0])) {
                    foreach( $rowDatar[0] as $key => $value ) {
                        if($value == 'deviceName'){
                            $deviceNameColumnNumber = $key;
                        }
                        if($value == 'userName'){
                            $userNameColumnNumber = $key;
                        }
                    }
                    
                }
            }   
        }
        $this->log('CAUTCH KEY FOR deviceName COLUMN: '.$deviceNameColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR userNameColumnNumber COLUMN: '.$userNameColumnNumber, 'info');
foreach($pageWiseData as $pageKey => $pageData){
                    $this->log('Result_$1111: ', 'info');
                foreach($pageData as $rowDatar){
                    $this->log('Result_$2222: ', 'info');
                        if(!empty($rowDatar[0])) {
                            foreach( $rowDatar[0] as $key => $value ) {
                                $this->log('KEY : '.$key.' : VALUE : '.$value, 'info');
                                if($key === $deviceNameColumnNumber && $value !== ''){
                                    $this->log('CCCCCCCCCCAAAAAAAAAAMMMMMMMEE : ', 'info');
                                $deviceName[]['deviceName'] = $value;
                                }
                                if($key === $userNameColumnNumber && $value !== ''){
                                $userName[]['userName'] = $value;
                                }
                            }
                        }
                }
                    
        }
        
        $this->log('Result_DEVICENAMEEEEEE: '.json_encode($deviceName), 'info');
        $this->log('Result_USERNAMEEEEEEEE: '.json_encode($userName), 'info');
function unique_key($array,$keyname){

 $new_array = array();
 foreach($array as $key=>$value){

   if(!isset($new_array[$value[$keyname]])){
     $new_array[$value[$keyname]] = $value;
   }

 }
 $new_array = array_values($new_array);
 return $new_array;
}
$this->log('Result_USERNAMEEEEEEEE_newone: '.json_encode(unique_key($userName,'userName')), 'info');
$this->log('Result_DEVICENAMEEEEEE_COUNT: '.count($deviceName), 'info');
        $this->log('Result_USERNAMEEEEEEEE_COUNT: '.count($userName), 'info');
//$userName = unique_key($userName,'userName');
if(count($deviceName) != count($userName)){
$resultData1 = array(
            'result' => 'fail_samecolumn',
            'msg' => 'fileds missing'
        );
        return json_encode($resultData1);
}
for($i=1;$i<sizeof($deviceName);$i++){
                    if(count($userName) !=0 && count($deviceName) !=0 ){
                        $bigDog[] = array_merge($userName[$i],$deviceName[$i]);
                    }
                    if(count($userName) ==0 && count($deviceName) !=0 ){
$bigDog[] = array_merge($deviceName[$i]);
                    }
                    if(count($userName) !=0 && count($deviceName) ==0 ){
$bigDog[] = array_merge($userName[$i]);
                    }
                    if(count($userName) ==0 && count($deviceName) ==0 ){
$bigDog[] = array_merge($userName[$i],$deviceName[$i]);
                    }

                }
$this->log('Result_BBBBBBBIIIIIIIIIGGGGGGGGG: '.json_encode($bigDog), 'info');
if(count($userName)-1 == 0){
$resultData1 = array(
            'result' => 'fail_usernames',
            'msg' => 'usernames missing'
        );
        return json_encode($resultData1);

}
if(count($deviceName)-1 == 0){
$resultData1 = array(
            'result' => 'fail_devicenames',
            'msg' => 'devicenames missing'
        );
        return json_encode($resultData1);
}

// -------------------------------------------------------------------------------------
        
                $new = array('deviceList' => $bigDog);
        
        
        foreach($pageWiseData as $pageKey => $pageData){
            $sheetName = $sheets[$pageKey];
            $this->log('Result_pagekey: '.json_encode($pageKey), 'info');
            $this->log('Result_: '.json_encode($pageData), 'info');
            $htmlData = [];
            
            
            foreach($pageData as $rowData){
                if(!empty($rowData[0])) {
                    foreach ($rowData[0] as $value) {
                        $data = $value;
                        //$this->log('Result_data: '.$data, 'info');
                    }
                    $this->log('Result_datassssssssss: '.$data, 'info');
                    $htmlData = array_merge(array($data), $htmlData);
                }
            }
            
            
                
            $sheetId = strtolower($sheetName);
            $sheetId = str_replace(' ', '_', $sheetId);
            $html[$pageKey] = array(
                'sheetName' => $sheetName,
                'id' => $sheetId,
                'userNames' => $htmlData
            );
        }
        
        
        
        $resultData = array(
            'result' => 'success',
            'data' => array_values($html),
            'deviceList' => $new
        );$this->log('Result_resultDatahhh: '.json_encode($resultData), 'info');
        return json_encode($resultData);
    }

    public function readFileFromUploadForCreateUsers($fileName){
        if(empty($fileName) || !file_exists($this->filePath.$fileName)) {
        if(empty($fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
        }
        if(!file_exists($this->filePath.$fileName)) {
            $resultData = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found' .$this->filePath.$fileName
            );
        }
        return json_encode($resultData);
    }

        $objPHPExcel = PHPExcel_IOFactory::load($this->filePath.$fileName);
        $count = $objPHPExcel->getSheetCount();
        $pageWiseData = array();
        $data = array();
        $rowData = array();
        $data = array();
        $sheet1 = $objPHPExcel->getSheet(0);
        $highestColumn1 = $sheet1->getHighestColumn();
            $highestRow1 = $sheet1->getHighestRow();
            $row1 = $objPHPExcel->getActiveSheet()->getCell('A2')->getRow();
            $this->log('Result_row1: '.json_encode($row1), 'info');
            $this->log('Result_highestColumn1111: '.json_encode($highestColumn1), 'info');
            $this->log('Result_highestRow1111: '.json_encode($highestRow1), 'info');
        for($i = 0; $i < $count; $i++) {
            $sheet = $objPHPExcel->getSheet($i);
            $highestColumn = $sheet->getHighestColumn();
            $data = array();
            foreach ($sheet->getRowIterator() as $row) {
                //$rowData = array();
                foreach ($row->getCellIterator() as $cell) {
                    $cord = $cell->getCoordinate();
                    $rowData = $sheet->rangeToArray('A' . $row->getRowIndex() . ':' . $highestColumn . $row->getRowIndex(), NULL, TRUE, FALSE);
                    $align = $objPHPExcel->getActiveSheet()->getStyle($cord)->getAlignment()->getHorizontal();
                    $fontBold = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getBold();
                    $fontStyle = $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getItalic();
                    $rowData['styles'] = array(
                        'text-align' => ($align == 'general') ? 'left':$align,
                        'font' => $objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getName(),
                        'font-weight' => (!empty($fontBold) && $fontBold == 1) ? 'bold' : 'normal',
                        'font-color' => '#'.$objPHPExcel->getActiveSheet()->getStyle($cord)->getFont()->getColor()->getRGB(),
                        'font-style' => (!empty($fontStyle) && $fontStyle == 1) ? 'italic' : 'none'
                    );
                }
                $rowData = array_map('array_filter', $rowData);
                if (!in_array(null, $rowData)) {
                array_push($data, $rowData);
                }
                 $this->log('Result_xxxxxxxgggggggggg: '.json_encode($data), 'info');
                
            }
            array_push($pageWiseData, $data);
        }
        
        
        
        $sheets = $objPHPExcel->getSheetNames();
        $html = array();
        $combined = [];
        $odd = array();
        $even = array();
        $emailId = array();
        $username = array();
        $password = array();
        $displayname = array();
        $department = array();
        $location = array();
        $policyname = array();
        $syncPolicyName = array();
        $o365PolicyName = array();
        $odbId = array();

        $this->log('Result_$pageWiseData: '.json_encode($pageWiseData), 'info');
        
        foreach($pageWiseData as $pageKey => $pageData){
            $this->log('Result_$1111: ', 'info');
        foreach($pageData as $rowDatar){
            $this->log('Result_$2222: ', 'info');
                if(!empty($rowDatar[0])) {
                    foreach( $rowDatar[0] as $key => $value ) {
                        if($value == 'emailId'){
                            $emailIdColumnNumber = $key;
                        }
                        if($value == 'userName'){
                            $userNameColumnNumber = $key;
                        }
                        if($value == 'password'){
                            $passwdHashColumnNumber = $key;
                        }
                        if($value == 'displayName'){
                            $displayNameColumnNumber = $key;
                        }
                        if($value == 'department'){
                            $departmentColumnNumber = $key;
                        }
                        if($value == 'location'){
                            $locationColumnNumber = $key;
                        }
                        if($value == 'backup policy name'){
                            $policyNameColumnNumber = $key;
                        }
                        if($value == 'sync policy name'){
                            $syncPolicyNameColumnNumber = $key;
                        }
                        if($value == 'o365 policy name'){
                            $o365PolicyNameColumnNumber = $key;
                        }
                        if($value == 'odbLoginId'){
                            $odbLoginIdColumnNumber = $key;
                        }                        
                    }
                    
                }
            }   
        }
        $this->log('Result_CCCCCCCCOOOOOUUUUNNNNTTTT : '.count($rowDatar[0]), 'info');
        $this->log('Result_CCCCCCCCOOOOOUUUUNNNNTTTT : '.count($rowDatar[0]), 'info');
        $this->log('CAUTCH KEY FOR emailId COLUMN: '.$emailIdColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR userNameColumnNumber COLUMN: '.$userNameColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR passwdHashColumnNumber COLUMN: '.$passwdHashColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR displayNameColumnNumber COLUMN: '.$displayNameColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR departmentColumnNumber COLUMN: '.$departmentColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR locationColumnNumber COLUMN: '.$locationColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR policyNameColumnNumber COLUMN: '.$policyNameColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR syncPolicyNameColumnNumber COLUMN: '.$syncPolicyNameColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR o365PolicyNameColumnNumber COLUMN: '.$o365PolicyNameColumnNumber, 'info');
        $this->log('CAUTCH KEY FOR odbLoginIdColumnNumber COLUMN: '.$odbLoginIdColumnNumber, 'info');

        foreach($pageWiseData as $pageKey => $pageData){
                    $this->log('Result_$1111: ', 'info');
                foreach($pageData as $rowDatar){
                    $this->log('Result_$2222: ', 'info');
                        if(!empty($rowDatar[0])) {
                            for($k=0;$k< 10;$k++){
                                $this->log('NEEEEEEEWWWWWWWWW COUNT : '.$k, 'info');
                                $this->log('NEEEEEEE COUNT : '.$rowDatar[0][$k], 'info');
                                
                                if($k === $emailIdColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $emailId[]['emailId'] = $rowDatar[0][$k];
                                    }else{
                                        $emailId[]['emailId'] = '';
                                    }
                                }
                                
                                if($k === $userNameColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $username[]['userName'] = $rowDatar[0][$k];
                                    }else{
                                        $username[]['userName'] = '';
                                    }
                                }
                                
                                if($k === $passwdHashColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $password[]['passwdHash'] = $rowDatar[0][$k];
                                    }else{
                                        $password[]['passwdHash'] = '';
                                    }
                                }
                                
                                if($k === $displayNameColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $displayname[]['displayName'] = $rowDatar[0][$k];
                                    }else{
                                        $displayname[]['displayName'] = '';
                                    }
                                }
                                
                                if($k === $departmentColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $department[]['department'] = $rowDatar[0][$k];
                                    }else{
                                        $department[]['department'] = '';
                                    }
                                }
                                
                                if($k === $locationColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $location[]['location'] = $rowDatar[0][$k];
                                    }else{
                                        $location[]['location'] = '';
                                    }
                                }
                                
                                if($k === $policyNameColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $policyname[]['policyName'] = $rowDatar[0][$k];
                                    }else{
                                        $policyname[]['policyName'] = '';
                                    }
                                }
                                
                                if($k === $syncPolicyNameColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $syncPolicyName[]['syncPolicyName'] = $rowDatar[0][$k];
                                    }else{
                                        $syncPolicyName[]['syncPolicyName'] = '';
                                    }
                                }
                                
                                if($k === $o365PolicyNameColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $o365PolicyName[]['odbPolicyName'] = $rowDatar[0][$k];
                                    }else{
                                        $o365PolicyName[]['odbPolicyName'] = '';
                                    }
                                }
                                
                                if($k === $odbLoginIdColumnNumber){
                                    if($rowDatar[0][$k] != ''){
                                        $odbId[]['odbLoginId'] = $rowDatar[0][$k];
                                    }else{
                                        $odbId[]['odbLoginId'] = '';
                                    }
                                }

                            }


                        }
                    }
            }
        $this->log('COUNT USERNAME : '.count($username), 'info');
        $this->log('Result_EMAILID: '.json_encode($emailId), 'info');
        $this->log('Result_USERNAME: '.json_encode($username), 'info');
        $this->log('Result_PASSWORD: '.json_encode($password), 'info');
        $this->log('Result_DIAPLAYNAME: '.json_encode($displayname), 'info');
        $this->log('Result_DEPARTMENT: '.json_encode($department), 'info');
        $this->log('Result_LOCATION: '.json_encode($location), 'info');
        $this->log('Result_POLICYNAME: '.json_encode($policyname), 'info');
        $this->log('Result_SYNCPOLICYNAME: '.json_encode($syncPolicyName), 'info');
        $this->log('Result_o365POLICYNAME: '.json_encode($o365PolicyName), 'info');
        $this->log('Result_ODBID: '.json_encode($odbId), 'info');
        $this->log('Result_$4999999: '.json_encode($even), 'info');
        $this->log('Result_$5999999: '.json_encode($odd), 'info');
        $this->log('Result_$4999999count: '.json_encode(count($even)), 'info');
        $this->log('Result_$5999999count: '.json_encode(count($odd)), 'info');
        $sizeOfEven = count($emailId);
        $sizeOfOdd = count($username);
        $this->log('Result_EMAILID_COUNT: '.$sizeOfEven, 'info');
        $this->log('Result_USERNAME_COUNT: '.$sizeOfOdd, 'info');
        $this->log('Result_EMAILID_COUNT: '.count($emailId), 'info');
        $this->log('Result_USERNAME_COUNT: '.count($username), 'info');
        $this->log('Result_PASSWORD_COUNT: '.count($password), 'info');
        $this->log('Result_DIAPLAYNAME_COUNT: '.count($displayname), 'info');
        $this->log('Result_DEPARTMENT_COUNT: '.count($department), 'info');
        $this->log('Result_LOCATION_COUNT: '.count($location), 'info');
        $this->log('Result_POLICYNAME_COUNT: '.count($policyname), 'info');
        $this->log('Result_SYNCPOLICYNAME_COUNT: '.count($syncPolicyName), 'info');
        $this->log('Result_o365POLICYNAME_COUNT: '.count($o365PolicyName), 'info');
        $this->log('Result_ODBID_COUNT: '.count($odbId), 'info');
        for($j=0; $j<count($username);$j++ ) {
                if($username[$j]['userName'] == ''){
                    $resultData1 = array(
                        'result' => 'fail_usernames',
                        'msg' => 'usernames missing'
                    );
                    return json_encode($resultData1);
                }
               
            }
        for($j=0; $j<count($emailId);$j++ ) {
                if($emailId[$j]['emailId'] == ''){
                    $resultData1 = array(
                        'result' => 'fail_emailId',
                        'msg' => 'email id missing'
                    );
                    return json_encode($resultData1);
                }
               
            }
        
        if($sizeOfEven == $sizeOfOdd){
            if(!empty($emailId) && !empty($username)){
                for($i=1;$i<sizeof($emailId);$i++){
                    
                    $dog[] = array_merge($emailId[$i],$username[$i]);
                }
            }
        }
        else{
            $resultData = array(
            'result' => 'fail'
        );
        return json_encode($resultData);
            
        }

        
                for($i=1;$i<sizeof($emailId);$i++){
                    $this->log('Result_gggggggggggggggggggggggggggggggggg: ','info');
                    $bigDog[] = array_merge($emailId[$i],$username[$i],$password[$i],$displayname[$i],$department[$i],$policyname[$i],$syncPolicyName[$i],$o365PolicyName[$i],$location[$i],$odbId[$i]);
                }
        $this->log('Result_datacgARRAYFILL: '.json_encode($even),'info');
        $this->log('Result_datacgARRAYFILL: '.json_encode($odd),'info');
        $this->log('Result_datacgARRAYFILL: '.json_encode($dog),'info');
        $this->log('Result_BIGDOG: '.json_encode($bigDog),'info');
        
        
        function combineStringArrayWithDuplicates ($even, $odd) {
                $iter = 0; 
                foreach ($even as $key) 
                    { 
                        $combined[$iter] = $key .": ". $odd[$iter];
                        $iter++;
                        
                    }
                    return $combined;
              }

                $combined = combineStringArrayWithDuplicates($even, $odd);


                $this->log('Result_datacgjjjjjjjjjjjjjjjj: '.json_encode($combined), 'info');
                //$new = array('deviceList' => $combined);
                $new = array('userList' => $bigDog);
        
        
        foreach($pageWiseData as $pageKey => $pageData){
            $sheetName = $sheets[$pageKey];
            $this->log('Result_pagekey: '.json_encode($pageKey), 'info');
            $this->log('Result_: '.json_encode($pageData), 'info');
            $htmlData = [];
            
            
            foreach($pageData as $rowData){
                if(!empty($rowData[0])) {
                    foreach ($rowData[0] as $value) {
                        $data = $value;
                        //$this->log('Result_data: '.$data, 'info');
                    }
                    $this->log('Result_datassssssssss: '.$data, 'info');
                    $htmlData = array_merge(array($data), $htmlData);
                }
            }
            
            
            $this->log('Result_KKKKKKKKKhtmlData: '.json_encode($htmlData), 'info');   
            $sheetId = strtolower($sheetName);
            $sheetId = str_replace(' ', '_', $sheetId);
            $html[$pageKey] = array(
                'sheetName' => $sheetName,
                'id' => $sheetId,
                'userNames' => $htmlData
            );
        }
        $resultData = array(
            'result' => 'success',
            'data' => array_values($html),
            'userList' => $new
        );$this->log('Result_resultDatahhh: '.json_encode($resultData), 'info');
        return json_encode($resultData);
    }
	
    public function sharedFileReaderShareView(){
        if(!empty($_POST['path']) && !empty($_POST['fileName']) && !empty($_POST['userName']) && !empty($_POST['syncRevisionId'])){
            //$_POST['fileName'] = urldecode($_POST['fileName']);
        //$_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
                $_POST['fileName'] = str_replace(' ', '-', $_POST['fileName']);
                    $_POST['fileName'] = preg_replace("/[^a-z0-9\_\-\.]/i", '', $_POST['fileName']);
                    $t=time();
                    $_POST['fileName'] = $t.$_POST['fileName'];
            $checkForShareWith = !empty($_POST['shareWith']) ? true : false;

            $fileArray = explode('.', $_POST['fileName']);
            list($extension) = array_reverse($fileArray);
            $extension = strtolower($extension);
            $fullPath = $this->filePath;
            $this->cleanUpTempDirectory($fullPath);

            $headers['file-name'] = $_POST['fileName'];
            $headers['file-path'] = rtrim($_POST['path'], '/');
            $headers['userName'] = $_POST['userName'];
            $headers['syncRevisionId'] = $_POST['syncRevisionId'];
            $sync = new Sync();
            $fileContent = $sync->download($headers);

            if($fileContent['status'] != 200){
                echo json_encode(array(
                    'result' => 'fail',
                    'message' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                ));
                exit;
            }

            $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
            $myFile = fopen($fileFullPath, "w");
            if(!$myFile){
                die("Unable to open file!");
            }
            $txt = $fileContent['body'];
	    fwrite($myFile, $txt);
            fclose($myFile);

            if(in_array($extension, $this->allowedImageExtensions)) {

                $this->sendImageData($_POST['fileName']);

            }elseif(in_array($extension, $this->allowedVideoExtensions)) {

                $this->sendVideoData($_POST['fileName']);

            }elseif(in_array($extension, $this->allowedExtensions)) {

                if(method_exists($this, $extension)){

                    $this->$extension();

                }else{
                    $data = array(
                        'result' => 'fail',
                        'message' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                    );
                    $jsonDoc = json_encode($data);
                    echo $jsonDoc;
                    exit;
                }
            }else{
                $data = array(
                    'result' => 'fail',
                    'message' => 'Selected file format is not supported'
                );
                $jsonDoc = json_encode($data);
		echo $jsonDoc;
                exit;
            }

        }else{
            $data = array(
                'error' => 'No file was passed to view',
                'data' => $_POST
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }
	
    public function sharedBackupFileReaderShareView(){
        if(!empty($_POST['path']) && !empty($_POST['fileName']) && !empty($_POST['userName']) && !empty($_POST['backupID'])){
            //$_POST['fileName'] = urldecode($_POST['fileName']);
            //$_POST['fileName'] = html_entity_decode($_POST['fileName'], ENT_QUOTES | ENT_HTML5);
		$_POST['fileName'] = str_replace(' ', '-', $_POST['fileName']);
                    $_POST['fileName'] = preg_replace("/[^a-z0-9\_\-\.]/i", '', $_POST['fileName']);
		    $t=time();
                    $_POST['fileName'] = $t.$_POST['fileName'];

            $checkForShareWith = !empty($_POST['shareWith']) ? true : false;            
            $fileArray = explode('.', $_POST['fileName']);
            list($extension) = array_reverse($fileArray);
            $extension = strtolower($extension);
            $fullPath = $this->filePath;
            $this->cleanUpTempDirectory($fullPath);

            $file['fileName'] = $_POST['fileName'];
            $file['filePath'] = rtrim($_POST['path'], '/');
            $file['userName'] = $_POST['userName'];
            $file['backupID'] = $_POST['backupID'];
            $file['deviceUUID'] = "";
            $file['isSync'] = $_POST['isSync'];
            $file['cloudName'] = $this->session->get("cloudName");
            $backup = new Backup();
            $fileContent = $backup->download($file);

            if($fileContent['status'] != 200){
                echo json_encode(array(
                    'result' => 'fail',
                    'message' => 'Was not able to get file contents, error code - ' . $fileContent['status']
                ));
                exit;
            }

            $fileFullPath   = $fullPath.ltrim($_POST['fileName'], DS);
            $myFile = fopen($fileFullPath, "w");
            if(!$myFile){
                die("Unable to open file!");
            }
            $txt = $fileContent['body'];
            fwrite($myFile, $txt);
            fclose($myFile);

            if(in_array($extension, $this->allowedImageExtensions)) {

                $this->sendImageData($_POST['fileName']);

            }elseif(in_array($extension, $this->allowedVideoExtensions)) {

                $this->sendVideoData($_POST['fileName']);

            }elseif(in_array($extension, $this->allowedExtensions)) {

                if(method_exists($this, $extension)){

                    $this->$extension();

                }else{
                    $data = array(
                        'result' => 'fail',
                        'message' => 'Selected file format is not supported yet but will be supported soon, Please check back later'
                    );
                    $jsonDoc = json_encode($data);
                    echo $jsonDoc;
                    exit;
                }
            }else{
                $data = array(
                    'result' => 'fail',
                    'message' => 'Selected file format is not supported'
                );
                $jsonDoc = json_encode($data);
                echo $jsonDoc;
                exit;
            }

        }else{
            $data = array(
                'error' => 'No file was passed to view',
                'data' => $_POST
            );
            $jsonDoc = json_encode($data);
            echo $jsonDoc;
        }
    }
	
    public function pptx(){
        $fileName = $_POST['fileName'];
        if(!empty($fileName)) {
            if(file_exists($this->filePath.$fileName)) {
                $data = array(
                    'fileName' => Url::templatePath('default/documents/'.$_POST['fileName']),
                    'type' => 'pptx'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
        exit;
    }
	
    public function ppt(){
        $fileName = $_POST['fileName'];
        if(!empty($fileName)) {
            if(file_exists($this->filePath.$fileName)) {
                $data = array(
                    'fileName' => Url::templatePath('default/documents/'.$_POST['fileName']),
                    'type' => 'pptx'
                );
                $jsonDoc = json_encode($data);
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
        exit;
    }
	
    public function doc(){
        $fileName = $_POST['fileName'];
        if(!empty($fileName)) {
            if(file_exists($this->filePath.$fileName)) {
                /*$data = array(
                    'html' => nl2br(file_get_contents($this->filePath.$fileName)),
                    'type' => 'text'
                );
                $jsonDoc = json_encode($data);*/
                    $jsonDoc = json_encode(Url::templatePath('default/documents/'.$_POST['fileName']));
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }
	
    public function docx(){
        if(!empty($_POST['fileName'])) {
            if(file_exists($this->filePath . $_POST['fileName'])) {                
                 $jsonDoc = json_encode(Url::templatePath('default/documents/'.$_POST['fileName']));
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
    }
	
    public function xls(){
        if(empty($_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            echo json_encode($data);
            exit;
        }
        if(!file_exists($this->filePath.$_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found'
            );
            echo json_encode($data);
            exit;
        }
        $data = array(
                'type' => 'excel',
                'fileName' => Url::templatePath('default/documents/'.$_POST['fileName'])
        //    'html' => array_values($html)
        );
        echo json_encode($data);
    }
	
    public function xlsx(){
        if(empty($_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            echo json_encode($data);
            exit;
        }
        if(!file_exists($this->filePath.$_POST['fileName'])) {
            $data = array(
                'result' => 'fail',
                'msg' => 'Selected file was not found'
            );
            echo json_encode($data);
            exit;
        }
        $this->log("first : ".$_POST['fileName'],"info");
        $data = array(
                'type' => 'excel',
                'fileName' => Url::templatePath('default/documents/'.$_POST['fileName']),
           // 'html' => array_values($html)
    );
//      $this->log("------------> ".json_encode($data),"info");
        echo json_encode($data);
    }
	
    public function txt(){
        $fileName = $_POST['fileName'];
        if(!empty($fileName)) {
            if(file_exists($this->filePath.$fileName)) {
		$data = file_get_contents($this->filePath.$fileName);
		$jsonDoc = $data;
                /*$data = array(
                    'html' => file_get_contents($this->filePath.$fileName),
                    'fileName' => $_POST['fileName'],
                    'type' => 'text'
                );
                $jsonDoc = json_encode($data);*/
            }else{
                $data = array(
                    'result' => 'fail',
                    'msg' => 'Selected file was not found'
                );
                $jsonDoc = json_encode($data);
            }
        }else{
            $data = array(
                'result' => 'fail',
                'msg' => 'The File format is not yet support'
            );
            $jsonDoc = json_encode($data);
        }
        echo $jsonDoc;
        exit;
    }	

}
