<?php
use \Core\View;
use Helpers\Url;
use Core\Language;
/*
*
* Copyright 2015
* ParaBlu Systems Private Limited
* All Rights Reserved
*
* NOTICE:  All information contained herein is, and remains
* the property of ParaBlu Systems Private Limited and its suppliers, if any.
* The intellectual and technical concepts contained herein are proprietary
* to ParaBlu Systems Private Limited and its suppliers and may be covered by
* Indian, US and Foreign Patents, patents in process, and are protected by
* trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from ParaBlu Systems Private Limited.
*
* index.php
*
* @author Prashanth Kumar B - prashanth.kumar@parablu.com
* @version 2.0
* @date 7/10/15
* @time 11:55 AM
*
*/

?>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <ol class="breadcrumb">
                    <li><h3><a href="<?=Url::basePath('users')?>"><?=$data['title']?></a></h3></li>
                    <li><a href="<?=Url::basePath('myAccount/'.$data['currentUser'])?>"><?=$data['crumb1']?></a></li>
                    <li><span><?=$data['crumb2']?></span></li>
                    <?php if(!empty($data['deviceName'])){ ?>
                        <li><span><?=$data['deviceName']?></span></li>
                    <?php } ?>
                </ol>
            </div>
            <div class="col-lg-6 hide">
                <?php View::renderTemplate('partials/createButton', $data)?>
            </div>
        </div>
    </div>
    <div class="main" ng-controller="UserController">
        <span class="hide currentPage"><?='policyInfo'?></span>
        <span class="hide currentOs"><?=$data['os']?></span>
        <span class="hide currentUser"><?=base64_decode($data['currentUser'])?></span>
        <div class="row profile">
            <div class="col-lg-1 col-md-1 col-sm-1">
                <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
            </div>
            <div class="col-lg-11 col-md-11 col-sm-11 ng-cloak">
                <div class="panel">
                    <div class="panel-heading">
                        <h4><?=Language::show('policy_information', 'keywords')?></h4>
                    </div>
                    <div class="panel-body" style="padding: 0px 30px 30px 30px;">
                        <div class="row">
                            <div class="row">
                                <div class="col-lg-6">
                                    <h5>Default Folders that will be backed up automatically:</h5>
                                    <div class="col-lg-12">
                                        <h4>
                                            <li ng-repeat="value in currentUser.defaultFolders track by $index" ng-cloak>
                                                <a class="label label-success" title="{{value}}" style="word-wrap:break-word;" ng-cloak>{{ value | limitTo:60}}{{value.length > 60 ? '...' : ''}}</a>
                                            </li>
                                        </h4>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <h5 ng-if="currentUser.filterType == 'exclusion'">File Types that will be excluded:</h5>
                                    <h5 ng-if="currentUser.filterType == 'inclusion'">File Types that will be included:</h5>
                                    <div class="col-lg-12" style="overflow: auto">
                                        <h4>
                                            <li>
                                                <a class="label label-success" title="{{value}}" style="word-wrap:break-word;" ng-cloak>{{ currentUser.fileTypes | limitTo:60}}{{currentUser.fileTypes.length > 60 ? '...' : ''}}</a>
                                            </li>
                                        </h4>
                                    </div>
                                </div>
                            </div>
                            <hr/>
                            <div class="row">
                                <div class="col-lg-6">
                                    <h4><?=Language::show('device_inclusion_folders', 'keywords')?></h4>
                                    <div class="row userInclusionFoldersForm">
                                        <?=\Helpers\Form::open(array(
                                            'class' => 'inclusionPolicyForm',
                                            'csrf' => $data['csrf_token'],
                                            'autocomplete' => 'off',
                                            'ng-submit' => 'addInclusionFolder(current.inclusionFolderName)'
                                        ));?>
                                        <div class="col-lg-12">
                                            <label for="inclusionFolderNam"><?=Language::show('inclusion_folder_name', 'keywords')?></label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                       ng-model="current.inclusionFolderName" name="inclusionFolderName" id="inclusionFolderName"
                                                       value="" placeholder="Enter the full path of the folder" required="required" autocomplete="off"
                                                       data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                       data-content="<?=Language::show('inclusionError', 'keywords')?>"
                                                    />
                                                <div class="input-group-btn">
                                                    <button type="submit" class="btn btn-default"><i class="fa fa-plus-circle"></i> <?=Language::show('include', 'keywords')?></button>
                                                </div>
                                            </div>
                                        </div>
                                        <?=\Helpers\Form::close()?>
                                    </div>
                                    <div class="row userInclusionFolders" style="margin-top: 15px;">
                                        <div class="col-lg-11" style="margin-left: 15px;">
                                            <ul class="list-group">
                                                <li class="list-group-item" style="word-wrap:break-word;" ng-repeat="value in currentUser.userDefinedFolders track by $index">
                                                    <span ng-cloak>{{ value }}</span>
                                                    <span class="<?php if(!isMobile()){?> pull-right <?php } ?>">
                                                        <a
                                                            ng-bootbox-confirm="<?=Language::show('inclusionFolderDelete', 'keywords')?>"
                                                            ng-bootbox-confirm-action="removeInclusionFolder($index, 'true')"
                                                            ng-bootbox-confirm-action-cancel=""
                                                            href="javascript:;">
                                                            <i class="fa fa-times-circle-o"></i>
                                                        </a>
                                                    </span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 <?php if($data['isAdmin'] !='isAdmin') { echo 'hide';}?>">
                                    <h4><?=Language::show('device_exclusion_folders', 'keywords')?></h4>
                                    <div class="row userExclusionFoldersForm">
                                        <?=\Helpers\Form::open(array(
                                            'class' => 'exclusionPolicyForm',
                                            'csrf' => $data['csrf_token'],
                                            'autocomplete' => 'off',
                                            'ng-submit' => 'addExclusionFolder(current.exclusionFolderName)'
                                        ));?>
                                        <div class="col-lg-12">
                                            <label for="exclusionFolderNam"><?=Language::show('exclusion_folder_name', 'keywords')?></label>
                                            <div class="input-group">
                                                <input type="text" class="form-control"
                                                       ng-model="current.exclusionFolderName" name="exclusionFolderName" id="exclusionFolderName"
                                                       value="" placeholder="Enter the full path of the folder" required="required" autocomplete="off"
                                                       data-toggle="popover" data-trigger="focus" data-placement="bottom"
                                                       data-content="<?=Language::show('exclusionError', 'keywords')?>"
                                                    />
                                                <div class="input-group-btn">
                                                    <button type="submit" class="btn btn-default"><i class="fa fa-minus-circle"></i> <?=Language::show('exclude', 'keywords')?></button>
                                                </div>
                                            </div>
                                        </div>
                                        <?=\Helpers\Form::close()?>
                                    </div>
                                    <div class="row userExclusionFolders" style="margin-top: 15px;">
                                        <div class="col-lg-11" style="margin-left: 15px;">
                                            <ul class="list-group">
                                                <li class="list-group-item" style="word-wrap:break-word;" ng-repeat="value in currentUser.userExcludedFolders track by $index">
                                                    <span ng-cloak>{{ value }}</span>
                                                    <span class="<?php if(!isMobile()){?> pull-right <?php } ?>">
                                                        <a
                                                            ng-bootbox-confirm="<?=Language::show('exclusionFolderDelete', 'keywords')?>"
                                                            ng-bootbox-confirm-action="removeExclusionFolder($index, 'true')"
                                                            ng-bootbox-confirm-action-cancel=""
                                                            href="javascript:;">
                                                            <i class="fa fa-times-circle-o"></i>
                                                        </a>
                                                    </span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr />
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="bs-callout bs-callout-primary" id="callout-formgroup-inputgroup">
                                        <h4>Maximum File Size allowed :<span ng-if="currentUser.maxSizeAllowed == '1048576.00 MB'"> Unlimited</span></h4>
                                        <p ng-if="currentUser.maxSizeAllowed != '1048576.00 MB'">Any file more than <span ng-cloak>{{ currentUser.maxSizeAllowed }}</span> will not be backed up</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade" id="confirmAdd" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="addIt()">
                        <div class="modal-content smallModal">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="myModalLabel">Confirm Add</h4>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure, you want to add the folder path</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
        </div>
        <div class="modal fade" id="confirmAdd1" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <form class="" ng-submit="addEx()">
                        <div class="modal-content smallModal">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <h4 class="modal-title" id="myModalLabel">Confirm Add</h4>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure, you want to add the folder path</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="saveRename btn btn-success">Save</button>
                            </div>
                        </div>
                    </form>
                </div>
        </div>

        <?php View::renderTemplate('partials/search', $data); ?>
    </div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/UserController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script src="<?=Url::templatePath()?>js/angular/directives/fileUpload.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
