<?php
use Core\Language;
use Helpers\Assets;
use Helpers\Url;
use Helpers\Form; ?>
<div class="container">
    <div class="row hide">
        <div class="col-lg-6 col-lg-offset-3" align="center" style="margin-top: -25px;">
            <?php
            Assets::img(array(
                Url::templatePath() . 'images/logo_new.png',
            ));
            ?>
        </div>
    </div>
    <br/><br/><br/>
    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default no-box-shadow">
                <div class="panel-heading text-center" style="margin-right: 8%; padding: 25px 7px 15px 15px;"></div>
                <div class="panel-body">
                    <div class="col-lg-6" style="margin-top:-40px;">
                        <img src="<?=Url::templatePath()?>images/portal_login.png" />
                    </div>
                    <div class="col-lg-6" style="margin-top: 10px;">
                        <div class="error" style="display: none; color: #f55753; margin-bottom: 10px;"></div>
                        <?=
                            Form::open(array(
                                'method' => 'post',
                                'class' => 'shareForm',
                                'csrf' => $data['csrf_token'],
                                'autocomplete' => 'off',
                                //'data-parsley-validate' => true
                            ));
                        ?>
                        <div class="form-group hide">
                            <label for="cloudName"><?=Language::show('cloudName', 'keywords');?></label>
                            <input type="text" class="form-control" name="cloudName" id="cloudName" required autocomplete="off" value="<?=$data['file']->{'cloud-name'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="devicePath"><?=Language::show('devicePath', 'keywords');?></label>
                            <input type="text" class="form-control" name="devicePath" id="devicePath" required autocomplete="off" value="<?=$data['file']->{'device-path'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="filePath"><?=Language::show('filePath', 'keywords');?></label>
                            <input type="text" class="form-control" name="filePath" id="filePath" required autocomplete="off" value="<?=$data['filePath']?>">
                        </div>
                        <div class="form-group hide">
                            <label for="syncRevisionId"><?=Language::show('syncRevisionId', 'keywords');?></label>
                            <input type="text" class="form-control" name="syncRevisionId" id="syncRevisionId" required autocomplete="off" value="<?=$data['syncRevisionId']?>">
                        </div>
                        <div class="form-group hide">
                            <label for="fileSize"><?=Language::show('fileSize', 'keywords');?></label>
                            <input type="text" class="form-control" name="fileSize" id="fileSize" required autocomplete="off" value="<?=$data['fileSize']?>">
                        </div>
                        <div class="form-group hide">
                            <label for="fileName"><?=Language::show('fileName', 'keywords');?></label>
                            <input type="text" class="form-control" name="fileName" id="fileName" required autocomplete="off" value="<?=$data['file']->{'file-name'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="key12"><?=Language::show('key12', 'keywords');?></label>
                            <input type="text" class="form-control" name="key12" id="key12" required autocomplete="off" value="<?=$data['file']->{'key-12'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="key14"><?=Language::show('fileName', 'keywords');?></label>
                            <input type="text" class="form-control" name="key14" id="key14" required autocomplete="off" value="<?=$data['file']->{'key-14'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="key18"><?=Language::show('key18', 'keywords');?></label>
                            <input type="text" class="form-control" name="key18" id="key18" required autocomplete="off" value="<?=$data['file']->{'key-18'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="key20"><?=Language::show('key20', 'keywords');?></label>
                            <input type="text" class="form-control" name="key20" id="key20" required autocomplete="off" value="<?=$data['file']->{'key-20'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="passwordHash"><?=Language::show('passwordHash', 'keywords');?></label>
                            <input type="text" class="form-control" name="passwordHash" id="passwordHash" required autocomplete="off" value="<?=$data['file']->{'password-hash'}?>">
                        </div>
                        <div class="form-group hide">
                            <label for="userName"><?=Language::show('userName', 'keywords');?></label>
                            <input type="text" class="form-control" name="userName" id="userName" required autocomplete="off" value="<?=$data['file']->{'user-name'}?>">
                        </div>
                        <?php if($data['file']->{'is-password-protected'} == 'true'){ ?>
                            <div class="form-group hide">
                                <label for="password"><?=Language::show('password', 'keywords');?></label>
                                <input type="password" class="form-control" name="password" id="password" placeholder="<?=Language::show('enter_your', 'keywords');?> <?=Language::show('password', 'keywords');?>" autocomplete="off">
                            </div>
                        <?php } ?>
                        <?php if($data['file']->{'is-download'} == 'true'){ ?>
                        <a type="button" class="download btn btn-primary hide" onclick="checkAndProceed(true)"><?=Language::show('download', 'share');?></a>
                        <?php } ?>
                        <?php if($data['file']->{'is-view'} == 'true'){ ?>
                            <a type="button" id="view" class="view btn btn-primary hide" onclick="checkAndProceed(false)"><?=Language::show('view', 'share');?></a>
                        <?php } ?>
                        <?php if($_SESSION['loggedIn']){ ?>
                            <a href="<?=DIR?>" class="view btn btn-primary hide"><?=Language::show('Go To Portal', 'share');?></a>
                        <?php } ?>
                        <?=
                            Form::close();
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal" id="paraviewContainer" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" style="background-color:white;">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
<!--                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                    <h5 class="modal-title">Loading ...</h5>
                </div>
                <br/><br/>
                <div class="modal-body" <?php if($data['file']->{'is-download'} != 'true'){ ?> style="-webkit-user-select: none;-khtml-user-select: none;-moz-user-select: -moz-none;-o-user-select: none;user-select: none;" <?php } ?>>
                    <div class="pageContainer" style="background-color: white;display: none;"></div>
                    <div class="pdfContainer" style="display: none;"></div>
                    <div class="excelContainer" style="background-color: white;display: none;"></div>
                    <div class="content" style="text-align: -webkit-auto;display: none;"></div>
                    <div class="imageViewer" style="display: none;"></div>
                    <div class="pptxViewer" style="background-color: white;display: none;"></div>
                    <div class="paraviewLoading" style="margin-top: 15%">
                        <img width="5%" src="<?=Url::templatePath('default/images/gears.gif');?>" />
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary">Save changes</button>
                </div>
            </div>
        </div>
    </div>
</div>
<?php

/* USER-AGENTS
================================================== */
function check_user_agent ( $type = NULL ) {
        $user_agent = strtolower ( $_SERVER['HTTP_USER_AGENT'] );
        if ( ($type == 'bot' && (preg_match ( "/googlebot|adsbot|yahooseeker|yahoobot|msnbot|watchmouse|pingdom\.com|feedfetcher-google/", $user_agent ))) ||  ( $type == 'browser' && preg_match ( "/mozilla\/|opera\//", $user_agent )) || ( $type == 'mobile' && preg_match ( "/phone|iphone|itouch|ipod|symbian|android|htc_|htc-|palmos|blackberry|opera mini|iemobile|windows ce|nokia|fennec|hiptop|kindle|mot |mot-|webos\/|samsung|sonyericsson|^sie-|nintendo/", $user_agent )  )) {
                        return true;
        }
        return false;
}


?>
<script src="<?=Url::templatePath('default/js/plugins/tiff.min.js');?>" type="text/javascript" charset="UTF-8"></script>
<script>
    function checkAndProceed(type){
        $('.error').hide();
        var password = $('[name="password"]').val();
        var backupID = "<?=$data['backupID']?>";        
        $.ajax({
            url: '<?=DIR?>'+'share/checkPasswordShareView',
            method: 'POST',
            data: {password: password, type: type}
        }).done(function(data){
            var jData = JSON.parse(data);
            if(jData.result == 'success'){
                var accessType;
                if(type){
                    accessType = 'download';
                }else{
                    accessType = 'view';
                }
                $.ajax({
                    url: '<?=DIR?>'+'share/checkIfFileShared',
                    method: 'POST',
                    data: {accessType: accessType}
                }).done(function(data){

                    var jData = JSON.parse(data);
                    if(jData.result == 'success'){
                        if(type){
                            if(backupID.length > 0){
                                window.open('<?=BLUKRYPT_URL?>'+'<?=CLOUD_NAME?>'+'/portal/download/files/?fileName=<?=urlencode($data['file']->{'file-name'})?>&filePath='+encodeURIComponent("<?=$data['filePath']?>")+'&token=<?=$_SESSION["token"]?>&userName=<?=$data['file']->{'user-name'}?>'+'&isSync=false'+'&deviceUUID='+'&backupID='+backupID, '_self');
                                }else{
                                window.open('<?=BLUKRPT_URL_WITHOUT_IP?>'+'<?=CLOUD_NAME?>'+'/sync/portal/download/file/?fileName=<?=urlencode($data['file']->{'file-name'})?>&filePath='+encodeURIComponent("<?=$data['filePath']?>")+'&token=<?=$_SESSION["token"]?>&userName=<?=$data['file']->{'user-name'}?>&syncRevisionId=<?=$data['syncRevisionId']?>&path='+encodeURIComponent("<?=$data['filePath']?>")+'/'+encodeURIComponent("<?=urlencode($data['file']->{'file-name'})?>"), '_self');
                            }
                        }else{
                            view(password, backupID);
                        }
                    }else{
                        window.location.href = '404';
                    }

                });

            }else if(jData.result == 'fail'){
                $('.error').html(jData.message);
                $('.error').show();
                }
        }).fail(function(data){
            console.log(data);
        });
    }

    /*function view(password, backupID){
        $('#paraviewContainer .modal-title').html('Loading ...');
        $('.content').html('');
        $('.content').hide();
        $('.pageContainer').hide();
        $('.excelContainer').hide();
        $('.pdfContainer').hide();
        $('.imageViewer').hide();
        $('.paraviewLoading').show();

        $('#paraviewContainer').modal('show');
        var url = "";
        if(backupID.length > 0){
            url = '<?=DIR?>backup/share/viewShareView';
            isSync = false;
            }else{
            url = '<?=DIR?>share/viewShareView';
            isSync = true;
        }

        $.ajax({
            url: url,
            data: {path:'<?=$data['filePath']?>', fileName:'<?=urlencode($data['file']->{'file-name'})?>', syncRevisionId: '<?=$data['syncRevisionId']?>', userName:'<?=$data['file']->{'user-name'}?>', password:password, backupID: backupID, isSync: isSync},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            console.log(jData);
            if(jData.result == 'fail'){
                $('#paraviewContainer').modal('hide');
                $('.error').html(jData.message);
                $('.error').show();
                return;
            }

            if(jData.type == 'image') {
            $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.imageViewer').html(jData.html);
                $('.imageViewer').show();
                $('.paraviewLoading').hide();

            }else if(jData.type == 'pdf') {

                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.paraviewLoading').hide();
                $('.pdfContainer').html(jData.html);
                $('.pdfContainer').show();

            }else if(jData.type == 'odt') {

                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.pageContainer').show();
                $('.paraviewLoading').hide();
                viewDoc(jData, 300, 100);

            }else if(jData.type == 'text') {

                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.content').html(jData.html);
                $('.paraviewLoading').hide();
                $('.content').show();

            }else if(jData.type == 'excel') {

                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.excelContainer').show();
                $('.paraviewLoading').hide();
                viewExcel(jData);

            }else{
            $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.pageContainer').show();
                $('.paraviewLoading').hide();
                viewDoc(jData, 400, 100);

            }

        }).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = '<?=DIR?>/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = '<?=DIR?>/serviceDown';
                }, 3000);
            }
        });

    }*/
    
    function view(password, backupID){
        $('#paraviewContainer .modal-title').html('Loading ...');
        $('.content').html('');
        $('.content').hide();
        $('.pageContainer').hide();
        $('.excelContainer').hide();
        $('.pdfContainer').hide();
        $('.imageViewer').hide();
        $('.paraviewLoading').show();

        $('#paraviewContainer').modal('show');
        var url = "";
        if(backupID.length > 0){
            url = '<?=DIR?>backup/share/viewShareView';
            isSync = false;
        }else{
            url = '<?=DIR?>share/viewShareView';
            isSync = true;
        }
        var name = '<?=$data['file']->{'file-name'}?>';
        var abc = name.substring(name.lastIndexOf('.') + 1);
        $.ajax({
            url: url,
            data: {path:'<?=$data['filePath']?>', fileName:'<?=urlencode($data['file']->{'file-name'})?>', syncRevisionId: '<?=$data['syncRevisionId']?>', userName:'<?=$data['file']->{'user-name'}?>', password:password, backupID: backupID, isSync: isSync},
            type: 'POST'
        }).done(function(data){
            var jData = JSON.parse(data);
            console.log(jData);
            if(jData.result == 'fail'){
                $('#paraviewContainer').modal('hide');
                $('.error').html(jData.message);
                $('.error').show();
                return;
            }

            if(jData.type == 'image') {
                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                if(abc == 'TIFF' || abc == 'tiff' || abc == 'TIF' || abc == 'tif'){
                    console.log("inside tif loop");
                    $('.imageViewer').html('<center><span id="tifSpinner"><i class="fa fa-spinner fa-4x fa-pulse fa-fw"></i></span></center>');
                    /*start*/
                    Tiff.initialize({TOTAL_MEMORY: 16777216 * 10});
                    var xhr = new XMLHttpRequest();
                    xhr.open('GET', jData.fileName);
                    xhr.responseType = 'arraybuffer';
                    xhr.onload = function (e) {
                        var buffer = xhr.response;
                        var tiff = new Tiff({buffer: buffer});
                        for (var i = 0, len = tiff.countDirectory(); i < len; ++i) {
                            tiff.setDirectory(i);
                            var canvas = tiff.toCanvas();
                            console.log("gggggggggg");
                            $('.imageViewer').append(canvas);
                        }
                        $('#tifSpinner').hide();
                    };                  
                    xhr.send();
                    /*end*/
                }else{
                    $('.imageViewer').html(jData.html);     
                }
                $('.imageViewer').show();
                $('.paraviewLoading').hide();
            }else if(jData.type == 'pptx' || jData.type == 'ppt'){
                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.paraviewLoading').hide();
                $('.pptxViewer').show();
                if(/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)){
                    // true for mobile device
                    $('.pptxViewer').html('<div id="container12" style="position:relative;"><div id="overlay12" style="border-bottom: 22px solid #444343;position:fixed;width:34%;bottom:1%;right:0%;"></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData.fileName+'" width="-webkit-fill-available" height="-webkit-fill-available" style="width:-webkit-fill-available;height:-webkit-fill-available;" frameborder="0"></iframe></div>');
                }else{
                    // false for not mobile device
                    $('.pptxViewer').html('<p class="text-left">Note: Please use arrow keys to navigate between slides</p><div id="container12" style="position:relative;"><div id="overlay12" style="border-bottom: 30px solid white;position:fixed;width:100%;bottom:0%;"></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData.fileName+'" style="width:-webkit-fill-available;height:-webkit-fill-available;" frameborder="0"></iframe></div>');
                    document.getElementsByTagName('iframe').autofocus;
                }
            }else if(jData.type == 'pdf') {           
                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.paraviewLoading').hide();
                $('.pdfContainer').html(jData.html);
                $('.pdfContainer').show();
            }else if(jData.type == 'odt') {         
                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.pageContainer').show();
                $('.paraviewLoading').hide();
                viewDoc(jData, 300, 100);
            }else if(jData.type == 'text') {    
                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.content').html('<pre>'+jData.html+'</pre>');
                $('.paraviewLoading').hide();
                $('.content').show();
            }else if(jData.type == 'excel') {
                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.excelContainer').show();
                $('.paraviewLoading').hide();
                <?php if($data['file']->{'is-download'} != 'true'){ ?>
                    $('.excelContainer').html('<div id="container12" style="position:relative;"><div style="height: 85%;width: 86%;position: absolute;"><div id="overlay12" style="border-bottom: 31px solid white;position:fixed;width:100%;bottom:0;"></div></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData.fileName+'" width="962px" height="565px" frameborder="0"></iframe></div>');
                <?php }else{?>
                    $('.excelContainer').html('<div id="container12" style="position:relative;"><div id="overlay12" style="border-bottom: 31px solid white;position:fixed;width:100%;bottom:0;"></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData.fileName+'" width="962px" height="565px" frameborder="0"></iframe></div>');
                <?php } ?>
            }else{
                $('#paraviewContainer .modal-title').html("<?=$data['file']->{'file-name'}?>");
                $('.pageContainer').show();
                $('.paraviewLoading').hide();
                <?php if($data['file']->{'is-download'} != 'true'){ ?>
                    $('.pageContainer').html('<div id="container12" style="position:relative;"><div style="height: 565px;width: 80%;position: absolute;"><div id="overlay12" style="border-bottom: 25px solid white;position:fixed;width:100%;bottom:0;"></div></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData+'" width="962px" height="565px" frameborder="0"></iframe></div>');
                <?php }else{?>
                    $('.pageContainer').html('<div id="container12" style="position:relative;"><div id="overlay12" style="border-bottom: 25px solid white;position:fixed;width:100%;bottom:0;"></div><iframe src="https://view.officeapps.live.com/op/embed.aspx?src='+jData+'" width="962px" height="565px" frameborder="0"></iframe></div>');
                <?php } ?>
            }

        }).fail(function(data){
            if(data.status == 424){
                setTimeout(function(){
                    window.location.href = '<?=DIR?>/sleep';
                }, 3000);
            }else if(data.status == 503){
                setTimeout(function(){
                    window.location.href = '<?=DIR?>/serviceDown';
                }, 3000);
            }
        });

    }

    function addAPage(jsonData, pageNumber){
        pageNumber = pageNumber+1;
        $('.pageContainer').append('<div id="page'+pageNumber+'" class="page"></div>');
        $('.page').css(jsonData.pageStyle);
        $('#page'+pageNumber).append('<div class="pageContent"><div class="pageNumber"> Page '+pageNumber+'<br/></div></div>');
        $('.pageContent').css(jsonData.contentStyle);
        return pageNumber;
    }

    function checkHeight(contentHeight, pageNumber) {
    var div = '#page'+pageNumber+' .pageContent';
        var element = document.querySelector(div);
        var _hasScrollBar = false;
        if( (parseInt($(div).outerHeight(true) ) < parseInt(contentHeight))){
            _hasScrollBar = true;
        }
        return _hasScrollBar;
    }

    function viewDoc(jsonData, defaultHeight, minusDefaultSize){
        var pageNumber = 0;
        var pageHeight = parseInt(jsonData.pageStyle.height.replace("px", ""));
        var contentBottom = parseInt(jsonData.contentStyle.bottom.replace("px", ""));
        jsonData.html.forEach(function(row){
            var contentHeight = pageHeight - (contentBottom+defaultHeight);
            if ($('.page').length <= 0 ) {
                pageNumber = addAPage(jsonData, pageNumber);
            }
            if(checkHeight(contentHeight, pageNumber) == false) {
                pageNumber = addAPage(jsonData, pageNumber);
                defaultHeight = defaultHeight - minusDefaultSize;
            }
            $('#page'+pageNumber+' .pageContent').append(row);
        });

    }

    function viewExcel(jsonData){
        var html = '';
        var links = '';
        var htmlData = '';
        jsonData.html.forEach(function(row, key){
            var active = '';
            if(key == 0){
                active = 'active';
            }
            links += '<li role="presentation" class="'+active+'"><a href="#'+row.id+'" id="home-tab" role="tab" data-toggle="tab" aria-controls="home" aria-expanded="true">'+row.sheetName+'</a></li>';
            htmlData += '<div role="tabpanel" class="tab-pane fade '+active+' in" id="'+row.id+'" aria-labelledby="home-tab">'+row.html+'</div>';
        });
        html += '<div class="panel" style="background-color: #fff; padding: 20px 20px; overflow: auto; height: 550px">'+
            '<div class="bs-example bs-example-tabs" role="tabpanel" data-example-id="togglable-tabs">'+
            '<ul id="myTab" class="nav nav-tabs" role="tablist">'+links+'</ul>'+
            '<div id="myTabContent" class="tab-content">'
            +htmlData+
            '</div>'+
            '</div>'+
            '</div>';
        $('.excelContainer').html(html);
    }
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    checkAndProceed(false);
}, false);
</script>

<script type="text/javascript">
        function closeCurrentTab(){
                var conf=confirm("Are you sure, you want to close this tab?");
                if(conf==true){
                    window.open('', '_self', '');
                        close();
                }
        }
</script>
<style>
canvas{
border: 2px solid black;
margin: 5px;
width:400px;
height:500px;
}
</style>
