<?php

use \Core\View;
use Helpers\Form;
use \Helpers\Url;
use Core\Language;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Naveen Verma - naveenverma@parablu.com
 * @version 2.0
 * @date 12/04/19
 * @time 12:36 AM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
        <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><a href="<?=Url::basePath('settings/office365Settings')?>"><?=$data['crumb1']?></a></li>
                <li><?=$data['crumb2']?></li>
        </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='ccS'?></span>
            <?php if($_SESSION['storageResult'] == 'error'){ ?>
             <span class="resultError" style="display: none"><?=$_SESSION['storageMessage']?></span>
            <?php }elseif($_SESSION['storageResult'] == 'success'){ ?>
             <span class="resultSuccess" style="display: none"><?=$_SESSION['storageMessage']?></span>
            <?php } ?>
            <?php $_SESSION['storageResult'] = ''; ?>
            <?php $_SESSION['storageMessage'] = ''; ?>
            <div class="row">
                    <div class="forODB">
                        <div class="panel">
                            <div class="panel-heading"><h4>Tenant Settings</h4></div>
                            <div class="panel-body">
                                <form class="oneDriveConfiguration" ng-submit="saveOneDriveConfiguration()" data-parsley-validate>
                                    <div class="row">
                                    <input type="text" class="hide" hidden value="<?=$data["configId"]?>" name="configId" />
                                    <div class="form-group col-lg-6">
                                        <label for="clientId">Client ID</label>
                                        <input type="text" class="form-control" name="clientId" id="clientId" value="<?=$data["clientID"]?>" placeholder="Enter your Client Id" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- Client ID will be the id which was provided when you have created an app.</span>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="clientSecret">Client Secret</label>
                                            <input type="text" class="form-control" name="clientSecret" id="clientSecret" value="<?=$data["clientSecretKey"]?>" placeholder="Enter your Secret Key" required autocomplete="off">
                                            <span class="help-line text-muted">Note:- Client Secret key will be the key which was provided when you have created an app.</span>
                                    </div>
                                    <div class="form-group col-lg-6 tenantId">
                                        <label for="tenantId"><?=Language::show('Tenant Id', 'keywords')?></label>
                                        <input type="text" class="form-control" name="tenantId" id="tenantId" value="<?=$data["tenantId"]?>" placeholder="Enter your Tenant Id" autocomplete="off" required>
                                        <span class="help-line text-muted">Note:- Tenant Id will be the key which was provided when you have created an app.</span>
                                    </div>
                                    <div class="form-group col-lg-6" style="margin-bottom:40px;">
                                        <label for="clientRedirectURI">Client Redirect URI</label>
                                        <input type="text" class="form-control" name="clientRedirectURI" id="clientRedirectURI" value="<?=$data["clientRedirectURI"]?>" placeholder="Enter your Client Redirect URI" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge.</span>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="clientResourceURL">Client OneDrive for Business URL</label>
                                        <input type="text" class="form-control" name="clientResourceURL" id="clientResourceURL" value="<?=$data["clientResourceURL"]?>" placeholder="Enter your Client OneDrive for Business URL" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- Entered URL should be a valid one, example: http://example.com, (Enter your share point app URL)</span>
                                    </div>
                                    <div class="form-group col-lg-6" style="margin-bottom:40px;">
                                        <label for="clientTokenURL">Client Token URL</label>
                                        <input type="text" class="form-control" name="clientTokenURL" id="clientTokenURL" value="<?=$data["clientTokenURL"]?>" placeholder="Enter your client token URL" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- Entered URL should be a valid one, example: http://example.com</span>
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="portalURL">Portal URL</label>
                                        <input type="text" class="form-control" name="portalURL" id="portalURL" value="<?=$data["portalURL"]?>" placeholder="Enter your Portal URL" required autocomplete="off">
                                        <span class="help-line text-muted">Note:- Please do not change this URL without administrators knowledge, if not specified url will be automatically detected.</span>
                                        <br/><br/>
                                    </div>
                                </div>
                                <div>
                                    <button type="submit" class="btn btn-success pull-right">Save Settings</button>
                                </div>
                                </form>
                            </div>
                        </div>
<?php //if($data['tokenMapped'] == "false") { ?>
<div class="panel">
<div class="panel-heading"><h4>For Admin Consent</h4></div>
 <div class="panel-body">
<?php
$tenentId = $data["tenantId"];
$clientId = $data["clientID"];
$user_principal = $data['user_principal'];
//$redirectURI = $data["clientRedirectURI"];
                                if(useLocalPackage != true){
                                    $redirectURI = "https://api-app.parablu.com/adminConsent.php";
                                    $appURL = "https://api-app.parablu.com/callConsent.php";
                                }else{
                                    $redirectURI = LOCAL_IP."/app/adminConsent.php";
                                    $appURL = LOCAL_IP."/app/callConsent.php";
                                }
                    $params = "?response_type=code&client_id=".$clientId."&redirect_uri=".$redirectURI."&user_principal=".$user_principal;
                    //$ADUrl = API_APP_URL1.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
                    $ADUrl = $appURL.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
?>
<p>
       <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$ADUrl;?>')"><i class="fa fa-windows"></i> Grant Admin Consent</a>
</p>
</div>
</div>
<?php //} ?>                     
<?php //if($data['userDetails']->{'office365BkpEnabled'} =='true' || $data['userDetails']->{'exchangeBkpEnabled'} == 'true') { ?>
<?php //if($data['tokenMapped'] == "false") { ?>
<div class="panel storagepanel">
<div class="panel-heading"><h4>Select Storage Space</h4></div>
 <div class="panel-body">
<?php
$tenentId = $data["tenantId"];
$clientId = $data["clientID"];
$user_principal = $data['user_principal'];
//$redirectURI = $data["clientRedirectURI"];
                                if(useLocalPackage != true){
                                    $redirectURI = "https://api-app.parablu.com/oneDrive.php";
                                    $appURL = "https://api-app.parablu.com/call1.php";
                                }else{
                                    $redirectURI = LOCAL_IP."/app/oneDrive.php";
                                    $appURL = LOCAL_IP."/app/call1.php";
                                }
                    $params = "?response_type=code&client_id=".$clientId."&redirect_uri=".$redirectURI."&user_principal=".$user_principal;
                    //$ADUrl = API_APP_URL1.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
                    $ADUrl = $appURL.$params."&tenentId=".$tenentId."&scope=".AZURE_SCOPE."&sourceURI=".\Helpers\Url::basePath();
?>
<p>
<!--       <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$ADUrl;?>')"><i class="fa fa-windows"></i> Map Directory</a>-->
<a class="btn btn-default" ng-bootbox-confirm="<h4><?=Language::show('Before you go ahead with this step, please ensure you’ve used the “Admin Consent” button to let your local SharePoint Administrator give permission.  If you’ve not done so, please cancel out of this dialog box and do that first.', 'keywords')?></h4>" ng-bootbox-confirm-action="redirectTo('<?=$ADUrl;?>')" ng-bootbox-confirm-action-cancel="" href="javascript:;"><i class="fa fa-windows"></i> <?=Language::show('Map Directory', 'keywords');?></a>
</p>
</div>
</div>
<?php //} ?>

                        <?php if($data['loggedInUser']['userName'] == $data['userDetails']->{'user-name'}){ ?>
                            <?php if($data['userDetails']->{'backup-enabled'} == "true" || $data['userDetails']->{'sync-enabled'} == "true"){?>
                                <?php if($data['userDetails']->{'externalstorage-authorized'}=="true") { ?>
                                    <div class="panel hide">
                                        <div class="panel-heading"><h4>Select Storage Space</h4></div>
                                        <div class="panel-body">
                                            <div class="form-group col-lg-12">
                                                <div class="well well-lg">
                                                    <p class="hide">
                                                        <a href="javascript:;" class="btn btn-default"><i class="fa fa-database"></i> Local Storage</a>
                                                        - Your cloud does not support this feature
                                                    </p>
                                                    <p class="hide">
                                                        <a href="javascript:;" class="btn btn-default"><i class="fa fa-cloud"></i> Parablu Hosted Storage</a>
                                                          - Parablu Cloud Storage is your default selected storage space. Please select other storage space.
                                                    </p>
                                                    <?php
                                                        $GDUrl = GOOGLE_REDIRECT_URI."?scope=".GOOGLE_SCOPE."&state=".$data['loggedInUser']['userName']."&redirect_uri=".\Helpers\Url::basePath(GOOGLE_RESOURCE_URI.'/')."&response_type=code&client_id=".GOOGLE_CLIENT_ID."&approval_prompt=force&access_type=offline";
                                                    ?>
                                                    <p class="hide">
                                                         <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$GDUrl;?>')"><i class="fa fa-google"></i> Google Drive</a>
                                                        - Google Drive Storage space
                                                    </p>
                                                    <?php
                                                        //$MODCUrl = ODFC_REDIRECT_URI."?client_id=".ODFC_CLIENT_ID."&response_type=code&redirect_uri=".\Helpers\Url::basePath(ODFC_RESOURCE_URI.'/')."&state=".$data['loggedInUser']['userName'];
                                                    ?>
                                                    <p class="hide">
                                                        <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$MODCUrl;?>')"><i class="fa fa-windows"></i> Microsoft OneDrive</a>
                                                        - Microsoft OneDrive Consumer Storage Space
                                                    </p>
                                                    <?php
                                                        $params = "?resource=".$data["clientResourceURL"]."&client_id=".$data["clientID"]."&response_type=code&redirect_uri=".$data["clientRedirectURI"]."&state=".$data['loggedInUser']['userName'];
                                                        $MODBUrl = API_APP_URL.$params."&user=".$data['loggedInUser']['userName']."&sourceURI=".\Helpers\Url::basePath();
                                                    ?>
                                                    <p>
                                                        <a href="javascript:;" class="btn btn-default" ng-click="redirectTo('<?=$MODBUrl;?>')"><i class="fa fa-windows"></i> Microsoft OneDrive for Business</a>
                                                        - Microsoft OneDrive for business Storage Space
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            <?php } ?>
                        <?php } ?>
                    </div>
                </div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?php echo microtime();?>" type="text/javascript"></script>
