<?php

use \Core\View;
use \Helpers\Url;
use Core\Language;
 /*
 *
 * Copyright 2015
 * ParaBlu Systems Private Limited
 * All Rights Reserved
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of ParaBlu Systems Private Limited and its suppliers, if any.
 * The intellectual and technical concepts contained herein are proprietary
 * to ParaBlu Systems Private Limited and its suppliers and may be covered by
 * Indian, US and Foreign Patents, patents in process, and are protected by
 * trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from ParaBlu Systems Private Limited.
 *
 * index.php
 *
 * @author Naveen Verma - naveenverma@parablu.com
 * @version 2.5.3.0
 * @date 20-Aug-2020
 * @time 07:30 PM
 * 
 */
?>
<div class="container">
    <div class="row">
        <div class="col-lg-6">
            <ol class="breadcrumb">
                <li><h3><a href="<?=Url::basePath('settings')?>"><?=$data['title']?></a></h3></li>
                <li><?=$data['crumb1']?></li>
            </ol>
        </div>
        <div class="col-lg-6 hide">
            <?php View::renderTemplate('partials/createButton', $data)?>
        </div>
    </div>
</div>
<div class="main" ng-controller="SettingController">
    <div class="row profile">
        <div class="col-lg-1 col-md-1 col-sm-1">
            <?php if(!isMobile()){ View::renderTemplate('partials/sideBar', $data); }?>
        </div>
        <div class="col-lg-11 col-md-11 col-sm-11">
            <span class="csrf_token hide"><?=$data['csrf_token']?></span>
            <span class="currentPage hide"><?='licenseKeyList'?></span>
            <div class="row">
                <div class="panel">
                    <div class="panel-heading">
                        <h4 style="padding: 0px 0px 0px 15px;">License Key List
<span class="pull-right"><a class="btn btn-success btn-small" data-toggle="modal" data-target="#addKey">Upload License Key</a></span>
</h4>
                    </div>
<div class="panel-body" id="noKeys" style="display:none;">
                        <div class="col-lg-12">
                            <h2 align="center">No License Keys found</h2>
                        </div>
                    </div>
                    <div class="panel-body table-responsive" id="licenseKeyList">
                        <div class="row col-lg-12">
                            <table class="table table-bordered table-striped">
                            <thead>
                            <tr>
                                <th class="text-left clickAble" ng-click="listSortType = 'fileName'; sortReverse = !sortReverse">
                                    <?=Language::show('License Key', 'keywords')?>
                                    <span ng-show="listSortType == 'fileName' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="listSortType == 'fileName' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-left clickAble" ng-click="listSortType = 'lastModifiedTimeMillis'; sortReverse = !sortReverse">
                                    <?=Language::show('Creation Date', 'keywords')?>
                                    <span ng-show="listSortType == 'lastModifiedTimeMillis' && !sortReverse" class="fa fa-caret-up"></span>
                                    <span ng-show="listSortType == 'lastModifiedTimeMillis' && sortReverse" class="fa fa-caret-down"></span>
                                </th>
                                <th class="text-left"><?=Language::show('action', 'keywords')?></th>
                            </tr>
                            </thead>
                            <tbody ng-cloak>
                            <tr ng-repeat="value in licenseKeyList | orderBy:listSortType:sortReverse">
                                <td > {{ value.fileName }}</td>
                                <td > {{ value.lastModifiedTime }}</td>
                                <td>
                                   <a class="btn btn-success btn-small" ng-click="licenseKeyAction(value.fileName, 'view')">View</a>
                                   <a class="btn btn-primary btn-small" ng-click="confirmApply(value.fileName)">Apply</a>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                        </div>
                     </div>
<!--                    <div class="panel-body">
                        <form class="proxyConfiguration" ng-submit="saveProxyConfiguration()" data-parsley-validate>
<div class="col-lg-12">
                            <div class="form-group col-lg-6">
                                <label for="cloudName">Cloud Name <a href="" data-toggle="tooltip" data-placement="right" title="Your cloud name should not have any spaces or special characters."><i class="fa fa-question-circle" aria-hidden="true"></i></a></label>
                                <input type="text" class="form-control" name="cloudName" id="cloudName" value="" placeholder="Enter your cloud name" required autocomplete="off">
                            </div>
 <div class="form-group col-lg-6">
                                <label for="noOfUsersAllowed">Total number of users allowed</label>
                                <input type="number" class="form-control" name="noOfUsersAllowed" id="noOfUsersAllowed" value="" placeholder="Enter total number of users allowed" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="noOfBackupUsersAllowed">Number of backup users allowed</label>
                                <input type="number" class="form-control" name="noOfBackupUsersAllowed" id="noOfBackupUsersAllowed" value="" placeholder="Enter number of backup users allowed" required autocomplete="off">
</div>
                            <div class="form-group col-lg-6">
                                <label for="noOfSyncUsersAllowed">Number of sync users allowed</label>
                                <input type="number" class="form-control" name="noOfSyncUsersAllowed" id="noOfSyncUsersAllowed" value="" placeholder="Enter number of sync users allowed" required autocomplete="off">
                            </div>
<div class="form-group col-lg-6">
                                <label for="noOfOdbBackupUsersAllowed">Number of OneDrive Backup users allowed</label>
                                <input type="number" class="form-control" name="noOfOdbBackupUsersAllowed" id="noOfOdbBackupUsersAllowed" value="" placeholder="Enter number of OneDrive backup users allowed" required autocomplete="off">
                            </div>
<div class="form-group col-lg-6">
                                <label for="noOfDevicesAllowed">Number of devices allowed</label>
                                <input type="number" class="form-control" name="noOfDevicesAllowed" id="noOfDevicesAllowed" value="" placeholder="Enter number of devices allowed" required autocomplete="off">
                            </div>
<div class="form-group col-lg-6">
    <label for="versioningEnabled">Number of versiond allowed</label>
                                <input type="number" class="form-control" name="versioningEnabled" id="versioningEnabled" value="" placeholder="Enter number of versions allowed" required autocomplete="off">
                            </div>
<div class="form-group col-lg-6">
                                <label for="noOfMiniCloudsAllowed">Number of miniclouds allowed</label>
                                <input type="number" class="form-control" name="noOfMiniCloudsAllowed" id="noOfMiniCloudsAllowed" value="" placeholder="Enter number of miniclouds allowed" required autocomplete="off">
                            </div>
                            <div class="form-group col-lg-6">
                                    <label for="validityPeriod">Validity Period</label>
                                    <input type="text" class="form-control" name="validityPeriod" id="validityPeriod" placeholder="Enter validity period" required>
                            </div>
<div class="form-group col-lg-6">
                                        <input type="checkbox" class="custom-control-input hide">
                                        <label class="hide" for="controller">Enforce Rules</label>
                                        <span><p>Enable Graph API</p></span>
                                        <div class="col-lg-4" style="padding-left:0%;">
<label class="switch">
                                            <input id="graphApiEnabled" type="checkbox" name="graphApiEnabled" value="true">
                                            <div class="slider round"></div>
                                            </label>
                                        </div>
                                    </div>
</div>
                            <div class="row col-lg-12">
                                <button style="margin-right: 5px;" type="submit" class="btn btn-success pull-right licenseSave">Save</button>
                            </div>
                        </form>
                    </div>-->


                    <!--start add-->
                <div class="modal fade" id="addKey" tabindex="-1" role="dialog">
                    <div class="modal-dialog">
                        <div class="modal-content <?php if(!isMobile()){ ?>mediumModal<?php } ?>">
                            <form class="licenseKeyForm" data-parsley-validate enctype="multipart/form-data">
                                        <div class="modal-header">
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                            <h4 class="modal-title"><?=Language::show('Upload New License Key', 'keywords')?></h4>
                                        </div>
                                        <div class="modal-body">
                                            <div class="row">
                                                    <div class="col-lg-12">
                                                        Select License Key to upload : <input type="file" name="licenseKeyFileName" id="licenseKeyFileName" accept=".pblic" required>
                                                        <?php if(isMobile()){ ?>
                                                        <span class="help-line text-muted">Note:- Upload feature is available from your workstation.</span>
                                                        <?php } ?>
                                                    </div>
<div class="row col-lg-8">
                                                    <div id="progress-div-win" style="display:none;">
                                                        <div id="progress-bar-win"></div>
                                                    </div>
                                                    <div id="targetLayerWin"></div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-success addLicenseKeyBtn"><?=Language::show('Upload', 'keywords')?></button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal"><?=Language::show('Close', 'keywords')?></button>
                                        </div>
                                        </form>
                        </div>
                    </div>
                </div>
                <!--end add -->
<!-- confirm start -->
<div class="modal fade forceUpload" id="forceUpload" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Upload Confirmation</h4>
                        </div>
                        <div class="modal-body">
                            <h4 class="modal-title">A license key with the same name already exists.  Are you sure you wish to upload and overwrite the license key?</h4>
                        </div>
<div class="modal-footer">
<button type="button" class="btn btn-default" ng-click="forceUpload()">Yes</button>
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!-- confirm end -->
<!--view modal start-->
<div class="modal" id="paraviewContainer" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h5 class="modal-title">Loading ...</h5>
                        </div>
                        <br/><br/>
                        <div class="modal-body">
                            <div class="pageContainer" style="display: none;"></div>
                            <div class="pdfContainer" style="display: none;"></div>
                            <div class="excelContainer" style="display: none;"></div>
                            <div class="content" style="display: none;text-align: left;"></div>
                            <div class="imageViewer" style="display: none;"></div>
                            <div class="paraviewLoading" style="margin-top: 15%">
                                <img width="5%" src="<?=Url::templatePath('default/images/gears.gif');?>" />
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" class="btn btn-primary">Save changes</button>
                        </div>
                    </div>
                </div>
            </div>
<!--view modal ends-->
<!-- view start -->
<div class="modal fade viewww" id="viewww" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title">View License Key - <span class="fileNameTitle"></span></h4>
                        </div>
                        <div class="modal-body">
                         <div class="row">
                            <div class="form-group col-lg-6">
                                <label for="cloudName">Cloud Name </label>
                                <input type="text" class="form-control" name="cloudName" id="cloudName" value="" placeholder="Enter your cloud name" required autocomplete="off" readonly>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="noOfUsersAllowed">Total Number of Users allowed</label>
                                <input type="number" class="form-control" name="noOfUsersAllowed" id="noOfUsersAllowed" value="" placeholder="Enter total number of users allowed" required autocomplete="off" readonly>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="noOfBackupUsersAllowed">Number of Backup Users allowed</label>
                                <input type="number" class="form-control" name="noOfBackupUsersAllowed" id="noOfBackupUsersAllowed" value="" placeholder="Enter number of backup users allowed" required autocomplete="off" readonly>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="noOfSyncUsersAllowed">Number of Sync Users allowed</label>
                                <input type="number" class="form-control" name="noOfSyncUsersAllowed" id="noOfSyncUsersAllowed" value="" placeholder="Enter number of sync users allowed" required autocomplete="off" readonly>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="noOfOdbBackupUsersAllowed">Number of OneDrive Backup users allowed</label>
                                <input type="number" class="form-control" name="noOfOdbBackupUsersAllowed" id="noOfOdbBackupUsersAllowed" value="" placeholder="Enter number of OneDrive backup users allowed" required autocomplete="off" readonly>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="noOfDevicesAllowed">Number of Devices allowed</label>
                                <input type="number" class="form-control" name="noOfDevicesAllowed" id="noOfDevicesAllowed" value="" placeholder="Enter number of devices allowed" required autocomplete="off" readonly>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="versioningEnabled">Number of Versions allowed</label>
                                <input type="number" class="form-control" name="versioningEnabled" id="versioningEnabled" value="" placeholder="Enter number of versions allowed" required autocomplete="off" readonly>
                            </div>
                            <div class="form-group col-lg-6">
                                <label for="noOfMiniCloudsAllowed">Number of MiniClouds allowed</label>
                                <input type="number" class="form-control" name="noOfMiniCloudsAllowed" id="noOfMiniCloudsAllowed" value="" placeholder="Enter number of miniclouds allowed" required autocomplete="off" readonly>
                            </div>
                            <div class="form-group col-lg-6">
                                    <label for="validityPeriod">Validity Period</label>
                                    <input type="text" class="form-control" name="validityPeriod" id="validityPeriod" placeholder="Enter validity period" required readonly>
                            </div>
                            <div class="form-group col-lg-6" style="margin-bottom:20px;">
                                <label for="contentSearchEnabled">Search Enabled</label>
                                <select class="form-control contentSearchEnabled" name="contentSearchEnabled">
                                    <option value="true"><?=Language::show('enabled', 'keywords')?></option>
                                    <option value="false"><?=Language::show('disabled', 'keywords')?></option>
                                </select>
                            </div>
                            <div class="form-group col-lg-6">
                                    <label for="cloudSizeAllowed">Cloud Size Allowed (in GB)</label>
                                    <input type="text" class="form-control" name="cloudSizeAllowed" id="cloudSizeAllowed" placeholder="cloudSizeAllowed" required readonly>
                                    </div>
                            </div>
                        </div>
<div class="modal-footer">
<!--<button type="button" class="btn btn-default" ng-click="forceUpload()">Yes</button>-->
          <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!-- view end -->
<!--confirm start-->
<div class="modal fade applyConfirm" style="z-index: 1000000000;" data-backdrop="static" data-keyboard="false">
<div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <!--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>-->
                            <h4 class="modal-title">Confirmation</h4>
                            </div>
                        <div class="modal-body">
<span class="hide" id='fileNameForAction'></span>
                            <h4 class="modal-title">This operation will result in applying the license key <span id="fileNameForActionn" style="color: #f27331;"></span> to the system.  This operation cannot be undone and will require restarting all services on the Paracloud and all the component servers.  Are you sure you wish to continue?</h4>

                        </div>
                        <div class="modal-footer">
          <button type="button" class="btn btn-primary" ng-click="licenseKeyAction(abc, 'apply')">Ok</button>
          <button type="button" class="btn btn-default" data-dismiss="modal">Cancel </button>
                        </div>
                    </div>
                </div>
            </div>
<!--confirm ends-->
</div>
</div>
        </div>
    </div>
    <?php View::renderTemplate('partials/search', $data); ?>
</div><!-- /.container -->
<?php View::renderTemplate('partials/scripts')?>
<script src="<?=Url::templatePath()?>js/angular/controllers/SettingController.js?<?=VERSIONS_NUMBER?>" type="text/javascript"></script>
<script>
$("[data-toggle=tooltip]").tooltip({
    placement: $(this).data("placement") || 'right'
});

$('#validityPeriod').datepicker({
        format: 'dd-M-yyyy',
                autoclose: true,
                startDate: '-1y',
        endDate: '+1y',
        todayHighlight: true
});
</script>
<style>
 .switch {
   position: relative;
   display: inline-block;
   width: 60px;
   height: 34px;
 }

 .switch input {display:none;}

 .slider {
   position: absolute;
   cursor: pointer;
   top: 0;
   left: 0;
   right: 0;
   bottom: 0;
   background-color: #ccc;
   -webkit-transition: .4s;
   transition: .4s;
 }

 .slider:before {
   position: absolute;
   content: "";
   height: 26px;
   width: 26px;
   left: 4px;
   bottom: 4px;
   background-color: white;
   -webkit-transition: .4s;
   transition: .4s;
 }
input:checked + .slider {
   background-color: #2196F3;
 }
 input:focus + .slider {
   box-shadow: 0 0 1px #2196F3;
 }

 input:checked + .slider:before {
   -webkit-transform: translateX(26px);
   -ms-transform: translateX(26px);
   transform: translateX(26px);
 }
 /* Rounded sliders */
 .slider.round {
   border-radius: 34px;
 }

 .slider.round:before {
   border-radius: 50%;
 }
 </style>

<style>
#progress-bar-win {background-color: #f27331;height:20px;color: #FFFFFF;width:0%;-webkit-transition: width .3s;-moz-transition: width .3s;transition: width .3s;}

#progress-div-win {border:#f27331 1px solid;padding: 5px 0px;margin:30px 0px;border-radius:4px;text-align:center;}

#targetLayerWin{width:100%;text-align:center;}
td:nth-child(2) {
white-space: unset !important;
}
</style>
